

CREATE TABLE `ma_country` (
  `country_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country_code` varchar(2) NOT NULL,
  `country_name` varchar(45) NOT NULL,
  `status` int(10) unsigned DEFAULT '1',
  `orderby` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`country_id`,`country_code`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO ma_country VALUES("1","CA","Canada","1","1");





CREATE TABLE `ma_grades` (
  `grade_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `grade_name` varchar(45) NOT NULL,
  `status` int(10) unsigned DEFAULT '1',
  `orderBy` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`grade_id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;

INSERT INTO ma_grades VALUES("1","Preschool","1","1");
INSERT INTO ma_grades VALUES("2","Kindergarten","1","2");
INSERT INTO ma_grades VALUES("3","Grade 1","1","3");
INSERT INTO ma_grades VALUES("4","Grade 2","1","4");
INSERT INTO ma_grades VALUES("5","Grade 3","1","5");
INSERT INTO ma_grades VALUES("6","Grade 4","1","6");
INSERT INTO ma_grades VALUES("7","Grade 5","1","7");
INSERT INTO ma_grades VALUES("8","Grade 6","1","8");
INSERT INTO ma_grades VALUES("9","Grade 7","1","9");
INSERT INTO ma_grades VALUES("10","Grade 8","1","10");
INSERT INTO ma_grades VALUES("11","STAFF","1","11");
INSERT INTO ma_grades VALUES("12","UNKNOWN","1","12");
INSERT INTO ma_grades VALUES("13","srinivasg2","0","132");





CREATE TABLE `ma_itemtype` (
  `itemtype_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `itemcode` varchar(2) DEFAULT NULL,
  `item_type` varchar(45) NOT NULL,
  `status` int(10) unsigned DEFAULT '1',
  `orderby` int(10) unsigned DEFAULT '0',
  `pprice` double DEFAULT NULL,
  PRIMARY KEY (`itemtype_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

INSERT INTO ma_itemtype VALUES("1","R","Regular","1","1","4");
INSERT INTO ma_itemtype VALUES("2","C","Complete","1","4","6");
INSERT INTO ma_itemtype VALUES("3","X","Extra Large Complete","1","7","7");
INSERT INTO ma_itemtype VALUES("4","H","Regular Halal","1","2","4");
INSERT INTO ma_itemtype VALUES("5","L","Complete Halal","1","5","6");
INSERT INTO ma_itemtype VALUES("6","Z","Extra Large Complete Halal","1","8","7");
INSERT INTO ma_itemtype VALUES("7","O","Gluten Free","1","3","4");
INSERT INTO ma_itemtype VALUES("8","P","Complete Gluten Free","1","6","6");
INSERT INTO ma_itemtype VALUES("9","Q","Extra Large Complete Gluten Free","1","9","7");





CREATE TABLE `ma_menutype` (
  `mtype_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `menu_type` varchar(45) NOT NULL,
  `status` int(10) unsigned DEFAULT '1',
  `orderby` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`mtype_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO ma_menutype VALUES("1","Lunch","1","1");
INSERT INTO ma_menutype VALUES("2","Snack","1","2");
INSERT INTO ma_menutype VALUES("3","Drinks","1","3");





CREATE TABLE `ma_schoolyear` (
  `syID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `syName` varchar(45) NOT NULL,
  `sStatus` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`syID`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO ma_schoolyear VALUES("1","2009-2010","1");
INSERT INTO ma_schoolyear VALUES("2","2010-2011","1");





CREATE TABLE `ma_states` (
  `state_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country_id` int(10) unsigned DEFAULT '1',
  `state_code` varchar(2) NOT NULL,
  `state_name` varchar(45) NOT NULL,
  `status` int(10) unsigned DEFAULT '1',
  `orderby` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`state_id`),
  KEY `fk_sCountry` (`country_id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;

INSERT INTO ma_states VALUES("1","1","ON","Ontario","1","1");
INSERT INTO ma_states VALUES("2","1","QC","Quebec","1","2");
INSERT INTO ma_states VALUES("3","1","BC","British Columbia","1","3");
INSERT INTO ma_states VALUES("4","1","YK","Yukon","1","4");
INSERT INTO ma_states VALUES("5","1","NT","Northwest Territories","1","5");
INSERT INTO ma_states VALUES("6","1","NU","Nunavut","1","6");
INSERT INTO ma_states VALUES("7","1","AB","Alberta","1","7");
INSERT INTO ma_states VALUES("8","1","SK","Saskatchewan","1","8");
INSERT INTO ma_states VALUES("9","1","MB","Manitoba","1","9");
INSERT INTO ma_states VALUES("10","1","NL","Newfoundland and Labrador","1","10");
INSERT INTO ma_states VALUES("11","1","PE","Prince Edward Island","1","11");
INSERT INTO ma_states VALUES("12","1","NB","New Brunswick","1","12");
INSERT INTO ma_states VALUES("13","1","NS","Nova Scotia","1","13");





CREATE TABLE `payments` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `txnid` varchar(20) NOT NULL,
  `payment_amount` decimal(7,2) NOT NULL,
  `payment_status` varchar(25) NOT NULL,
  `itemid` varchar(25) NOT NULL,
  `createdtime` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;






CREATE TABLE `paypal` (
  `slno` int(11) NOT NULL AUTO_INCREMENT,
  `paypal_id` varchar(45) NOT NULL,
  `status` varchar(2) NOT NULL,
  PRIMARY KEY (`slno`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO paypal VALUES("1","ecommerce@smashhitsolutions.com","1");





CREATE TABLE `tr_adminaccount` (
  `account_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_name` varchar(65) NOT NULL,
  `user_name` varchar(25) DEFAULT NULL,
  `account_ref` varchar(15) NOT NULL,
  `account_email` varchar(45) DEFAULT NULL,
  `date_lastlog` datetime DEFAULT NULL,
  `account_status` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`account_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO tr_adminaccount VALUES("1","Jun Apor","junapor","ohY9ielae","jun.apor@microforum.ca","2011-04-14 09:47:18","1");
INSERT INTO tr_adminaccount VALUES("2","Noble Musa","noble","mrs","noble.musa@microforum.ca","2012-12-30 00:00:00","1");





CREATE TABLE `tr_ingredient` (
  `ingredient_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` int(10) unsigned NOT NULL,
  `ingredient_desc` text,
  `status` int(10) unsigned DEFAULT '1',
  PRIMARY KEY (`ingredient_id`),
  KEY `fk_iMenu` (`menu_id`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=latin1;

INSERT INTO tr_ingredient VALUES("1","1","Chicken stock, pureed plum tomatos, celery, carrots, onions, garlic, alphabet pasta.","1");
INSERT INTO tr_ingredient VALUES("2","2","Great source of fibre, calcium, protein, iron.  Hidden ingredient - puree carrots, when carrots are cooked down their tough cell walls are broken down making 4-5 times more beta carotene available for absorption by the body.  Great source of fibre, vitamin B1, B2, and vitamin C.","1");
INSERT INTO tr_ingredient VALUES("3","3","Butter, pasta water, parmesan cheese, spaghetti","1");
INSERT INTO tr_ingredient VALUES("4","4","Breaded white chicken tenders, parboiled white rice, steamed julienned carrots
\n","1");
INSERT INTO tr_ingredient VALUES("5","5","Romaine lettuce, diced poached chicken breasts, parmesan cheese, croutons, Caesar salad dressing","1");
INSERT INTO tr_ingredient VALUES("6","6","Tomato sauce*, 100% lean ground beef, and penne pasta","1");
INSERT INTO tr_ingredient VALUES("7","7","Roasted drum stick, two-potato mash (mashed potato/sweet potato) <br/>Cranberry sauce - cranberries, sugar <br/>sweet corn","1");
INSERT INTO tr_ingredient VALUES("8","8","Whole wheat toast, cheddar cheese, and bacon","1");
INSERT INTO tr_ingredient VALUES("9","9","Flour, baking powder, salt, sugar, eggs, milk, butter, blueberries","1");
INSERT INTO tr_ingredient VALUES("10","10","Whole wheat pita bread, breaded white chicken nuggets, shredded iceberg lettuce, shredded carrots, ranch dressing","1");
INSERT INTO tr_ingredient VALUES("11","19","Flour, rolled oats, baking powder, salt, milk, brown sugar, butter, corn syrup, eggs, vanilla, semi-sweet chocolate chips","1");
INSERT INTO tr_ingredient VALUES("12","15","Bananas, flour, oat bran, sugar, butter, eggs, baking soda, baking powder, salt, flax seeds","1");
INSERT INTO tr_ingredient VALUES("13","20","Flour, whole wheat flour, sugar, baking powder, baking soda, salt, apples, cinnamon","1");
INSERT INTO tr_ingredient VALUES("14","21","Flour, baking powder, salt, milk, butter, sugar, eggs, vanilla, lemon rind, blueberries","1");
INSERT INTO tr_ingredient VALUES("15","22","Flour, baking powder, baking soda, cinnamon, salt , raisins, eggs, brown sugar, vegetable oil, vanilla, puree pumpkin","1");
INSERT INTO tr_ingredient VALUES("16","31","Fresh chicken,  potatoes, onions,  carrots, celery, fresh herbs and  a bay leaf.  A great source of vitamin A, protein and complex carbohydrates.  A bonus, the stock contains some calcium leached from the bones during the cooking process.
\n","1");
INSERT INTO tr_ingredient VALUES("17","32","Yukon gold potato, sweet potato, extra lean ground beef, onions and cabbage.  Hidden ingredients - cabbage and onions.  Rich in proteins and calcium and vitamin C.
\n","1");
INSERT INTO tr_ingredient VALUES("18","33","Plum tomatoes simmered with carrots, roasted red pepper, onions and garlic, fresh herbs and a bay leaf  then  pureed to a silky smooth consistency. Antioxident boost, loaded with veggies and healthy fats.
\n","1");
INSERT INTO tr_ingredient VALUES("19","34","Vegetable Samosas - flour, water, potato, peas, all spice, curry powder
\nHummus- chick peas, olive oil, lemon juice
\n","1");
INSERT INTO tr_ingredient VALUES("20","35","Whole wheat pita pocket, romaine lettuce Parmesan cheese, croutons, ceasar dressing  Hidden ingredient - sardines in the dressing  Sardines have a high concentration of omega 3 fatty acids, also a great source of vitamin D.
\n","1");
INSERT INTO tr_ingredient VALUES("21","49","Flour, water, potato, salt, filling (mashed potato, puree cauliflower, cheddar cheese)","1");
INSERT INTO tr_ingredient VALUES("22","48","Tomato sauce*, lean ground beef, ziti pasta, mozzarella cheese","1");
INSERT INTO tr_ingredient VALUES("23","50","Chicken drum stick, BBQ sauce (brown sugar, orange juice, dry mustard, ketchup) OR crispy white meat chicken tenders, parboiled 
\n      rice, crispy carrot sticks","1");
INSERT INTO tr_ingredient VALUES("24","51","Fillet of haddock dredged in tempura batter, yukon gold potatos, sweet potato, olive oil, sea salt","1");
INSERT INTO tr_ingredient VALUES("25","52","Poached chicken breast, romaine lettuce, mandarin oranges, crunch asian noodles, asian dressing (olive oil, honey, orange  
\n     juice, crushed garlic, grated fresh ginger, salt
\n","1");
INSERT INTO tr_ingredient VALUES("26","53","Flour, cornmeal,  baking powder, baking soda, salt, butter, eggs, milk, broccoli, ham, cheddar cheese","1");
INSERT INTO tr_ingredient VALUES("27","54","Crispy white chicken tenders, romaine lettuce, croutons, caesar dressing, whole wheat tortilla","1");
INSERT INTO tr_ingredient VALUES("28","64","A quarter pound all beef burger, no fillers, on a whole wheat bun","1");
INSERT INTO tr_ingredient VALUES("29","36","Whole wheat bread dipped in egg wash - eggs, milk, purreed sweet potato, cinnamon","1");
INSERT INTO tr_ingredient VALUES("30","95","aaaa","1");





CREATE TABLE `tr_menu` (
  `menu_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `menu_code` varchar(2) DEFAULT NULL,
  `menu_name` varchar(45) NOT NULL,
  `menu_details` varchar(200) DEFAULT NULL,
  `menu_type` int(10) unsigned DEFAULT '1',
  `status` int(10) unsigned DEFAULT '1',
  `orderby` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`menu_id`),
  KEY `fk_mMenuType` (`menu_type`)
) ENGINE=MyISAM AUTO_INCREMENT=98 DEFAULT CHARSET=latin1;

INSERT INTO tr_menu VALUES("1","A","Alphabet soup","Lots of veggies pureed in a tomato sauce, alphabet pasta with a swirl of parmesan cheese, served with garlic bread.","1","1","1");
INSERT INTO tr_menu VALUES("2","B","Mighty Mac","The favourite of North American comfort food, with added Lunch Pails nutrition, pureed carrots!","1","1","2");
INSERT INTO tr_menu VALUES("3","C","Buttery Pasta","Spaghetti tossed with creamy butter and parmesan sauce, served with a side of crunchy vegetables.","1","1","3");
INSERT INTO tr_menu VALUES("4","D","Chicken Tenders","Juicy white-meat only chicken tenders, served over a bed of fluffy white rice with a side of steamed julienned carrots.","1","1","4");
INSERT INTO tr_menu VALUES("5","E","Chicken Ceasar Salad","White meat only - served with crispy romaine lettuce, parmesan cheese, croutons and Caesar salad dressing.","1","1","5");
INSERT INTO tr_menu VALUES("6","F","Pasta Bolognese","Homemade tomato and meat sauce served over penne pasta.","1","0","6");
INSERT INTO tr_menu VALUES("7","G","Festive Meal","Roasted chicken served with two-potato mash, a side of sweet corn and cranberry sauce.","1","0","7");
INSERT INTO tr_menu VALUES("8","H","Chicken Burger","White meat only!  Baked and served on a bun with a side of ketchup, lettuce and tomato.","1","0","8");
INSERT INTO tr_menu VALUES("9","U","(U) Morning Glory - Fluffy Pancakes","Light and Fluffy, served with syrup.","1","0","9");
INSERT INTO tr_menu VALUES("10","J","Stuffed Chicken Pita","Breaded white nuggets, lettuce, shredded carrots and ranch dressing in a whole wheat pita.","1","0","10");
INSERT INTO tr_menu VALUES("11","K","Around the World -Taco Fiesta!","Seasoned lean ground beef, rice, cheddar cheese, rolled in a soft tortilla & served with a side of salsa.","1","1","11");
INSERT INTO tr_menu VALUES("12","1","Fresh vegetables or fruits","","2","1","1");
INSERT INTO tr_menu VALUES("13","2","Cookie","","2","1","2");
INSERT INTO tr_menu VALUES("14","c","Cookie","","2","1","3");
INSERT INTO tr_menu VALUES("15","d","Loaf","","2","1","4");
INSERT INTO tr_menu VALUES("16","e","Waffles or pancakes with jam","","2","1","5");
INSERT INTO tr_menu VALUES("17","f","Pudding","","2","1","6");
INSERT INTO tr_menu VALUES("18","g","Yogurt","","2","1","7");
INSERT INTO tr_menu VALUES("19","h","Cookie","","2","1","8");
INSERT INTO tr_menu VALUES("20","3","Muffin","","2","1","9");
INSERT INTO tr_menu VALUES("21","j","Muffin","","2","1","10");
INSERT INTO tr_menu VALUES("22","k","Muffin","","2","1","11");
INSERT INTO tr_menu VALUES("23","Z1","White Rice Only","Special Request Item Fluffy white rice with a dab of butter","1","0","35");
INSERT INTO tr_menu VALUES("24","Z2","Penne No Sauce","Special Request Item Al -dente with a dab of butter","1","0","36");
INSERT INTO tr_menu VALUES("25","Z3","Gluten Free Pasta Pomodoro","Special Request Item Rice pasta served with Lunch Pails tomato sauce","1","0","37");
INSERT INTO tr_menu VALUES("26","Z4","Gluten Free Mac and Cheese","Special Request Item Rice macaroni served up with Lunch Pails added nutrition","1","1","38");
INSERT INTO tr_menu VALUES("27","Z5","Gluten Free Chicken Ceasar Salad","NO CROUTONS!
\nSpecial Request Item Crispy romaine lettuce, white chicken only, parmesan cheese served up with creamy ceasar dressing","1","1","39");
INSERT INTO tr_menu VALUES("28","Z","Gluten Free Grilled Cheese","Special Request Item Served on rice bread with crispy bacon","1","0","34");
INSERT INTO tr_menu VALUES("29","Z6","Gluten Free morning glory","Special Request Item Light and fluffy breakfast omelette.","1","0","40");
INSERT INTO tr_menu VALUES("30","Z7","Grilled Cheese NO BACON","Special Request Item
\nNO BACON served on whole wheat bread","1","0","41");
INSERT INTO tr_menu VALUES("31","L","(L)  Creamy chicken and vegetable soup","A hearty soup for a blustery day!  An abundance of seasonal root vegetables pureed until smooth with cubed chicken served with crust bread.","1","0","17");
INSERT INTO tr_menu VALUES("32","M","Shephards Pie","This old timer gets a make over with a creamy two potato mash topping. Extra lean ground beef in a rich beef gravy.","1","1","19");
INSERT INTO tr_menu VALUES("33","N","Pasta al Pomodoro","Penne pasta tossed with our homemade tomato suace topped with parmesan cheese (added Lunch Pail\'s nutrition)","1","0","20");
INSERT INTO tr_menu VALUES("34","K2","Around the world! - Off to India we go","Vegetable Samosas served with Lunch Pails Hummus (no sesame) and fresh cut vegetables","1","0","12");
INSERT INTO tr_menu VALUES("35","O","Hail Caesar","The most popular salad, it has plenty of zing. Crispy all-white chicken, romaine lettuce, parmesan cheese served in a whole wheat pita.","1","0","22");
INSERT INTO tr_menu VALUES("36","P","Fortified French Toast","Whole wheat bread smothered in a delicious, nutritious, batter.","1","0","24");
INSERT INTO tr_menu VALUES("37","X","Birthday Party Treats !!!","Special days deserve some fun, let the Lunch Pails staff make it happen.  Give us a call!","1","0","33");
INSERT INTO tr_menu VALUES("38","Z8","Plain Pancakes","Special Request Item Light and fluffy buttermilk pancakes served with syrup","1","0","42");
INSERT INTO tr_menu VALUES("39","Z9","Festive Meal - NO CRANBERRIES","Special Request Item","1","0","43");
INSERT INTO tr_menu VALUES("40","K3","Gluten Free Tacos","Special Request Item  Extra lean seasoned ground beef and rice layered with cheddar and baked until bubbly.  Served with crispy organic corn chips and homemade salsa","1","1","13");
INSERT INTO tr_menu VALUES("41","O1","Gluten free Hail Caesar","Special Request Item Crispy romaine lettuce, white meat only, parmesan cheese served with creamy caesar dressing","1","0","23");
INSERT INTO tr_menu VALUES("42","P1","Gluten Free Fortified French Toast","Special Request Item Rice bread smothered in delicious, nutritious batter","1","0","25");
INSERT INTO tr_menu VALUES("43","L1","Gluten Free Chicken and Vegetable Soup","Special Request Item A hearty soup for a blustery day!  Tender chunks of chicken in a creamy homemade broth
\n","1","0","18");
INSERT INTO tr_menu VALUES("44","K4","Tacos no cheddar cheese","Special Request Item Two warm whole wheat tortillas wrapped with extra lean seasoned ground beef and rice, served with homemade salsa","1","1","14");
INSERT INTO tr_menu VALUES("45","R","Chicken Nuggets with White Rice","Special Request Item  White Meat only served over a bed of fluffy white rice","1","1","27");
INSERT INTO tr_menu VALUES("46","K5","Tacos  No Rice","Special Reqest Item Two warm whole wheat tortillas wraps filled with seasoned extra lean ground beef and cheddar cheese, served with homemade salsa","1","1","15");
INSERT INTO tr_menu VALUES("47","N1","Pasta Pomodoro- No Parm","Special request item","1","0","21");
INSERT INTO tr_menu VALUES("48","Q","Oodles of Noodles","Tubed-shaped pasta tossed with a hearty tomato and meat sauce baked in layers with cheese until bubbly","1","0","26");
INSERT INTO tr_menu VALUES("49","K6","Around the world-  Perogies!","Hand rolled cheddar cheese and potato perogies topped with a dab of butter and a side of sour cream","1","1","16");
INSERT INTO tr_menu VALUES("50","R1","Kickin\' Chicken","Roasted chicken drum stick in our own zesty BBQ sauce served with fluffy white rice and a side of carrots","1","0","28");
INSERT INTO tr_menu VALUES("51","S","To the Seaside - Fish & Chips","Crispy coated and baked fish sticks served with potato, and sweet potato
\nwedges with a side of ranch dip","1","1","29");
INSERT INTO tr_menu VALUES("52","T","Mandarin Chicken Salad","Poached chicken breast tossed with lettuce, mandarin oranges and crunchy Asian noodles served with an Asian-style dressing","1","0","30");
INSERT INTO tr_menu VALUES("53","U","Morning Glory - Savoury Muffin","A savoury ham, broccoli and cheddar muffin with a touch of cornmeal, served with a side of fruit salad.","1","0","31");
INSERT INTO tr_menu VALUES("54","V","All wrapped up!  Chicken Caesar","Crispy lettuce, white meat only, Caesar dressing, and croutons all wrapped up in a whole wheat tortilla","1","0","32");
INSERT INTO tr_menu VALUES("55","QV","Oodles of noodles / vegetarian","Tubed-shaped pasta tossed with Lunch Pails tomato sauce baked in layers with cheese until bubbly.","1","0","44");
INSERT INTO tr_menu VALUES("56","TG","Gluten Free Mandarin Chicken Salad","Poached chicken breast tossed with lettuce, mandarin oranges, served with Asian-style dressing","1","0","46");
INSERT INTO tr_menu VALUES("57","QG","Gluten Free Oodles of Noodles","Tubed shaped rice pasta tossed with a hearty tomato and meat sauce baked in layers with cheese until bubbly","1","0","45");
INSERT INTO tr_menu VALUES("58","SP","Fish and Chips - No Sweet Potato","Crispy coated and baked fish sticks served with potato wedges and a side of ranch","1","0","47");
INSERT INTO tr_menu VALUES("59","SF","Fish in own form","Special request - Fish in its own form","1","0","48");
INSERT INTO tr_menu VALUES("60","QN","Oodles of noodls- NO CHEESE","Special Request Item","1","0","49");
INSERT INTO tr_menu VALUES("61","kN","Perogies NO CHEDDAR","Special request item","1","0","50");
INSERT INTO tr_menu VALUES("62","K7","Around the World!  Falafels!","Off to the Middle East... homemade falafels wrapped up with homemade tabouli and hummus. (No sesame).","1","0","51");
INSERT INTO tr_menu VALUES("63","U1","Morning Glory - Homemade Quiche","Homemade egg, cheese and ham, crustless quiche served with a home-baked muffin and seasonal fresh fruit.","1","0","52");
INSERT INTO tr_menu VALUES("64","W","The Great Canadian Burger","A Quarter pound all-beef barbecued hamburger served on a whole wheat bun with a side of ketchup and mustard","1","0","53");
INSERT INTO tr_menu VALUES("65","X1","Chicken Fajitas - served hot!","Barbecued tender strips of chicken, bell peppers, shredded cheese and rice rolled in a tortilla, served with a side of sour cream.","1","0","54");
INSERT INTO tr_menu VALUES("66","XV","Vegetarian Fajitas","","1","0","55");
INSERT INTO tr_menu VALUES("67","WV","Vegetarian Burger","","1","0","56");
INSERT INTO tr_menu VALUES("68","XN","Chicken Fajitas-NO CHEDDAR-","","1","0","57");
INSERT INTO tr_menu VALUES("69","UO","Egg Omelete","","1","0","58");
INSERT INTO tr_menu VALUES("70","XP","Fajitas     - NO PEPPERS-","","1","0","59");
INSERT INTO tr_menu VALUES("71","SP","Spagetti - NO SAUCE","","1","0","60");
INSERT INTO tr_menu VALUES("72","WG","Gluten Free Great Canadian Burger","","1","0","61");
INSERT INTO tr_menu VALUES("73","XG","Gluten Free Fajitas","","1","0","62");
INSERT INTO tr_menu VALUES("74","KG","Gluten Free Falafels","","1","0","63");
INSERT INTO tr_menu VALUES("75","3","Bottled Water","","3","1","3");
INSERT INTO tr_menu VALUES("76","1","Apple Juice","","3","1","1");
INSERT INTO tr_menu VALUES("77","2","Orange Juice","","3","1","2");
INSERT INTO tr_menu VALUES("78","D1","Chicken Nuggets ONLY","","1","1","64");
INSERT INTO tr_menu VALUES("79","D3","Chicken Tenders with Mashed Potatoes","White Meat Only!  Juicy chicken tenders with a side of creamy mashed potatoes and steamed julienned carrots","1","0","58");
INSERT INTO tr_menu VALUES("80","D3","Chicken Tenders with Mashed Potatoes","White Meat Only!  Juicy chicken tenders with a side of creamy mashed potatoes and steamed julienned carrots","1","1","65");
INSERT INTO tr_menu VALUES("81","SS","Snack ONLY","","1","0","67");
INSERT INTO tr_menu VALUES("82","E1","Ceasar Salad  NO CHICKEN","Crispy romaine lettuce, parmesan cheese, croutons served with a creamy Caesar dressing","1","1","68");
INSERT INTO tr_menu VALUES("83","CG","Buttery Pasta - Whole wheat pasta","Whole wheat pasta tossed in butter and parmesan cheese","1","0","69");
INSERT INTO tr_menu VALUES("84","H1","Chicken Burger Gluten Free No Bun","","1","0","57");
INSERT INTO tr_menu VALUES("85","Q1","Oodles of Chicken Noodles","Tube shaped pasta tossed in a hearty tomato and chicken sauce baked in layers with cheese","1","0","34");
INSERT INTO tr_menu VALUES("86","E2","Ceasar Salad - NO PARM-","Special Request item","1","1","70");
INSERT INTO tr_menu VALUES("87","U1","Morning Glory Waffles","Fluffy and Light served with a side of syrup","1","1","69");
INSERT INTO tr_menu VALUES("88","U2","Gluten Free Waffles","Gluten free waffles","1","1","69");
INSERT INTO tr_menu VALUES("89","C2","Gluten Free Buttery Pasta","Gluten free spaghetti tossed with creamy butter","1","1","69");
INSERT INTO tr_menu VALUES("90","D4","Gluten Free Chicken Tenders and Rice","White meat only!  Served over a bed of fluffy rice and a side of steamed vegetables","1","1","71");
INSERT INTO tr_menu VALUES("91","M1","Gluten Free Sheppards Pie","This classic meal gets a make over with creamy mashed potato, extra lean ground beef in a rich gravy.","1","1","72");
INSERT INTO tr_menu VALUES("92","M2","Sheppards Pie ( Chicken)","Sheppards PIE WITH GROUND CHICKEN","1","1","66");
INSERT INTO tr_menu VALUES("93","KC","KChicken Tacos","Seasoned lean ground chicken, rice and cheddar cheese rolled in a soft tortilla, served with a side of salsa","1","1","66");
INSERT INTO tr_menu VALUES("94","D","Chicken Tenders with pasta","Special Request item","1","0","73");
INSERT INTO tr_menu VALUES("95","C3","Buttery Pasta with Penne","Penne rigate pasta tossed in a creamy butter and parmesan sauce","1","1","74");
INSERT INTO tr_menu VALUES("96","aa","abc","sample","0","1","1");
INSERT INTO tr_menu VALUES("97","AX","sample","dfdsffdfdsfds","0","1","10");





CREATE TABLE `tr_menuschool` (
  `msID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(10) unsigned NOT NULL,
  `msfile` varchar(65) NOT NULL,
  `status` int(10) unsigned DEFAULT '1',
  PRIMARY KEY (`msID`),
  KEY `fk_msSchool` (`school_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

INSERT INTO tr_menuschool VALUES("1","1","1_ih26823_kindree_public_school_2011_mar_-_apr.pdf","1");
INSERT INTO tr_menuschool VALUES("2","4","4_ih26822_escarpment_public_2011_mar_apr.pdf","1");
INSERT INTO tr_menuschool VALUES("3","3","../menuSchools/IH35505_Lester B Pearson 2012 Dec - Feb.pdf","1");
INSERT INTO tr_menuschool VALUES("4","2","2_ih26824_our_lady_of_fatima_2011_march_april.pdf","1");
INSERT INTO tr_menuschool VALUES("5","5","5_ih26826_guardian_2011_mar_apr.pdf","1");
INSERT INTO tr_menuschool VALUES("6","6","../menuSchools/newDragonSite.jpg","1");
INSERT INTO tr_menuschool VALUES("7","7","../menuSchools/IH35509_St Patricks 2012 Dec - Feb.pdf","1");





CREATE TABLE `tr_orderdetails` (
  `detail_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(10) unsigned NOT NULL,
  `service_date` datetime NOT NULL,
  `item_ordered` int(10) unsigned NOT NULL,
  `item_type` int(10) unsigned DEFAULT '0',
  `item_snack` int(10) unsigned DEFAULT '0',
  `item_drink` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`detail_id`),
  KEY `fk_oOrders` (`order_id`),
  KEY `fk_oItemType` (`item_type`),
  KEY `fk_oOrderMenu` (`item_ordered`)
) ENGINE=MyISAM AUTO_INCREMENT=24737 DEFAULT CHARSET=latin1;

INSERT INTO tr_orderdetails VALUES("1","1","2009-10-26 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("2","1","2009-10-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("3","2","2009-10-30 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4","3","2009-10-26 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5","3","2009-10-28 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6","3","2009-10-30 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7","4","2009-10-26 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8","5","2009-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9","6","2009-10-26 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("10","6","2009-10-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("11","6","2009-10-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("12","7","2009-10-26 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("13","7","2009-10-30 00:00:00","3","3","0","0");
INSERT INTO tr_orderdetails VALUES("14","8","2009-10-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("15","8","2009-10-30 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("16","9","2009-10-26 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("17","9","2009-10-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("18","10","2009-10-26 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("19","10","2009-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("20","10","2009-10-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("21","11","2009-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("22","12","2009-10-26 00:00:00","24","1","0","0");
INSERT INTO tr_orderdetails VALUES("23","12","2009-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("24","12","2009-10-30 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("25","13","2009-10-26 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("26","13","2009-10-28 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("27","14","2009-10-26 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("28","14","2009-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("29","15","2009-10-26 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("30","15","2009-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("31","15","2009-10-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("32","16","2009-10-30 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("33","17","2009-10-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("34","18","2009-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("35","19","2009-10-30 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("36","20","2009-10-26 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("37","20","2009-10-30 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("38","21","2009-10-30 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("39","22","2009-10-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("40","23","2009-10-26 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("41","24","2009-10-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("42","24","2009-10-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("43","24","2009-10-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("44","25","2009-10-28 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("45","26","2009-10-26 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("46","27","2009-10-30 00:00:00","4","5","0","0");
INSERT INTO tr_orderdetails VALUES("47","28","2009-10-26 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("48","29","2009-10-30 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("49","30","2009-10-28 00:00:00","26","1","0","0");
INSERT INTO tr_orderdetails VALUES("50","30","2009-10-30 00:00:00","25","1","0","0");
INSERT INTO tr_orderdetails VALUES("51","31","2009-10-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("52","32","2009-10-26 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("53","32","2009-10-28 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("54","32","2009-10-30 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("55","33","2009-10-26 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("56","33","2009-10-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("57","33","2009-10-30 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("58","34","2009-10-26 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("59","34","2009-10-28 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("60","34","2009-10-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("61","35","2009-10-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("62","36","2009-10-30 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("63","37","2009-10-26 00:00:00","1","4","0","0");
INSERT INTO tr_orderdetails VALUES("64","37","2009-10-28 00:00:00","3","4","0","0");
INSERT INTO tr_orderdetails VALUES("65","37","2009-10-30 00:00:00","4","4","0","0");
INSERT INTO tr_orderdetails VALUES("66","38","2009-10-26 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("67","39","2009-10-30 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("68","40","2009-10-26 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("69","40","2009-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("70","40","2009-10-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("71","41","2009-10-26 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("72","42","2009-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("73","43","2009-10-26 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("74","43","2009-10-28 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("75","43","2009-10-30 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("76","44","2009-10-30 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("77","45","2009-10-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("78","46","2009-10-26 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("79","46","2009-10-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("80","47","2009-10-26 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("81","47","2009-10-28 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("82","47","2009-10-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("83","48","2009-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("84","49","2009-10-26 00:00:00","1","4","0","0");
INSERT INTO tr_orderdetails VALUES("85","49","2009-10-28 00:00:00","5","4","0","0");
INSERT INTO tr_orderdetails VALUES("86","49","2009-10-30 00:00:00","3","4","0","0");
INSERT INTO tr_orderdetails VALUES("87","50","2009-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("88","51","2009-10-26 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("89","51","2009-10-28 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("90","51","2009-10-30 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("91","52","2009-10-30 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("92","53","2009-10-28 00:00:00","4","4","0","0");
INSERT INTO tr_orderdetails VALUES("93","54","2009-10-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("94","55","2009-11-06 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("95","55","2009-11-13 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("96","55","2009-11-20 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("97","55","2009-11-27 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("98","55","2009-12-11 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("99","56","2009-11-02 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("100","56","2009-11-06 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("101","56","2009-11-16 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("102","56","2009-11-20 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("103","56","2009-11-23 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("104","56","2009-11-27 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("105","56","2009-11-30 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("106","56","2009-12-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("107","56","2009-12-11 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("108","56","2009-12-14 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("109","56","2009-12-18 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("110","57","2009-11-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("111","57","2009-11-27 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("112","58","2009-11-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("113","58","2009-11-16 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("114","58","2009-11-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("115","58","2009-11-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("116","58","2009-12-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("117","58","2009-12-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("118","59","2009-11-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("119","59","2009-11-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("120","59","2009-11-27 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("121","59","2009-12-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("122","59","2009-12-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("123","60","2009-11-02 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("124","60","2009-11-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("125","60","2009-11-23 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("126","60","2009-11-30 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("127","60","2009-12-07 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("128","60","2009-12-14 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("129","61","2009-11-02 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("130","61","2009-11-04 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("131","61","2009-11-16 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("132","61","2009-11-18 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("133","61","2009-11-23 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("134","61","2009-11-25 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("135","61","2009-12-07 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("136","61","2009-12-09 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("137","61","2009-12-14 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("138","61","2009-12-16 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("139","62","2009-11-02 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("140","62","2009-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("141","62","2009-11-11 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("142","62","2009-11-16 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("143","62","2009-11-18 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("144","62","2009-11-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("145","62","2009-11-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("146","62","2009-12-02 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("147","62","2009-12-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("148","62","2009-12-09 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("149","62","2009-12-14 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("150","62","2009-12-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("151","63","2009-11-02 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("152","63","2009-11-18 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("153","63","2009-11-27 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("154","63","2009-12-07 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("155","63","2009-12-14 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("156","64","2009-11-02 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("157","64","2009-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("158","64","2009-11-06 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("159","64","2009-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("160","64","2009-11-13 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("161","64","2009-11-16 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("162","64","2009-11-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("163","64","2009-11-20 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("164","64","2009-11-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("165","64","2009-11-25 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("166","64","2009-11-27 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("167","64","2009-11-30 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("168","64","2009-12-02 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("169","64","2009-12-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("170","64","2009-12-09 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("171","64","2009-12-11 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("172","64","2009-12-14 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("173","64","2009-12-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("174","64","2009-12-18 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("175","65","2009-11-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("176","65","2009-11-11 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("177","65","2009-11-18 00:00:00","10","4","0","0");
INSERT INTO tr_orderdetails VALUES("178","65","2009-11-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("179","65","2009-12-02 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("180","65","2009-12-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("181","65","2009-12-14 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("182","66","2009-11-04 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("183","66","2009-11-16 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("184","66","2009-12-02 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("185","66","2009-12-14 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("186","67","2009-12-07 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("187","68","2009-11-04 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("188","68","2009-11-11 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("189","68","2009-11-18 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("190","68","2009-11-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("191","68","2009-12-02 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("192","68","2009-12-09 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("193","68","2009-12-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("194","69","2009-11-04 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("195","69","2009-11-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("196","69","2009-11-18 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("197","69","2009-11-23 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("198","69","2009-12-02 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("199","69","2009-12-09 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("200","69","2009-12-16 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("201","70","2009-11-02 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("202","70","2009-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("203","70","2009-11-06 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("204","70","2009-11-11 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("205","70","2009-11-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("206","70","2009-11-16 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("207","70","2009-11-18 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("208","70","2009-11-20 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("209","70","2009-11-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("210","70","2009-11-25 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("211","70","2009-11-27 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("212","70","2009-11-30 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("213","70","2009-12-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("214","70","2009-12-07 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("215","70","2009-12-09 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("216","70","2009-12-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("217","70","2009-02-25 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("218","70","2009-01-25 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("219","70","2009-01-25 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("220","71","2009-11-02 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("221","71","2009-11-16 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("222","71","2009-11-23 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("223","71","2009-11-30 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("224","71","2009-12-07 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("225","71","2009-12-14 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("226","72","2009-11-04 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("227","72","2009-11-18 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("228","72","2009-11-25 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("229","72","2009-12-02 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("230","72","2009-12-09 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("231","72","2009-12-16 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("232","73","2009-11-02 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("233","73","2009-11-16 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("234","73","2009-11-23 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("235","73","2009-11-30 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("236","73","2009-12-07 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("237","73","2009-12-14 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("238","74","2009-11-04 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("239","74","2009-11-06 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("240","74","2009-11-11 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("241","74","2009-11-13 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("242","74","2009-11-14 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("243","74","2009-11-14 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("244","74","2009-11-14 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("245","74","2009-11-14 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("246","74","2009-11-14 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("247","74","2009-11-14 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("248","74","2009-11-14 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("249","74","2009-11-14 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("250","74","2009-11-14 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("251","75","2009-11-04 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("252","75","2009-11-18 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("253","76","2009-11-02 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("254","76","2009-11-04 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("255","76","2009-11-06 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("256","76","2009-11-11 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("257","76","2009-11-13 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("258","76","2009-11-16 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("259","76","2009-11-18 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("260","76","2009-11-20 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("261","76","2009-11-23 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("262","76","2009-11-25 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("263","76","2009-11-27 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("264","76","2009-11-30 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("265","76","2009-12-02 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("266","76","2009-12-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("267","76","2009-12-09 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("268","76","2009-12-11 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("269","76","2009-12-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("270","76","2009-12-16 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("271","76","2009-12-18 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("272","77","2009-11-06 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("273","77","2009-11-16 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("274","77","2009-11-27 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("275","77","2009-12-09 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("276","77","2009-12-18 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("277","78","2009-11-02 00:00:00","25","2","0","0");
INSERT INTO tr_orderdetails VALUES("278","78","2009-11-04 00:00:00","26","2","0","0");
INSERT INTO tr_orderdetails VALUES("279","78","2009-11-06 00:00:00","29","2","0","0");
INSERT INTO tr_orderdetails VALUES("280","78","2009-11-11 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("281","78","2009-11-13 00:00:00","25","2","0","0");
INSERT INTO tr_orderdetails VALUES("282","78","2009-11-16 00:00:00","26","2","0","0");
INSERT INTO tr_orderdetails VALUES("283","78","2009-11-18 00:00:00","28","2","0","0");
INSERT INTO tr_orderdetails VALUES("284","78","2009-11-20 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("285","78","2009-11-23 00:00:00","29","2","0","0");
INSERT INTO tr_orderdetails VALUES("286","78","2009-11-25 00:00:00","25","2","0","0");
INSERT INTO tr_orderdetails VALUES("287","78","2009-11-27 00:00:00","26","2","0","0");
INSERT INTO tr_orderdetails VALUES("288","78","2009-11-30 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("289","78","2009-12-02 00:00:00","29","2","0","0");
INSERT INTO tr_orderdetails VALUES("290","78","2009-12-07 00:00:00","28","2","0","0");
INSERT INTO tr_orderdetails VALUES("291","78","2009-12-09 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("292","78","2009-12-11 00:00:00","25","2","0","0");
INSERT INTO tr_orderdetails VALUES("293","78","2009-12-14 00:00:00","26","2","0","0");
INSERT INTO tr_orderdetails VALUES("294","78","2009-12-16 00:00:00","29","2","0","0");
INSERT INTO tr_orderdetails VALUES("295","78","2009-12-18 00:00:00","28","2","0","0");
INSERT INTO tr_orderdetails VALUES("296","79","2009-11-06 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("297","79","2009-11-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("298","79","2009-11-20 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("299","79","2009-11-27 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("300","79","2009-12-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("301","79","2009-12-18 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("302","80","2009-11-02 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("303","80","2009-11-04 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("304","80","2009-11-06 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("305","80","2009-11-11 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("306","80","2009-11-13 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("307","80","2009-11-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("308","80","2009-11-18 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("309","80","2009-11-20 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("310","80","2009-11-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("311","80","2009-11-25 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("312","80","2009-11-27 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("313","80","2009-11-30 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("314","80","2009-12-02 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("315","80","2009-12-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("316","80","2009-12-09 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("317","80","2009-12-11 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("318","80","2009-12-14 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("319","80","2009-12-16 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("320","80","2009-12-18 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("321","81","2009-11-02 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("322","81","2009-11-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("323","81","2009-11-23 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("324","81","2009-11-30 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("325","81","2009-12-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("326","81","2009-12-14 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("327","82","2009-12-11 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("328","82","2009-12-18 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("329","83","2009-11-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("330","83","2009-11-16 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("331","83","2009-11-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("332","83","2009-11-30 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("333","83","2009-12-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("334","83","2009-12-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("335","84","2009-11-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("336","84","2009-11-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("337","84","2009-11-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("338","84","2009-11-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("339","85","2009-11-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("340","86","2009-11-06 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("341","86","2009-11-13 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("342","86","2009-11-20 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("343","86","2009-11-27 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("344","86","2009-12-11 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("345","86","2009-12-18 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("346","87","2009-11-04 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("347","87","2009-11-11 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("348","87","2009-11-18 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("349","87","2009-11-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("350","87","2009-12-02 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("351","87","2009-12-09 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("352","87","2009-12-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("353","88","2009-11-02 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("354","88","2009-11-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("355","88","2009-11-06 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("356","88","2009-11-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("357","88","2009-11-13 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("358","88","2009-11-16 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("359","88","2009-11-18 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("360","88","2009-11-20 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("361","88","2009-11-23 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("362","88","2009-11-25 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("363","88","2009-11-27 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("364","88","2009-11-30 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("365","88","2009-12-02 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("366","88","2009-12-07 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("367","88","2009-12-09 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("368","88","2009-12-11 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("369","88","2009-12-14 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("370","88","2009-12-16 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("371","88","2009-12-18 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("372","89","2009-11-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("373","89","2009-11-04 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("374","89","2009-11-06 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("375","89","2009-11-11 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("376","89","2009-11-13 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("377","89","2009-11-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("378","89","2009-11-18 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("379","89","2009-11-20 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("380","89","2009-11-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("381","89","2009-11-25 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("382","89","2009-11-27 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("383","89","2009-11-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("384","89","2009-12-02 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("385","89","2009-12-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("386","89","2009-12-09 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("387","89","2009-12-11 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("388","89","2009-12-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("389","89","2009-12-16 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("390","89","2009-12-18 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("391","90","2009-11-02 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("392","91","2009-11-02 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("393","91","2009-11-04 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("394","91","2009-11-06 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("395","91","2009-11-11 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("396","91","2009-11-13 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("397","91","2009-11-16 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("398","91","2009-11-18 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("399","91","2009-11-20 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("400","91","2009-11-23 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("401","91","2009-11-25 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("402","91","2009-11-27 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("403","91","2009-11-30 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("404","91","2009-12-02 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("405","91","2009-12-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("406","91","2009-12-09 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("407","91","2009-12-11 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("408","91","2009-12-14 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("409","91","2009-12-16 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("410","91","2009-12-18 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("411","92","2009-11-04 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("412","92","2009-11-11 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("413","92","2009-11-18 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("414","92","2009-11-25 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("415","92","2009-12-02 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("416","92","2009-12-09 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("417","92","2009-12-16 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("418","93","2009-11-04 00:00:00","6","4","0","0");
INSERT INTO tr_orderdetails VALUES("419","93","2009-11-11 00:00:00","7","4","0","0");
INSERT INTO tr_orderdetails VALUES("420","93","2009-11-18 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("421","93","2009-11-25 00:00:00","6","4","0","0");
INSERT INTO tr_orderdetails VALUES("422","93","2009-12-02 00:00:00","7","4","0","0");
INSERT INTO tr_orderdetails VALUES("423","93","2009-12-09 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("424","93","2009-12-16 00:00:00","6","4","0","0");
INSERT INTO tr_orderdetails VALUES("425","94","2009-11-04 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("426","94","2009-11-11 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("427","94","2009-11-18 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("428","94","2009-11-25 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("429","94","2009-12-02 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("430","95","2009-11-02 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("431","95","2009-11-04 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("432","95","2009-11-06 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("433","95","2009-11-11 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("434","95","2009-11-13 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("435","95","2009-11-16 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("436","95","2009-11-18 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("437","95","2009-11-20 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("438","95","2009-11-23 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("439","95","2009-11-25 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("440","95","2009-11-27 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("441","95","2009-11-30 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("442","95","2009-12-02 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("443","95","2009-12-07 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("444","95","2009-12-09 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("445","95","2009-12-11 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("446","95","2009-12-14 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("447","95","2009-12-16 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("448","95","2009-12-18 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("449","96","2009-11-06 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("450","96","2009-11-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("451","96","2009-11-20 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("452","96","2009-11-27 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("453","96","2009-12-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("454","96","2009-12-18 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("455","97","2009-11-06 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("456","97","2009-11-16 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("457","97","2009-11-27 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("458","97","2009-12-09 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("459","97","2009-12-18 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("460","98","2009-11-02 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("461","98","2009-11-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("462","98","2009-11-23 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("463","98","2009-11-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("464","98","2009-12-07 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("465","98","2009-12-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("466","99","2009-11-06 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("467","99","2009-11-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("468","99","2009-11-27 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("469","99","2009-12-11 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("470","99","2009-12-18 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("471","100","2009-11-13 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("472","101","2009-11-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("473","101","2009-11-06 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("474","101","2009-11-20 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("475","101","2009-11-27 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("476","101","2009-12-11 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("477","101","2009-11-18 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("478","102","2009-11-04 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("479","102","2009-11-16 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("480","102","2009-12-02 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("481","102","2009-12-14 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("482","103","2009-11-02 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("483","103","2009-11-04 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("484","103","2009-11-06 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("485","103","2009-11-11 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("486","103","2009-11-13 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("487","103","2009-11-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("488","103","2009-11-18 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("489","103","2009-11-20 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("490","103","2009-11-23 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("491","103","2009-11-25 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("492","103","2009-11-27 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("493","103","2009-11-30 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("494","103","2009-12-02 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("495","103","2009-12-07 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("496","103","2009-12-09 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("497","103","2009-12-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("498","103","2009-12-14 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("499","103","2009-12-16 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("500","103","2009-12-18 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("501","104","2009-12-07 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("502","105","2009-11-06 00:00:00","10","4","0","0");
INSERT INTO tr_orderdetails VALUES("503","105","2009-11-13 00:00:00","6","4","0","0");
INSERT INTO tr_orderdetails VALUES("504","105","2009-11-20 00:00:00","7","4","0","0");
INSERT INTO tr_orderdetails VALUES("505","105","2009-11-27 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("506","105","2009-12-11 00:00:00","6","4","0","0");
INSERT INTO tr_orderdetails VALUES("507","105","2009-12-18 00:00:00","7","4","0","0");
INSERT INTO tr_orderdetails VALUES("508","106","2009-11-02 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("509","106","2009-11-04 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("510","106","2009-11-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("511","106","2009-11-13 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("512","106","2009-11-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("513","106","2009-11-20 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("514","106","2009-11-23 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("515","106","2009-11-25 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("516","106","2009-11-30 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("517","106","2009-12-02 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("518","106","2009-12-07 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("519","106","2009-12-09 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("520","106","2009-12-14 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("521","106","2009-12-16 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("522","106","2009-12-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("523","107","2009-11-02 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("524","107","2009-11-16 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("525","107","2009-11-23 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("526","107","2009-11-30 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("527","107","2009-12-07 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("528","107","2009-12-14 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("529","108","2009-11-02 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("530","108","2009-11-16 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("531","108","2009-11-23 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("532","108","2009-11-30 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("533","108","2009-12-07 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("534","108","2009-12-14 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("535","109","2009-11-02 00:00:00","8","3","0","0");
INSERT INTO tr_orderdetails VALUES("536","109","2009-11-16 00:00:00","2","3","0","0");
INSERT INTO tr_orderdetails VALUES("537","109","2009-11-23 00:00:00","9","3","0","0");
INSERT INTO tr_orderdetails VALUES("538","109","2009-11-30 00:00:00","10","3","0","0");
INSERT INTO tr_orderdetails VALUES("539","109","2009-12-07 00:00:00","8","3","0","0");
INSERT INTO tr_orderdetails VALUES("540","109","2009-12-14 00:00:00","9","3","0","0");
INSERT INTO tr_orderdetails VALUES("541","110","2009-11-04 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("542","110","2009-11-06 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("543","110","2009-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("544","110","2009-11-13 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("545","110","2009-11-18 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("546","110","2009-11-20 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("547","110","2009-11-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("548","110","2009-11-27 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("549","110","2009-12-02 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("550","110","2009-12-09 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("551","110","2009-12-11 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("552","110","2009-12-16 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("553","110","2009-12-18 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("554","111","2009-11-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("555","111","2009-11-06 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("556","111","2009-11-20 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("557","111","2009-11-27 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("558","111","2009-12-11 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("559","111","2009-12-18 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("560","112","2009-11-04 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("561","112","2009-11-13 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("562","112","2009-11-16 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("563","112","2009-11-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("564","112","2009-12-07 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("565","112","2009-12-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("566","113","2009-12-18 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("567","114","2009-11-04 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("568","114","2009-11-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("569","114","2009-11-18 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("570","114","2009-11-23 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("571","114","2009-12-02 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("572","114","2009-12-09 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("573","114","2009-12-16 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("574","115","2009-11-06 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("575","116","2009-11-06 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("576","116","2009-11-13 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("577","116","2009-11-20 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("578","116","2009-11-27 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("579","116","2009-12-04 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("580","116","2009-12-11 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("581","116","2009-12-18 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("582","117","2009-11-06 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("583","117","2009-11-20 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("584","117","2009-12-04 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("585","117","2009-12-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("586","117","2009-12-18 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("587","118","2009-11-06 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("588","118","2009-11-13 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("589","118","2009-11-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("590","118","2009-11-27 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("591","118","2009-12-04 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("592","118","2009-12-11 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("593","118","2009-12-18 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("594","119","2009-11-13 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("595","119","2009-11-27 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("596","119","2009-12-11 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("597","120","2009-11-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("598","120","2009-11-13 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("599","120","2009-11-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("600","120","2009-11-27 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("601","120","2009-12-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("602","120","2009-12-11 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("603","120","2009-12-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("604","121","2009-11-06 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("605","121","2009-11-13 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("606","121","2009-11-20 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("607","121","2009-11-27 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("608","121","2009-12-04 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("609","121","2009-12-11 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("610","121","2009-12-18 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("611","122","2009-11-06 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("612","122","2009-11-13 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("613","122","2009-11-20 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("614","122","2009-11-27 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("615","122","2009-12-04 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("616","122","2009-12-11 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("617","122","2009-12-18 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("618","123","2009-11-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("619","123","2009-11-13 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("620","123","2009-11-20 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("621","123","2009-11-27 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("622","123","2009-12-04 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("623","123","2009-12-11 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("624","123","2009-12-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("625","124","2009-11-06 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("626","124","2009-11-13 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("627","124","2009-11-20 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("628","124","2009-11-27 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("629","124","2009-12-04 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("630","124","2009-12-11 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("631","124","2009-12-18 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("632","124","2009-12-28 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("633","125","2009-11-06 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("634","125","2009-11-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("635","125","2009-11-27 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("636","125","2009-12-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("637","125","2009-12-11 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("638","125","2009-12-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("639","126","2009-11-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("640","126","2009-11-13 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("641","126","2009-11-20 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("642","126","2009-11-27 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("643","126","2009-12-04 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("644","126","2009-12-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("645","126","2009-12-18 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("646","127","2009-11-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("647","127","2009-11-20 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("648","127","2009-11-27 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("649","127","2009-12-04 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("650","127","2009-12-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("651","127","2009-12-18 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("652","128","2009-11-06 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("653","128","2009-11-13 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("654","128","2009-11-20 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("655","128","2009-11-27 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("656","128","2009-12-04 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("657","128","2009-12-11 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("658","128","2009-12-18 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("659","129","2009-11-06 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("660","129","2009-11-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("661","129","2009-11-20 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("662","129","2009-11-27 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("663","129","2009-12-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("664","129","2009-12-11 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("665","129","2009-12-18 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("666","130","2009-11-06 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("667","130","2009-11-13 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("668","130","2009-11-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("669","130","2009-11-27 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("670","130","2009-12-04 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("671","130","2009-12-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("672","130","2009-12-18 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("673","131","2009-11-06 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("674","131","2009-11-20 00:00:00","39","1","0","0");
INSERT INTO tr_orderdetails VALUES("675","131","2009-11-27 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("676","131","2009-12-11 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("677","131","2009-12-18 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("678","132","2009-11-06 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("679","132","2009-11-13 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("680","132","2009-11-20 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("681","132","2009-11-27 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("682","132","2009-12-04 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("683","132","2009-12-11 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("684","132","2009-12-18 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("685","133","2009-11-06 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("686","133","2009-11-13 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("687","133","2009-11-20 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("688","133","2009-11-27 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("689","133","2009-12-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("690","133","2009-12-11 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("691","133","2009-12-18 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("692","134","2009-11-06 00:00:00","6","3","0","0");
INSERT INTO tr_orderdetails VALUES("693","134","2009-11-13 00:00:00","10","3","0","0");
INSERT INTO tr_orderdetails VALUES("694","134","2009-11-20 00:00:00","6","3","0","0");
INSERT INTO tr_orderdetails VALUES("695","134","2009-11-27 00:00:00","10","3","0","0");
INSERT INTO tr_orderdetails VALUES("696","134","2009-12-04 00:00:00","6","3","0","0");
INSERT INTO tr_orderdetails VALUES("697","134","2009-12-11 00:00:00","10","3","0","0");
INSERT INTO tr_orderdetails VALUES("698","134","2009-12-18 00:00:00","6","3","0","0");
INSERT INTO tr_orderdetails VALUES("699","135","2009-11-06 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("700","135","2009-11-13 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("701","135","2009-11-20 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("702","135","2009-11-27 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("703","135","2009-12-04 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("704","135","2009-12-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("705","135","2009-12-18 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("706","136","2009-11-06 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("707","136","2009-11-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("708","136","2009-11-20 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("709","136","2009-11-27 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("710","136","2009-12-04 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("711","136","2009-12-11 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("712","136","2009-12-18 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("713","137","2009-11-06 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("714","137","2009-11-13 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("715","137","2009-11-20 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("716","137","2009-11-27 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("717","137","2009-12-04 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("718","137","2009-12-11 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("719","137","2009-12-18 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("720","138","2009-11-06 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("721","138","2009-11-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("722","138","2009-11-20 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("723","138","2009-11-27 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("724","138","2009-12-04 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("725","138","2009-12-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("726","138","2009-12-18 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("727","139","2009-11-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("728","139","2009-11-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("729","139","2009-11-27 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("730","139","2009-12-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("731","139","2009-12-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("732","140","2009-11-20 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("733","141","2009-11-06 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("734","141","2009-11-13 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("735","141","2009-11-20 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("736","141","2009-11-27 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("737","141","2009-12-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("738","141","2009-12-11 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("739","141","2009-12-18 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("740","142","2009-11-06 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("741","142","2009-11-13 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("742","142","2009-11-20 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("743","142","2009-11-27 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("744","142","2009-12-04 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("745","142","2009-12-11 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("746","142","2009-12-18 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("747","143","2009-11-06 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("748","143","2009-11-13 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("749","143","2009-11-20 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("750","143","2009-11-27 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("751","143","2009-12-04 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("752","143","2009-12-11 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("753","143","2009-12-18 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("754","144","2009-11-06 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("755","144","2009-11-13 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("756","144","2009-11-20 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("757","144","2009-11-27 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("758","144","2009-12-04 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("759","144","2009-12-11 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("760","144","2009-12-18 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("761","145","2009-11-06 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("762","145","2009-11-20 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("763","145","2009-11-27 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("764","145","2009-12-11 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("765","145","2009-12-18 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("766","146","2009-11-06 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("767","146","2009-11-13 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("768","146","2009-11-20 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("769","146","2009-11-27 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("770","146","2009-12-04 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("771","146","2009-12-11 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("772","146","2009-12-18 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("773","147","2009-11-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("774","147","2009-11-13 00:00:00","30","1","0","0");
INSERT INTO tr_orderdetails VALUES("775","147","2009-11-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("776","147","2009-11-27 00:00:00","30","1","0","0");
INSERT INTO tr_orderdetails VALUES("777","147","2009-12-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("778","147","2009-12-11 00:00:00","30","1","0","0");
INSERT INTO tr_orderdetails VALUES("779","147","2009-12-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("780","148","2009-11-06 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("781","148","2009-11-13 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("782","148","2009-11-20 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("783","148","2009-11-27 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("784","148","2009-12-04 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("785","148","2009-12-11 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("786","148","2009-12-18 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("787","149","2009-11-06 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("788","149","2009-11-13 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("789","149","2009-11-20 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("790","149","2009-11-27 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("791","149","2009-12-04 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("792","149","2009-12-11 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("793","149","2009-12-18 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("794","150","2009-11-06 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("795","150","2009-11-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("796","150","2009-11-20 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("797","150","2009-11-27 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("798","150","2009-12-04 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("799","150","2009-12-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("800","150","2009-12-18 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("801","151","2009-11-06 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("802","151","2009-11-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("803","151","2009-11-20 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("804","151","2009-11-27 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("805","151","2009-12-04 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("806","151","2009-12-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("807","151","2009-12-18 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("808","152","2009-11-06 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("809","152","2009-11-13 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("810","152","2009-11-20 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("811","152","2009-11-27 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("812","152","2009-12-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("813","152","2009-12-11 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("814","152","2009-12-18 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("815","153","2009-11-06 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("816","153","2009-11-13 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("817","153","2009-11-20 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("818","153","2009-11-27 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("819","153","2009-12-04 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("820","153","2009-12-11 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("821","153","2009-12-18 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("822","154","2009-11-06 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("823","154","2009-11-20 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("824","154","2009-11-27 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("825","154","2009-12-11 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("826","154","2009-12-18 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("827","155","2009-11-06 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("828","155","2009-11-13 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("829","155","2009-11-20 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("830","155","2009-11-27 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("831","155","2009-12-04 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("832","155","2009-12-11 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("833","155","2009-12-18 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("834","156","2009-11-06 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("835","156","2009-11-13 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("836","156","2009-11-20 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("837","156","2009-11-27 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("838","156","2009-12-04 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("839","156","2009-12-11 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("840","156","2009-12-18 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("841","157","2009-11-06 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("842","157","2009-11-13 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("843","157","2009-11-20 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("844","157","2009-11-27 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("845","157","2009-12-04 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("846","157","2009-12-11 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("847","157","2009-12-18 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("848","158","2009-11-06 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("849","158","2009-11-13 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("850","158","2009-11-20 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("851","158","2009-11-27 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("852","158","2009-12-04 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("853","158","2009-12-11 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("854","158","2009-12-18 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("855","159","2009-11-06 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("856","159","2009-11-13 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("857","159","2009-11-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("858","159","2009-11-27 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("859","159","2009-12-04 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("860","159","2009-12-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("861","159","2009-12-18 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("862","160","2009-11-06 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("863","160","2009-11-13 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("864","160","2009-11-20 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("865","160","2009-11-27 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("866","160","2009-12-04 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("867","160","2009-12-11 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("868","160","2009-12-18 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("869","161","2009-11-06 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("870","161","2009-11-13 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("871","161","2009-11-20 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("872","161","2009-11-27 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("873","161","2009-12-04 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("874","161","2009-12-11 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("875","161","2009-12-18 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("876","162","2009-11-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("877","162","2009-11-13 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("878","162","2009-11-20 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("879","162","2009-11-27 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("880","162","2009-12-04 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("881","162","2009-12-11 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("882","162","2009-12-18 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("883","163","2009-11-06 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("884","163","2009-11-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("885","163","2009-11-20 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("886","163","2009-11-27 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("887","163","2009-12-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("888","163","2009-12-11 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("889","163","2009-12-18 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("890","164","2009-11-06 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("891","164","2009-11-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("892","164","2009-11-20 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("893","164","2009-11-27 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("894","164","2009-12-04 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("895","164","2009-12-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("896","164","2009-12-18 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("897","165","2009-11-06 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("898","165","2009-11-13 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("899","165","2009-11-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("900","165","2009-11-27 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("901","165","2009-12-04 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("902","165","2009-12-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("903","165","2009-12-18 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("904","166","2009-11-06 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("905","166","2009-11-13 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("906","166","2009-11-20 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("907","166","2009-11-27 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("908","166","2009-12-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("909","166","2009-12-11 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("910","166","2009-12-18 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("911","167","2009-11-06 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("912","167","2009-11-13 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("913","167","2009-11-20 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("914","167","2009-11-27 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("915","167","2009-12-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("916","167","2009-12-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("917","167","2009-12-18 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("918","168","2009-11-06 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("919","168","2009-11-13 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("920","168","2009-11-20 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("921","168","2009-11-27 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("922","168","2009-12-04 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("923","168","2009-12-11 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("924","168","2009-12-18 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("925","169","2009-11-06 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("926","169","2009-11-13 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("927","169","2009-11-20 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("928","169","2009-11-27 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("929","169","2009-12-04 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("930","169","2009-12-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("931","169","2009-12-18 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("932","170","2009-11-06 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("933","170","2009-11-13 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("934","170","2009-11-20 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("935","170","2009-11-27 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("936","170","2009-12-04 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("937","170","2009-12-11 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("938","170","2009-12-18 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("939","171","2009-11-06 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("940","171","2009-11-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("941","171","2009-11-20 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("942","171","2009-11-27 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("943","171","2009-12-04 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("944","171","2009-12-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("945","171","2009-12-18 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("946","172","2009-11-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("947","172","2009-11-13 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("948","172","2009-11-20 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("949","172","2009-11-27 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("950","172","2009-12-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("951","172","2009-12-11 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("952","172","2009-12-18 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("953","173","2009-11-06 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("954","173","2009-11-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("955","173","2009-11-20 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("956","173","2009-11-27 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("957","173","2009-12-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("958","173","2009-12-11 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("959","173","2009-12-18 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("960","174","2009-11-06 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("961","174","2009-11-13 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("962","174","2009-11-20 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("963","174","2009-11-27 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("964","174","2009-12-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("965","174","2009-12-11 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("966","174","2009-12-18 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("967","175","2009-11-06 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("968","175","2009-11-13 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("969","175","2009-11-20 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("970","175","2009-11-27 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("971","175","2009-12-04 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("972","175","2009-12-11 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("973","175","2009-12-18 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("974","176","2009-11-06 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("975","176","2009-11-20 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("976","176","2009-11-27 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("977","176","2009-12-11 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("978","176","2009-12-18 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("979","177","2009-11-06 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("980","177","2009-11-20 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("981","177","2009-11-27 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("982","177","2009-12-11 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("983","177","2009-12-18 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("984","178","2009-11-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("985","178","2009-11-13 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("986","178","2009-11-20 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("987","178","2009-11-27 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("988","178","2009-12-04 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("989","178","2009-12-11 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("990","178","2009-12-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("991","179","2009-11-06 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("992","179","2009-11-13 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("993","179","2009-11-20 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("994","179","2009-11-27 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("995","179","2009-12-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("996","179","2009-12-11 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("997","179","2009-12-18 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("998","180","2009-11-06 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("999","180","2009-11-13 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("1000","180","2009-11-20 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("1001","180","2009-11-27 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("1002","180","2009-12-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1003","180","2009-12-11 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("1004","180","2009-12-18 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("1005","181","2009-11-06 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1006","181","2009-11-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1007","181","2009-11-20 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("1008","181","2009-11-27 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1009","181","2009-12-04 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1010","181","2009-12-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1011","181","2009-12-18 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("1012","182","2009-11-06 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1013","182","2009-11-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1014","182","2009-11-20 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1015","182","2009-11-27 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("1016","182","2009-12-04 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1017","182","2009-12-11 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1018","182","2009-12-18 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1019","183","2009-11-06 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("1020","183","2009-11-13 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("1021","183","2009-11-20 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("1022","183","2009-11-27 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("1023","183","2009-12-04 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("1024","183","2009-12-11 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("1025","183","2009-12-18 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("1026","184","2009-11-06 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1027","184","2009-11-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1028","184","2009-11-20 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1029","184","2009-11-27 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("1030","184","2009-12-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1031","184","2009-12-11 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("1032","184","2009-12-18 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1033","185","2009-11-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1034","185","2009-11-20 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1035","185","2009-12-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1036","185","2009-12-18 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1037","186","2009-11-06 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("1038","186","2009-11-13 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("1039","186","2009-11-20 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("1040","186","2009-11-27 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("1041","186","2009-12-04 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("1042","186","2009-12-11 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("1043","186","2009-12-18 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("1044","187","2009-11-06 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("1045","187","2009-11-13 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("1046","187","2009-11-20 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("1047","187","2009-11-27 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1048","187","2009-12-04 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("1049","187","2009-12-11 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("1050","187","2009-12-18 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("1051","188","2009-11-06 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1052","188","2009-11-13 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1053","188","2009-11-20 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1054","188","2009-11-27 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1055","188","2009-12-04 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1056","188","2009-12-11 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1057","188","2009-12-18 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1058","189","2009-11-06 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1059","189","2009-11-20 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1060","189","2009-11-27 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1061","189","2009-12-11 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1062","189","2009-12-18 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("1063","190","2009-11-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1064","190","2009-11-13 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("1065","190","2009-11-20 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1066","190","2009-11-27 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1067","190","2009-12-04 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("1068","190","2009-12-11 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1069","190","2009-12-18 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1070","191","2009-11-06 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("1071","191","2009-11-13 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1072","191","2009-11-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1073","191","2009-11-27 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1074","191","2009-12-04 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("1075","191","2009-12-11 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1076","191","2009-12-18 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("1077","192","2009-11-06 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1078","192","2009-11-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1079","192","2009-11-20 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1080","192","2009-11-27 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1081","192","2009-12-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1082","192","2009-12-11 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1083","192","2009-12-18 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1084","193","2009-11-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1085","193","2009-11-13 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1086","193","2009-11-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1087","193","2009-11-27 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1088","193","2009-12-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1089","193","2009-12-11 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1090","193","2009-12-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1091","194","2009-11-06 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1092","194","2009-11-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1093","194","2009-11-20 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("1094","194","2009-11-27 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1095","194","2009-12-04 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1096","194","2009-12-11 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("1097","194","2009-12-18 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1098","195","2009-11-06 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("1099","195","2009-11-13 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("1100","195","2009-11-20 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1101","195","2009-11-27 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("1102","195","2009-12-04 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("1103","195","2009-12-11 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("1104","195","2009-12-18 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("1105","196","2009-11-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1106","196","2009-11-13 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1107","196","2009-11-20 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("1108","196","2009-11-27 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1109","196","2009-12-04 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1110","196","2009-12-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1111","196","2009-12-18 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("1112","197","2009-11-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1113","197","2009-11-13 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1114","197","2009-11-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1115","197","2009-11-27 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1116","197","2009-12-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1117","197","2009-12-11 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1118","197","2009-12-18 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1119","198","2009-11-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1120","198","2009-11-13 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1121","198","2009-11-20 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("1122","198","2009-11-27 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1123","198","2009-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1124","198","2009-12-11 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1125","198","2009-12-18 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("1126","198","2009-12-25 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("1127","199","2009-11-02 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1128","200","2009-11-06 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("1129","200","2009-11-13 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1130","200","2009-11-20 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("1131","200","2009-11-27 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1132","200","2009-12-04 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("1133","200","2009-12-11 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1134","200","2009-12-18 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("1135","201","2009-11-06 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("1136","201","2009-11-13 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("1137","201","2009-11-20 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("1138","201","2009-11-27 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("1139","201","2009-12-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1140","201","2009-12-11 00:00:00","6","2","0","0");
INSERT INTO tr_orderdetails VALUES("1141","201","2009-12-18 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("1142","202","2009-11-06 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1143","202","2009-11-20 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("1144","202","2009-11-27 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1145","202","2009-12-11 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("1146","202","2009-12-18 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1147","203","2009-11-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1148","203","2009-11-13 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1149","203","2009-11-20 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("1150","203","2009-11-27 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1151","203","2009-12-04 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1152","203","2009-12-11 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("1153","203","2009-12-18 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("1154","204","2009-11-06 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("1155","204","2009-11-13 00:00:00","9","2","0","0");
INSERT INTO tr_orderdetails VALUES("1156","204","2009-11-20 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("1157","204","2009-11-27 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("1158","204","2009-12-11 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("1159","204","2009-12-18 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("1160","205","2009-11-06 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("1161","205","2009-11-13 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1162","205","2009-11-20 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("1163","205","2009-11-27 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1164","205","2009-12-04 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("1165","205","2009-12-11 00:00:00","8","2","0","0");
INSERT INTO tr_orderdetails VALUES("1166","205","2009-12-18 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1167","206","2009-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1168","206","2009-11-06 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1169","206","2009-11-18 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("1170","206","2009-11-20 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1171","206","2009-11-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1172","206","2009-11-27 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1173","206","2009-11-30 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1174","206","2009-12-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1175","206","2009-12-09 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1176","206","2009-12-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1177","206","2009-12-16 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("1178","206","2009-12-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1179","207","2009-11-04 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1180","207","2009-11-06 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("1181","207","2009-11-11 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1182","207","2009-11-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1183","207","2009-11-18 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1184","207","2009-11-20 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1185","207","2009-11-25 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1186","207","2009-11-27 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("1187","207","2009-11-30 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1188","207","2009-12-02 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("1189","207","2009-12-09 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1190","207","2009-12-11 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("1191","207","2009-12-16 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1192","207","2009-12-18 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("1193","208","2009-11-02 00:00:00","24","1","0","0");
INSERT INTO tr_orderdetails VALUES("1194","208","2009-11-06 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("1195","208","2009-11-13 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("1196","208","2009-11-16 00:00:00","24","1","0","0");
INSERT INTO tr_orderdetails VALUES("1197","208","2009-11-20 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("1198","208","2009-11-23 00:00:00","24","1","0","0");
INSERT INTO tr_orderdetails VALUES("1199","208","2009-11-27 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("1200","208","2009-11-30 00:00:00","24","1","0","0");
INSERT INTO tr_orderdetails VALUES("1201","208","2009-12-07 00:00:00","24","1","0","0");
INSERT INTO tr_orderdetails VALUES("1202","208","2009-12-11 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("1203","208","2009-12-14 00:00:00","24","1","0","0");
INSERT INTO tr_orderdetails VALUES("1204","208","2009-12-18 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("1205","209","2009-11-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1206","209","2009-11-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1207","209","2009-11-18 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1208","209","2009-11-25 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1209","209","2009-12-02 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1210","209","2009-12-09 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1211","209","2009-12-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1212","210","2009-11-06 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1213","211","2009-11-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1214","211","2009-11-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1215","211","2009-11-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1216","211","2009-12-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1217","211","2009-11-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1218","212","2009-11-16 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1219","212","2009-11-23 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("1220","212","2009-11-30 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1221","212","2009-12-07 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("1222","212","2009-12-14 00:00:00","8","1","0","0");
INSERT INTO tr_orderdetails VALUES("1223","213","2009-11-16 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1224","214","2009-11-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1225","214","2009-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1226","214","2009-11-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1227","214","2009-11-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1228","214","2009-11-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1229","214","2009-12-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1230","214","2009-12-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1231","215","2009-11-06 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("1232","215","2009-11-20 00:00:00","30","1","0","0");
INSERT INTO tr_orderdetails VALUES("1233","215","2009-12-04 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1234","215","2009-12-18 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("1235","216","2009-11-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1236","216","2009-11-20 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1237","217","2009-11-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1238","217","2009-11-20 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("1239","217","2009-11-27 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1240","217","2009-12-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1241","217","2009-12-11 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("1242","217","2009-12-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1243","218","2009-11-20 00:00:00","37","1","0","0");
INSERT INTO tr_orderdetails VALUES("1244","219","2009-11-11 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1245","219","2009-11-13 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("1246","220","2009-11-11 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1247","220","2009-11-13 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("1248","221","2009-11-11 00:00:00","30","1","0","0");
INSERT INTO tr_orderdetails VALUES("1249","221","2009-11-13 00:00:00","38","1","0","0");
INSERT INTO tr_orderdetails VALUES("1250","221","2009-11-18 00:00:00","30","1","0","0");
INSERT INTO tr_orderdetails VALUES("1251","221","2009-11-20 00:00:00","38","1","0","0");
INSERT INTO tr_orderdetails VALUES("1252","221","2009-11-25 00:00:00","30","1","0","0");
INSERT INTO tr_orderdetails VALUES("1253","221","2009-11-27 00:00:00","38","1","0","0");
INSERT INTO tr_orderdetails VALUES("1254","221","2009-12-02 00:00:00","30","1","0","0");
INSERT INTO tr_orderdetails VALUES("1255","221","2009-12-09 00:00:00","30","1","0","0");
INSERT INTO tr_orderdetails VALUES("1256","221","2009-12-11 00:00:00","38","1","0","0");
INSERT INTO tr_orderdetails VALUES("1257","221","2009-12-16 00:00:00","30","1","0","0");
INSERT INTO tr_orderdetails VALUES("1258","221","2009-12-18 00:00:00","38","1","0","0");
INSERT INTO tr_orderdetails VALUES("1259","222","2009-11-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1260","222","2009-12-14 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1261","223","2009-11-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1262","223","2009-11-16 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1263","224","2009-11-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1264","225","2009-11-27 00:00:00","9","1","0","0");
INSERT INTO tr_orderdetails VALUES("1265","225","2009-12-11 00:00:00","6","1","0","0");
INSERT INTO tr_orderdetails VALUES("1266","226","2009-11-25 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1267","226","2009-12-02 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("1268","226","2009-12-09 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1269","226","2009-12-16 00:00:00","10","2","0","0");
INSERT INTO tr_orderdetails VALUES("1270","227","2009-12-11 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("1271","227","2009-12-18 00:00:00","10","1","0","0");
INSERT INTO tr_orderdetails VALUES("1272","228","2009-12-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1273","228","2010-01-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1274","229","2010-01-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1275","229","2010-01-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1276","229","2010-01-13 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1277","229","2010-01-18 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1278","229","2010-02-01 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1279","229","2010-02-08 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1280","229","2010-02-22 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1281","230","2010-01-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1282","230","2010-01-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1283","230","2010-01-18 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1284","230","2010-01-25 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1285","230","2010-02-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1286","230","2010-02-08 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1287","230","2010-02-17 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1288","230","2010-02-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1289","231","2010-01-04 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1290","231","2010-01-08 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1291","231","2010-01-11 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1292","231","2010-01-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1293","231","2010-01-18 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1294","231","2010-01-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1295","231","2010-01-25 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1296","231","2010-01-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1297","231","2010-02-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1298","231","2010-02-05 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1299","231","2010-02-08 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1300","231","2010-02-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1301","231","2010-02-19 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1302","231","2010-02-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1303","231","2010-02-26 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1304","232","2010-01-04 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1305","232","2010-01-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1306","232","2010-01-08 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1307","232","2010-01-11 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1308","232","2010-01-13 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1309","232","2010-01-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1310","232","2010-01-18 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1311","232","2010-01-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1312","232","2010-01-22 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1313","232","2010-01-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1314","232","2010-01-27 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1315","232","2010-01-29 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1316","232","2010-02-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1317","232","2010-02-03 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1318","232","2010-02-05 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1319","232","2010-02-08 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1320","232","2010-02-10 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1321","232","2010-02-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1322","232","2010-02-17 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1323","232","2010-02-19 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1324","232","2010-02-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1325","232","2009-02-24 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1326","232","2010-02-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1327","232","2010-02-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1328","233","2010-01-04 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1329","233","2010-01-06 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1330","233","2010-01-11 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1331","233","2010-01-13 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("1332","233","2010-01-18 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("1333","233","2010-01-20 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("1334","233","2010-01-25 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1335","233","2010-01-27 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1336","233","2010-02-01 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("1337","233","2010-02-03 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1338","233","2010-02-08 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1339","233","2010-02-10 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1340","233","2010-02-17 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("1341","233","2010-02-22 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1342","233","2010-02-24 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("1343","234","2010-01-08 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1344","235","2010-01-06 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1345","235","2010-01-15 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1346","235","2010-01-18 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1347","235","2010-01-27 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1348","235","2010-02-05 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1349","235","2010-02-10 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1350","235","2010-02-22 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1351","236","2010-01-04 00:00:00","43","2","0","0");
INSERT INTO tr_orderdetails VALUES("1352","236","2010-01-06 00:00:00","40","2","0","0");
INSERT INTO tr_orderdetails VALUES("1353","236","2010-01-08 00:00:00","43","2","0","0");
INSERT INTO tr_orderdetails VALUES("1354","236","2010-01-11 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("1355","236","2010-01-13 00:00:00","42","2","0","0");
INSERT INTO tr_orderdetails VALUES("1356","236","2010-01-15 00:00:00","40","2","0","0");
INSERT INTO tr_orderdetails VALUES("1357","236","2010-01-18 00:00:00","40","2","0","0");
INSERT INTO tr_orderdetails VALUES("1358","236","2010-01-20 00:00:00","41","2","0","0");
INSERT INTO tr_orderdetails VALUES("1359","236","2010-01-22 00:00:00","43","2","0","0");
INSERT INTO tr_orderdetails VALUES("1360","236","2010-01-25 00:00:00","25","2","0","0");
INSERT INTO tr_orderdetails VALUES("1361","236","2010-01-27 00:00:00","42","2","0","0");
INSERT INTO tr_orderdetails VALUES("1362","236","2010-01-29 00:00:00","40","2","0","0");
INSERT INTO tr_orderdetails VALUES("1363","236","2010-02-01 00:00:00","41","2","0","0");
INSERT INTO tr_orderdetails VALUES("1364","236","2010-02-03 00:00:00","43","2","0","0");
INSERT INTO tr_orderdetails VALUES("1365","236","2010-02-05 00:00:00","42","2","0","0");
INSERT INTO tr_orderdetails VALUES("1366","236","2010-02-08 00:00:00","42","2","0","0");
INSERT INTO tr_orderdetails VALUES("1367","236","2010-02-10 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("1368","236","2010-02-12 00:00:00","41","2","0","0");
INSERT INTO tr_orderdetails VALUES("1369","236","2010-02-17 00:00:00","40","2","0","0");
INSERT INTO tr_orderdetails VALUES("1370","236","2010-02-19 00:00:00","43","2","0","0");
INSERT INTO tr_orderdetails VALUES("1371","236","2010-02-22 00:00:00","40","2","0","0");
INSERT INTO tr_orderdetails VALUES("1372","236","2010-02-24 00:00:00","40","2","0","0");
INSERT INTO tr_orderdetails VALUES("1373","236","2010-02-26 00:00:00","43","2","0","0");
INSERT INTO tr_orderdetails VALUES("1374","237","2010-01-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1375","237","2010-01-06 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1376","237","2010-01-08 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1377","237","2010-01-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1378","237","2010-01-13 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1379","237","2010-01-15 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1380","237","2010-01-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1381","237","2010-01-20 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1382","237","2010-01-22 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1383","237","2010-01-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1384","237","2010-01-27 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1385","237","2010-01-29 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1386","238","2010-01-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1387","238","2010-01-13 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1388","238","2010-01-20 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1389","238","2010-01-27 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1390","238","2010-02-03 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1391","238","2010-02-10 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1392","238","2010-02-17 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1393","238","2010-02-24 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1394","239","2010-01-04 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1395","239","2010-01-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1396","239","2010-01-08 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1397","239","2010-01-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1398","239","2010-01-13 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1399","239","2010-01-15 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1400","239","2010-01-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1401","239","2010-01-20 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1402","239","2010-01-22 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1403","239","2010-01-25 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1404","239","2010-01-27 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1405","239","2010-01-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1406","239","2010-02-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1407","239","2010-02-03 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1408","239","2010-02-05 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1409","239","2010-02-08 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1410","239","2010-02-10 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1411","239","2010-02-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1412","239","2010-02-17 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1413","239","2010-02-19 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1414","239","2010-02-22 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1415","239","2010-02-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1416","239","2010-02-26 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1417","240","2010-01-04 00:00:00","2","4","0","0");
INSERT INTO tr_orderdetails VALUES("1418","240","2010-01-11 00:00:00","36","4","0","0");
INSERT INTO tr_orderdetails VALUES("1419","240","2010-01-18 00:00:00","2","4","0","0");
INSERT INTO tr_orderdetails VALUES("1420","240","2010-01-25 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1421","240","2010-02-01 00:00:00","33","4","0","0");
INSERT INTO tr_orderdetails VALUES("1422","240","2010-02-08 00:00:00","36","4","0","0");
INSERT INTO tr_orderdetails VALUES("1423","240","2010-02-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1424","241","2010-01-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1425","241","2010-01-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1426","241","2010-01-18 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1427","241","2010-01-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1428","241","2010-02-01 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1429","241","2010-02-08 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1430","241","2010-02-22 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1431","242","2010-01-04 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1432","242","2010-01-11 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1433","242","2010-01-18 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("1434","242","2010-01-25 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1435","242","2010-02-01 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1436","242","2010-02-08 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1437","242","2010-02-22 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("1438","243","2010-01-04 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1439","243","2010-01-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1440","243","2010-01-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1441","243","2010-01-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1442","243","2010-02-22 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1443","244","2010-01-06 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1444","244","2010-01-08 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1445","244","2010-01-13 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1446","244","2010-01-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1447","244","2010-01-20 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1448","244","2010-01-22 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1449","244","2010-01-27 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1450","244","2010-01-29 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1451","244","2010-02-03 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1452","244","2010-02-05 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1453","244","2010-02-10 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("1454","244","2010-02-12 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1455","245","2010-01-06 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1456","245","2010-01-15 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1457","245","2010-01-18 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1458","245","2010-01-27 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1459","245","2010-02-05 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1460","245","2010-02-10 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1461","245","2010-02-22 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1462","246","2010-01-08 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1463","246","2010-01-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1464","246","2010-01-22 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1465","246","2010-01-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1466","246","2010-02-05 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1467","246","2010-02-12 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1468","246","2010-02-19 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1469","246","2010-02-26 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1470","247","2010-01-04 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1471","247","2010-01-06 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1472","247","2010-01-08 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1473","247","2010-01-11 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1474","247","2010-01-13 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1475","247","2010-01-15 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1476","247","2010-01-18 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1477","247","2010-01-20 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1478","247","2010-01-22 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1479","247","2010-01-25 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1480","247","2010-01-27 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1481","247","2010-01-29 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1482","248","2010-01-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1483","248","2010-01-11 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1484","248","2010-01-18 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1485","248","2010-01-25 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("1486","248","2010-02-01 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1487","248","2010-02-08 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1488","248","2010-02-22 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1489","249","2010-01-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1490","249","2010-01-13 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1491","249","2010-01-20 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1492","249","2010-01-27 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1493","249","2010-02-03 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1494","249","2010-02-10 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1495","249","2010-02-17 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1496","249","2010-02-24 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1497","250","2010-01-04 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1498","250","2010-01-11 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1499","250","2010-01-18 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1500","250","2010-01-25 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1501","250","2010-02-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1502","250","2010-02-08 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1503","250","2010-02-17 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1504","250","2010-02-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1505","250","2007-02-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1506","251","2010-01-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1507","251","2010-01-13 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1508","251","2010-01-20 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1509","251","2010-01-27 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1510","251","2010-01-29 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1511","251","2010-02-03 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1512","251","2010-02-10 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1513","251","2010-02-17 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1514","251","2010-02-24 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1515","252","2010-01-04 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1516","252","2010-01-06 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1517","252","2010-01-08 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("1518","252","2010-01-11 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1519","252","2010-01-13 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("1520","252","2010-01-15 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1521","252","2010-01-18 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1522","252","2010-01-20 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("1523","252","2010-01-22 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1524","252","2010-01-25 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("1525","252","2010-01-27 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1526","252","2010-01-29 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1527","252","2010-02-01 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("1528","252","2010-02-03 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1529","252","2010-02-05 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("1530","252","2010-02-08 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1531","252","2010-02-10 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1532","252","2010-02-12 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("1533","252","2010-02-17 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1534","252","2010-02-19 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("1535","252","2010-02-22 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1536","252","2010-02-24 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1537","252","2010-02-26 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("1538","253","2010-01-04 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1539","253","2010-01-06 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1540","253","2010-01-08 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1541","253","2010-01-11 00:00:00","44","1","0","0");
INSERT INTO tr_orderdetails VALUES("1542","253","2010-01-13 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1543","253","2010-01-15 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1544","253","2010-01-18 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1545","253","2010-01-20 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1546","253","2010-01-22 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1547","253","2010-01-25 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1548","253","2010-01-27 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1549","253","2010-01-29 00:00:00","44","1","0","0");
INSERT INTO tr_orderdetails VALUES("1550","253","2010-02-01 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1551","253","2010-02-03 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1552","253","2010-02-05 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1553","253","2010-02-08 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1554","253","2010-02-10 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1555","253","2010-02-12 00:00:00","44","1","0","0");
INSERT INTO tr_orderdetails VALUES("1556","253","2010-02-17 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1557","253","2010-02-19 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1558","253","2010-02-22 00:00:00","44","1","0","0");
INSERT INTO tr_orderdetails VALUES("1559","253","2010-02-24 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1560","253","2010-02-26 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1561","254","2010-01-06 00:00:00","31","4","0","0");
INSERT INTO tr_orderdetails VALUES("1562","254","2010-01-13 00:00:00","2","4","0","0");
INSERT INTO tr_orderdetails VALUES("1563","254","2010-01-20 00:00:00","11","4","0","0");
INSERT INTO tr_orderdetails VALUES("1564","254","2010-01-27 00:00:00","33","4","0","0");
INSERT INTO tr_orderdetails VALUES("1565","254","2010-02-03 00:00:00","2","4","0","0");
INSERT INTO tr_orderdetails VALUES("1566","254","2010-02-10 00:00:00","33","4","0","0");
INSERT INTO tr_orderdetails VALUES("1569","255","2010-01-04 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1570","255","2010-01-11 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1571","255","2010-01-18 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("1572","255","2010-01-25 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1573","255","2010-02-01 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1574","255","2010-02-08 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("1575","255","2010-02-22 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1576","256","2010-01-04 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1577","256","2010-01-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1578","256","2010-01-18 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1579","256","2010-01-25 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1580","256","2010-02-01 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1581","256","2010-02-08 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1582","256","2010-02-22 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1583","256","2008-12-13 00:00:00","39","1","0","0");
INSERT INTO tr_orderdetails VALUES("1584","257","2010-01-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1585","257","2010-01-08 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1586","257","2010-01-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1587","257","2010-01-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1588","257","2010-01-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1589","257","2010-01-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1590","257","2010-01-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1591","257","2010-01-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1592","257","2010-02-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1593","257","2010-02-05 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1594","257","2010-02-08 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1595","257","2010-02-19 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1596","257","2010-02-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1597","257","2010-02-26 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1598","257","2010-02-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1599","258","2010-01-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1600","258","2010-01-18 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1601","258","2010-01-20 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1602","258","2010-01-22 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1603","258","2010-01-25 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1604","258","2010-01-27 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1605","258","2010-01-29 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1606","258","2010-02-01 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1607","258","2010-02-03 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1608","258","2010-02-05 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1609","258","2010-02-08 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1610","258","2010-02-10 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1611","258","2010-02-12 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1612","258","2010-02-17 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1613","258","2010-02-19 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1614","258","2010-02-22 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1615","258","2010-02-24 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1616","258","2010-02-26 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1617","259","2010-01-04 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("1618","259","2010-01-06 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1619","259","2010-01-08 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1620","259","2010-01-11 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1621","259","2010-01-13 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1622","259","2010-01-15 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1623","259","2010-01-18 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("1624","259","2010-01-20 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1625","259","2010-01-22 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1626","259","2010-01-25 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1627","259","2010-01-27 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1628","259","2010-01-29 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1629","259","2010-02-01 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("1630","259","2010-02-03 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1631","259","2010-02-05 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1632","259","2010-02-08 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1633","259","2010-02-10 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1634","259","2010-02-12 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1635","259","2010-02-17 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1636","259","2010-02-19 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1637","259","2010-02-22 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("1638","259","2010-02-24 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1639","259","2010-02-26 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1640","260","2010-01-11 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1641","260","2010-01-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1642","260","2010-01-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1643","260","2010-01-27 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1644","260","2010-02-08 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1645","261","2010-01-08 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1646","261","2010-01-15 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1647","261","2010-01-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1648","261","2010-01-29 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1649","261","2010-02-05 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1650","261","2010-02-12 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1651","261","2010-02-19 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1652","261","2010-02-26 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1653","262","2010-01-08 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1654","262","2010-01-22 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1655","262","2010-02-05 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1656","262","2010-02-19 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1657","263","2010-01-08 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1658","263","2010-01-15 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1659","263","2010-01-22 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1660","263","2010-01-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1661","263","2010-02-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1662","263","2010-02-12 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1663","263","2010-02-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1664","263","2010-02-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1665","264","2010-01-08 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1666","264","2010-01-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1667","264","2010-01-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1668","264","2010-01-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1669","264","2010-02-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1670","264","2010-02-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1671","264","2010-02-19 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1672","264","2010-02-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1673","265","2010-01-08 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1674","265","2010-01-15 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1675","265","2010-01-22 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1676","265","2010-01-29 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1677","265","2010-02-05 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1678","265","2010-02-12 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1679","265","2010-02-19 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1680","265","2010-02-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1681","266","2010-01-08 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1682","266","2010-01-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1683","266","2010-01-22 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1684","266","2010-01-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1685","266","2010-02-05 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1686","266","2010-02-12 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1687","266","2010-02-19 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1688","266","2010-02-26 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1689","267","2010-01-08 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1690","267","2010-01-15 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1691","267","2010-01-22 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1692","267","2010-01-29 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1693","267","2010-02-05 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1694","267","2010-02-12 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1695","267","2010-02-19 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1696","267","2010-02-26 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1697","268","2010-01-08 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1698","268","2010-01-15 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1699","268","2010-01-22 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1700","268","2010-01-29 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1701","268","2010-02-05 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1702","268","2010-02-12 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1703","268","2010-02-19 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1704","268","2010-02-26 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1705","269","2010-01-08 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1706","269","2010-01-15 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1707","269","2010-01-22 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1708","269","2010-01-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1709","269","2010-02-05 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1710","269","2010-02-12 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1711","269","2010-02-19 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1712","269","2010-02-26 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1713","270","2010-01-08 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1714","270","2010-01-15 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1715","270","2010-01-22 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1716","270","2010-01-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1717","270","2010-02-05 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1718","270","2010-02-12 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1719","270","2010-02-19 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1720","270","2010-02-26 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1721","271","2010-01-08 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1722","271","2010-01-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1723","271","2010-01-22 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1724","271","2010-01-29 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1725","271","2010-02-05 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1726","271","2010-02-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1727","271","2010-02-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1728","271","2010-02-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1729","272","2010-01-08 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1730","272","2010-01-15 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1731","272","2010-01-22 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1732","272","2010-01-29 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1733","272","2010-02-05 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1734","272","2010-02-12 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1735","272","2010-02-19 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1736","272","2010-02-26 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1737","273","2010-01-08 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1738","273","2010-01-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1739","273","2010-01-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1740","273","2010-01-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1741","273","2010-02-05 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1742","273","2010-02-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1743","273","2010-02-19 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1744","273","2010-02-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1745","274","2010-01-08 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1746","274","2010-01-15 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1747","274","2010-01-22 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1748","274","2010-01-29 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1749","274","2010-02-05 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1750","274","2010-02-12 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1751","274","2010-02-19 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1752","274","2010-02-26 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1753","275","2010-01-08 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1754","275","2010-01-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1755","275","2010-01-22 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1756","275","2010-01-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1757","275","2010-02-05 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1758","275","2010-02-12 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1759","275","2010-02-19 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1760","275","2010-02-26 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1761","276","2010-01-08 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1762","276","2010-01-15 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1763","276","2010-01-22 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1764","276","2010-01-29 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1765","276","2010-02-05 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1766","276","2010-02-12 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1767","276","2010-02-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1768","276","2010-02-26 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1769","277","2010-01-08 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1770","277","2010-01-15 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1771","277","2010-01-22 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1772","277","2010-01-29 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1773","277","2010-02-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1774","277","2010-02-12 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1775","277","2010-02-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1776","277","2010-02-26 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1777","278","2010-01-08 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1778","278","2010-01-15 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1779","278","2010-01-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1780","278","2010-01-29 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1781","278","2010-02-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1782","278","2010-02-12 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1783","278","2010-02-19 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1784","278","2010-02-26 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1785","279","2010-01-08 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1786","279","2010-01-15 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1787","279","2010-01-22 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1788","279","2010-01-29 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1789","279","2010-02-05 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1790","279","2010-02-12 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1791","279","2010-02-19 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1792","279","2010-02-26 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("1793","280","2010-01-08 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1794","280","2010-01-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1795","280","2010-01-22 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1796","280","2010-01-29 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1797","280","2010-02-05 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1798","280","2010-02-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1799","280","2010-02-19 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1800","280","2010-02-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1801","281","2010-01-08 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1802","281","2010-01-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1803","281","2010-01-22 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1804","281","2010-01-29 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1805","281","2010-02-05 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1806","281","2010-02-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1807","281","2010-02-19 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1808","281","2010-02-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1809","282","2010-01-08 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1810","282","2010-01-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1811","282","2010-01-22 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1812","282","2010-01-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1813","282","2010-02-05 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1814","282","2010-02-12 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1815","282","2010-02-19 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1816","282","2010-02-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1817","283","2010-01-08 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1818","283","2010-01-15 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1819","283","2010-01-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1820","283","2010-01-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1821","283","2010-02-05 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1822","283","2010-02-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1823","283","2010-02-19 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1824","283","2010-02-26 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1825","284","2010-01-08 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1826","284","2010-01-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1827","284","2010-01-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1828","284","2010-01-29 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1829","284","2010-02-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1830","284","2010-02-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1831","284","2010-02-19 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1832","284","2010-02-26 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1833","285","2010-01-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1834","285","2010-02-05 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1835","285","2010-02-26 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1836","286","2010-01-08 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1837","286","2010-01-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1838","286","2010-01-22 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1839","286","2010-01-29 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1840","286","2010-02-05 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1841","286","2010-02-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1842","286","2010-02-19 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1843","286","2010-02-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1844","287","2010-01-08 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1845","287","2010-01-15 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1846","287","2010-01-22 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1847","287","2010-01-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1848","287","2010-02-05 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1849","287","2010-02-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1850","287","2010-02-19 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1851","287","2010-02-26 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1852","288","2010-01-08 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1853","288","2010-01-15 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1854","288","2010-01-22 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1855","288","2010-01-29 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("1856","288","2010-02-05 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1857","288","2010-02-12 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1858","288","2010-02-19 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1859","289","2010-01-08 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1860","289","2010-01-15 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1861","289","2010-01-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1862","289","2010-01-29 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1863","289","2010-02-05 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1864","289","2010-02-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1865","289","2010-02-19 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1866","289","2010-02-26 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1867","290","2010-01-08 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1868","290","2010-01-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1869","290","2010-01-22 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1870","290","2010-01-29 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1871","290","2010-02-05 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1872","290","2010-02-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1873","290","2010-02-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1874","290","2010-02-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1875","291","2010-01-08 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1876","291","2010-01-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1877","291","2010-01-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1878","291","2010-01-29 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1879","291","2010-02-05 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1880","291","2010-02-12 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1881","291","2010-02-19 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1882","291","2010-02-26 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1883","292","2010-01-08 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1884","292","2010-01-15 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1885","292","2010-01-22 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1886","292","2010-01-29 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1887","292","2010-02-05 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1888","292","2010-02-12 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1889","292","2010-02-19 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1890","292","2010-02-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1891","293","2010-01-08 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1892","293","2010-01-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1893","294","2010-01-08 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1894","294","2010-01-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1895","294","2010-01-22 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1896","294","2010-01-29 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1897","294","2010-02-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1898","294","2010-02-12 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1899","294","2010-02-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1900","294","2010-02-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1901","295","2010-01-08 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1902","295","2010-01-15 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("1903","295","2010-01-22 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1904","295","2010-01-29 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1905","295","2010-02-05 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1906","295","2010-02-12 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1907","295","2010-02-19 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1908","295","2010-02-26 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("1909","296","2010-01-08 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1910","296","2010-01-15 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1911","296","2010-01-22 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("1912","296","2010-01-29 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1913","296","2010-02-12 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1914","296","2010-02-26 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("1915","297","2010-01-08 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1916","297","2010-01-15 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("1917","297","2010-01-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1918","297","2010-01-29 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("1919","297","2010-02-05 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1920","297","2010-02-12 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("1921","297","2010-02-19 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1922","297","2010-02-26 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("1923","298","2010-01-08 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1924","298","2010-01-15 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1925","298","2010-01-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1926","298","2010-01-29 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1927","298","2010-02-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1928","298","2010-02-12 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1929","298","2010-02-19 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1930","298","2010-02-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1931","299","2010-01-08 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1932","299","2010-01-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1933","299","2010-01-22 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1934","299","2010-01-29 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1935","299","2010-02-05 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1936","299","2010-02-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1937","299","2010-02-19 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1938","299","2010-02-26 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1939","300","2010-01-08 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1940","300","2010-01-15 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1941","300","2010-01-22 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("1942","300","2010-01-29 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("1943","300","2010-02-05 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1944","300","2010-02-12 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1945","300","2010-02-19 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1946","300","2010-02-26 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1947","301","2010-01-08 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1948","301","2010-01-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1949","301","2010-01-22 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1950","301","2010-01-29 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1951","301","2010-02-05 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("1952","301","2010-02-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1953","301","2010-02-19 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1954","301","2010-02-26 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1955","302","2010-01-08 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1956","302","2010-01-15 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1957","302","2010-01-22 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1958","302","2010-01-29 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1959","302","2010-02-05 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1960","302","2010-02-12 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1961","302","2010-02-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1962","302","2010-02-26 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("1963","302","1994-02-27 00:00:00","38","1","0","0");
INSERT INTO tr_orderdetails VALUES("1964","303","2010-01-08 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1965","303","2010-01-15 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1966","303","2010-01-22 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1967","303","2010-01-29 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1968","303","2010-02-05 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("1969","303","2010-02-12 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1970","303","2010-02-19 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1971","303","2010-02-26 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("1972","304","2010-01-08 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1973","305","2010-01-08 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1974","305","2010-01-15 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1975","305","2010-01-22 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1976","305","2010-01-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1977","305","2010-02-05 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("1978","305","2010-02-12 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("1979","305","2010-02-19 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("1980","305","2010-02-26 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("1981","306","2010-01-08 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1982","306","2010-01-15 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1983","306","2010-01-22 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1984","306","2010-01-29 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("1985","306","2010-02-05 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("1986","306","2010-02-12 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1987","306","2010-02-19 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("1988","306","2010-02-26 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1989","307","2010-01-08 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1990","307","2010-01-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1991","307","2010-01-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1992","307","2010-01-29 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1993","307","2010-02-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1994","307","2010-02-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1995","307","2010-02-19 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("1996","307","2010-02-26 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1997","308","2010-01-08 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("1998","308","2010-01-15 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("1999","308","2010-01-22 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2000","308","2010-01-29 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2001","308","2010-02-05 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2002","308","2010-02-12 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2003","308","2010-02-19 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2004","308","2010-02-26 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2005","309","2010-01-08 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2006","309","2010-01-15 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2007","309","2010-01-22 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2008","309","2010-01-29 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("2009","309","2010-02-05 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2010","309","2010-02-12 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2011","309","2010-02-19 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2012","309","2010-02-26 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2013","310","2010-01-22 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2014","310","2010-02-19 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2015","311","2010-01-22 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2016","311","2010-02-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2017","312","2010-01-08 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2018","312","2010-01-15 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2019","312","2010-01-22 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2020","312","2010-01-29 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("2021","312","2010-02-05 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2022","312","2010-02-12 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("2023","312","2010-02-19 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2024","312","2010-02-26 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2025","313","2010-01-08 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2026","313","2010-01-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2027","313","2010-01-22 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2028","313","2010-01-29 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2029","313","2010-02-05 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2030","313","2010-02-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2031","313","2010-02-19 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2032","313","2010-02-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2033","314","2010-01-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2034","314","2010-01-11 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2035","314","2010-01-18 00:00:00","2","3","0","0");
INSERT INTO tr_orderdetails VALUES("2036","314","2010-01-25 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2037","314","2010-02-01 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2038","314","2010-02-08 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2039","314","2010-02-22 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2040","315","2010-01-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2041","315","2010-01-11 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2042","315","2010-01-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2043","315","2010-01-25 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2044","315","2010-02-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2045","315","2010-02-08 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2046","315","2010-02-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2047","316","2010-01-04 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2048","316","2010-01-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2049","316","2010-01-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2050","316","2010-01-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2051","316","2010-02-01 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2052","316","2010-02-08 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2053","316","2010-02-22 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2054","317","2010-01-06 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2055","317","2010-01-20 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("2056","317","2010-02-03 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2057","317","2010-02-17 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2058","318","2010-01-15 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2059","318","2010-01-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2060","318","2010-02-12 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2061","318","2010-02-26 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2062","319","2010-01-06 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2063","319","2010-01-13 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2064","319","2010-01-20 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("2065","319","2010-01-27 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2066","319","2010-02-03 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2067","319","2010-02-10 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("2068","319","2010-02-17 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2069","319","2010-02-24 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2070","320","2010-01-06 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2071","320","2010-01-17 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2072","320","2010-01-17 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2073","320","2010-01-17 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2074","321","2010-01-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2075","321","2010-01-08 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2076","321","2010-01-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2077","321","2010-01-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2078","321","2010-01-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2079","321","2010-02-05 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2080","321","2010-02-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2081","321","2010-02-19 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2082","321","2010-02-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2083","322","2010-01-06 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2084","322","2010-01-13 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2085","322","2010-01-20 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2086","322","2010-01-27 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2087","322","2010-02-03 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2088","322","2010-02-10 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2089","322","2010-02-17 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2090","322","2010-02-24 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2091","323","2010-01-04 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("2092","323","2010-01-06 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2093","323","2010-01-08 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("2094","323","2010-01-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2095","323","2010-01-13 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2096","323","2010-01-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2097","323","2010-01-18 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2098","323","2010-01-20 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2099","323","2010-01-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2100","323","2010-01-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2101","323","2010-01-27 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2102","323","2010-01-29 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2103","323","2010-02-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2104","323","2010-02-03 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2105","323","2010-02-05 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2106","323","2010-02-08 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2107","323","2010-02-10 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2108","323","2010-02-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2109","323","2010-02-17 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2110","323","2010-02-19 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2111","323","2010-02-22 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2112","323","2010-02-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2113","323","2010-02-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2114","324","2010-01-04 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2115","324","2010-01-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2116","324","2010-01-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2117","324","2010-01-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2118","324","2010-02-01 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2119","324","2010-02-08 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2120","324","2010-02-22 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2121","325","2010-01-04 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2122","325","2010-01-11 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2123","325","2010-01-18 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2124","325","2010-01-25 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2125","325","2010-02-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2126","325","2010-02-08 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2127","325","2010-02-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2128","326","2010-01-08 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2129","326","2010-01-22 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2130","326","2010-02-05 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2131","327","2010-01-04 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2132","327","2010-01-08 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("2133","327","2010-01-11 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2134","327","2010-01-15 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2135","327","2010-01-18 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2136","327","2010-01-22 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2137","327","2010-01-25 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("2138","327","2010-01-29 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2139","327","2010-02-01 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2140","327","2010-02-05 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2141","327","2010-02-08 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2142","327","2010-02-12 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("2143","327","2010-02-19 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2144","327","2010-02-22 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2145","327","2010-02-26 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2146","328","2010-01-08 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2147","328","2010-01-15 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("2148","328","2010-01-22 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2149","328","2010-01-29 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("2150","328","2010-02-05 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2151","328","2010-02-12 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("2152","328","2010-02-19 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2153","328","2010-02-26 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("2154","329","2010-01-04 00:00:00","24","1","0","0");
INSERT INTO tr_orderdetails VALUES("2155","329","2010-01-08 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("2156","329","2010-01-11 00:00:00","24","1","0","0");
INSERT INTO tr_orderdetails VALUES("2157","329","2010-01-15 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("2158","329","2010-01-18 00:00:00","24","1","0","0");
INSERT INTO tr_orderdetails VALUES("2159","329","2010-01-22 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("2160","329","2010-01-25 00:00:00","24","1","0","0");
INSERT INTO tr_orderdetails VALUES("2161","329","2010-01-29 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("2162","329","2010-02-01 00:00:00","24","1","0","0");
INSERT INTO tr_orderdetails VALUES("2163","329","2010-02-05 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("2164","329","2010-02-08 00:00:00","24","1","0","0");
INSERT INTO tr_orderdetails VALUES("2165","329","2010-02-12 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("2166","329","2010-02-19 00:00:00","24","1","0","0");
INSERT INTO tr_orderdetails VALUES("2167","329","2010-02-22 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("2168","329","2010-02-26 00:00:00","24","1","0","0");
INSERT INTO tr_orderdetails VALUES("2169","330","2010-01-19 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2170","330","2010-02-16 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2171","331","2010-01-05 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2172","331","2010-01-19 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2173","331","2010-02-02 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("2174","331","2010-02-16 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2175","332","2010-01-05 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2176","332","2010-01-19 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2177","332","2010-02-02 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2178","332","2010-02-16 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2179","333","2010-01-05 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2180","333","2010-01-19 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2181","333","2010-02-02 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2182","333","2010-02-16 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2183","334","2010-01-05 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("2184","334","2010-01-19 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2185","334","2010-02-02 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("2186","334","2010-02-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2187","335","2010-01-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2188","335","2010-01-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2189","335","2010-02-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2190","335","2010-02-16 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2191","336","2010-01-05 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2192","336","2010-01-19 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2193","336","2010-02-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2194","336","2010-02-16 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2195","337","2010-01-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2196","337","2010-01-19 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2197","337","2010-02-02 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2198","337","2010-02-16 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2199","338","2010-01-05 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2200","338","2010-01-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2201","338","2010-02-02 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2202","338","2010-02-16 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2203","339","2010-01-05 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2204","339","2010-01-19 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2205","339","2010-02-02 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2206","339","2010-02-16 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2207","340","2010-01-05 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2208","340","2010-01-19 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2209","340","2010-02-02 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2210","340","2010-02-16 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2211","341","2010-01-05 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2212","341","2010-01-19 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("2213","341","2010-02-02 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2214","341","2010-02-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2215","342","2010-01-05 00:00:00","32","3","0","0");
INSERT INTO tr_orderdetails VALUES("2216","342","2010-01-19 00:00:00","2","3","0","0");
INSERT INTO tr_orderdetails VALUES("2217","342","2010-02-02 00:00:00","33","3","0","0");
INSERT INTO tr_orderdetails VALUES("2218","342","2010-02-16 00:00:00","35","3","0","0");
INSERT INTO tr_orderdetails VALUES("2219","343","2010-01-05 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2220","343","2010-01-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2221","343","2010-02-02 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2222","343","2010-02-16 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2223","344","2010-01-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2224","344","2010-01-19 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2225","344","2010-02-02 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2226","344","2010-02-16 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2227","345","2010-01-05 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2228","345","2010-01-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2229","345","2010-02-02 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2230","345","2010-02-16 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2231","346","2010-01-05 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2232","346","2010-01-19 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2233","346","2010-02-02 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2234","346","2010-02-16 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2235","347","2010-01-05 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2236","347","2010-01-19 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("2237","347","2010-02-02 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2238","347","2010-02-16 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2239","348","2010-01-05 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2240","348","2010-01-19 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2241","348","2010-02-02 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2242","348","2010-02-16 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("2243","349","2010-01-05 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2244","349","2010-01-19 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2245","349","2010-02-02 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2246","349","2010-02-16 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2247","350","2010-01-05 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2248","350","2010-01-19 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2249","350","2010-02-02 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2250","350","2010-02-16 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2251","351","2010-01-05 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2252","351","2010-01-19 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2253","351","2010-02-02 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2254","351","2010-02-16 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2255","352","2010-01-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2256","352","2010-01-19 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2257","352","2010-02-02 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2258","352","2010-02-16 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2259","353","2010-01-05 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2260","353","2010-01-19 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2261","353","2010-02-02 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2262","353","2010-02-16 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2263","354","2010-01-05 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2264","354","2010-01-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2265","354","2010-02-02 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2266","354","2010-02-16 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2267","355","2010-01-05 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2268","355","2010-01-19 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("2269","355","2010-02-02 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2270","355","2010-02-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2271","356","2010-01-05 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2272","356","2010-01-19 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("2273","356","2010-02-02 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2274","356","2010-02-16 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("2275","357","2010-01-05 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2276","357","2010-01-19 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2277","357","2010-02-02 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2278","357","2010-02-16 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2279","358","2010-01-05 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2280","358","2010-01-19 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2281","358","2010-02-02 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2282","358","2010-02-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2283","359","2010-01-05 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2284","359","2010-01-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2285","359","2010-02-02 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2286","359","2010-02-16 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2287","360","2010-01-05 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2288","360","2010-01-19 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2289","360","2010-02-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2290","360","2009-12-21 00:00:00","39","2","0","0");
INSERT INTO tr_orderdetails VALUES("2291","361","2010-01-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2292","361","2010-01-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2293","361","2010-02-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2294","361","2010-02-16 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2295","362","2010-01-05 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2296","362","2010-01-19 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2297","362","2010-02-02 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2298","362","2010-02-16 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2299","363","2010-01-05 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2300","363","2010-01-19 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2301","363","2010-02-02 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2302","363","2010-02-16 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2303","364","2010-01-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2304","364","2010-01-08 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2305","364","2010-01-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2306","364","2010-01-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2307","364","2010-01-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2308","364","2010-01-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2309","364","2010-01-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2310","364","2010-01-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2311","364","2010-02-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2312","364","2010-02-05 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2313","364","2010-02-08 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2314","364","2010-02-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2315","364","2010-02-19 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2316","364","2010-02-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2317","364","2010-02-26 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2318","365","2010-01-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2319","365","2010-01-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2320","365","2010-01-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2321","365","2010-01-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2322","365","2010-01-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2323","365","2010-01-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2324","365","2010-01-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2325","365","2010-01-27 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2326","366","2010-01-08 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2327","366","2010-01-15 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2328","366","2010-01-22 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2329","366","2010-01-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2330","366","2010-02-05 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2331","366","2010-02-12 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2332","366","2010-02-19 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2333","366","2010-02-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2334","367","2010-01-08 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("2335","367","2010-01-15 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2336","367","2010-01-22 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("2337","367","2010-01-29 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2338","367","2010-02-05 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2339","367","2010-02-12 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2340","367","2010-02-19 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2342","368","2010-01-08 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("2343","368","2010-01-15 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2344","368","2010-01-22 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("2345","368","2010-01-29 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2346","368","2010-02-05 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2347","368","2010-02-12 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2348","368","2010-02-19 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2349","368","2010-02-26 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("2350","369","2010-01-08 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2351","369","2010-01-15 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2352","369","2010-01-22 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2353","369","2010-01-29 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2354","369","2010-02-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2355","369","2010-02-12 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2356","369","2010-02-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2357","369","2010-02-26 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2358","370","2010-01-08 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2359","370","2010-01-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2360","370","2010-01-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2361","370","2010-01-29 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2362","370","2010-02-05 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2363","370","2010-02-12 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2364","370","2010-02-19 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2365","370","2010-02-26 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2366","371","2010-01-08 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2367","371","2010-01-15 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2368","371","2010-01-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2369","371","2010-01-29 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2370","371","2010-02-05 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2371","371","2010-02-12 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2372","371","2010-02-19 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2373","371","2010-02-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2374","372","2010-01-08 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2375","372","2010-01-15 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2376","372","2010-01-22 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2377","372","2010-01-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2378","372","2010-02-05 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2379","372","2010-02-12 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2380","372","2010-02-19 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2381","372","2010-02-26 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2382","373","2010-01-08 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2383","373","2010-01-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2384","373","2010-02-05 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2385","373","2010-02-19 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2386","374","2010-01-08 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2387","374","2010-01-15 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2388","374","2010-01-22 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2389","374","2010-01-29 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2390","374","2010-02-05 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2391","374","2010-02-12 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2392","374","2010-02-19 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2393","374","2010-02-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2394","375","2010-01-08 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2395","375","2010-01-15 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2396","375","2010-01-22 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2397","375","2010-01-29 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2398","375","2010-02-05 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2399","375","2010-02-12 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2400","375","2010-02-19 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2401","375","2010-02-26 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2402","376","2010-01-08 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2403","376","2010-01-15 00:00:00","46","1","0","0");
INSERT INTO tr_orderdetails VALUES("2404","376","2010-01-22 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2405","376","2010-01-29 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2406","376","2010-02-04 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2407","376","2010-02-12 00:00:00","46","1","0","0");
INSERT INTO tr_orderdetails VALUES("2408","376","2010-02-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2409","376","2010-02-26 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2410","377","2010-01-08 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2411","377","2010-01-15 00:00:00","47","1","0","0");
INSERT INTO tr_orderdetails VALUES("2412","377","2010-01-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2413","377","2010-01-29 00:00:00","47","1","0","0");
INSERT INTO tr_orderdetails VALUES("2414","377","2010-02-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2415","377","2010-02-12 00:00:00","47","1","0","0");
INSERT INTO tr_orderdetails VALUES("2416","377","2010-02-19 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2417","377","2010-02-26 00:00:00","47","1","0","0");
INSERT INTO tr_orderdetails VALUES("2418","378","2010-01-08 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2419","378","2010-01-15 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2420","378","2010-01-22 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2421","378","2010-01-29 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2422","378","2010-02-05 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2423","378","2010-02-12 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2424","378","2010-02-19 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2425","378","2010-02-26 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2426","379","2010-01-08 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2427","379","2010-01-15 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2428","379","2010-01-22 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2429","379","2010-01-29 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2430","379","2010-02-05 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2431","379","2010-02-12 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2432","379","2010-02-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2433","379","2010-02-26 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2434","380","2010-01-08 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2435","380","2010-01-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2436","380","2010-01-22 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2437","380","2010-01-29 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2438","380","2010-02-05 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2439","380","2010-02-12 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2440","380","2010-02-19 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2441","380","2010-02-26 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2442","381","2010-01-08 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2443","381","2010-01-15 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2444","381","2010-01-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2445","381","2010-01-29 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2446","381","2010-02-05 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2447","381","2010-02-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2448","381","2010-02-19 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2449","381","2010-02-26 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2450","382","2010-01-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2451","382","2010-01-22 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2452","382","2010-01-29 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2453","382","2010-02-05 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2454","382","2010-02-12 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2455","382","2010-02-19 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2456","382","2010-02-26 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2457","383","2010-01-08 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2458","383","2010-01-15 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2459","383","2010-01-22 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2460","383","2010-01-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2461","383","2010-02-05 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2462","383","2010-02-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2463","383","2010-02-19 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2464","383","2010-02-26 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2465","384","2010-01-08 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2466","384","2010-01-15 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("2467","384","2010-01-22 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2468","384","2010-01-29 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2469","384","2010-02-05 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("2470","384","2010-02-12 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2471","384","2010-02-19 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2472","384","2010-02-26 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("2473","385","2010-01-08 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2474","385","2010-01-15 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2475","385","2010-01-22 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2476","385","2010-01-29 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2477","385","2010-02-05 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2478","385","2010-02-12 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2479","385","2010-02-19 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2480","385","2010-02-26 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2481","386","2010-01-08 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2482","386","2010-01-15 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2483","386","2010-01-22 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2484","386","2010-01-29 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2485","386","2010-02-05 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2486","386","2010-02-12 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2487","386","2010-02-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2488","386","2010-02-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2489","387","2010-01-08 00:00:00","45","1","0","0");
INSERT INTO tr_orderdetails VALUES("2490","387","2010-01-15 00:00:00","45","1","0","0");
INSERT INTO tr_orderdetails VALUES("2491","387","2010-01-22 00:00:00","45","1","0","0");
INSERT INTO tr_orderdetails VALUES("2492","387","2010-01-29 00:00:00","45","1","0","0");
INSERT INTO tr_orderdetails VALUES("2493","387","2010-02-05 00:00:00","45","1","0","0");
INSERT INTO tr_orderdetails VALUES("2494","387","2010-02-12 00:00:00","45","1","0","0");
INSERT INTO tr_orderdetails VALUES("2495","387","2010-02-19 00:00:00","45","1","0","0");
INSERT INTO tr_orderdetails VALUES("2496","387","2010-02-26 00:00:00","45","1","0","0");
INSERT INTO tr_orderdetails VALUES("2497","387","2009-12-25 00:00:00","45","1","0","0");
INSERT INTO tr_orderdetails VALUES("2498","388","2010-01-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2499","388","2010-01-19 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2500","388","2010-02-02 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2501","388","2010-02-16 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("2502","389","2010-01-04 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2503","389","2010-01-08 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2504","389","2010-01-11 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2505","389","2010-01-15 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2506","389","2010-01-18 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2507","389","2010-01-22 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2508","389","2010-01-27 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2509","389","2010-02-01 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2510","389","2010-02-03 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2511","389","2010-02-05 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2512","389","2010-02-10 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2513","389","2010-02-12 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2514","389","2010-02-22 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2515","389","2010-02-24 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2516","389","2010-02-26 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2517","389","2009-12-30 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("2518","390","2010-01-05 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2519","391","2010-01-19 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("2520","391","2010-02-02 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2521","391","2010-02-16 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2522","392","2010-01-19 00:00:00","34","2","0","0");
INSERT INTO tr_orderdetails VALUES("2523","392","2010-02-02 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2524","392","2010-02-16 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2525","393","2010-01-19 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("2526","393","2010-02-02 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("2527","393","2010-02-16 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2528","394","2010-02-22 00:00:00","37","1","0","0");
INSERT INTO tr_orderdetails VALUES("2529","395","2010-01-15 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2530","395","2010-01-22 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2531","395","2010-01-29 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2532","395","2010-02-05 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2533","395","2010-02-12 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("2534","395","2010-02-19 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2535","395","2010-02-26 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2536","396","2010-01-15 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2537","396","2010-01-22 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2538","396","2010-01-29 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2539","396","2010-02-05 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2540","396","2010-02-12 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2541","396","2010-02-19 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2542","396","2010-02-26 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("2543","397","2010-01-15 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("2544","397","2010-01-29 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2545","397","2010-02-05 00:00:00","35","1","0","0");
INSERT INTO tr_orderdetails VALUES("2546","397","2010-02-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2547","397","2010-02-19 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("2548","397","2010-02-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2549","397","2010-02-27 00:00:00","40","1","0","0");
INSERT INTO tr_orderdetails VALUES("2550","398","2010-01-11 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2551","398","2010-01-18 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2552","398","2010-01-25 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2553","398","2010-02-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2554","398","2010-02-08 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2555","398","2010-02-17 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("2556","398","2010-02-22 00:00:00","34","2","0","0");
INSERT INTO tr_orderdetails VALUES("2557","399","2010-01-15 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2558","399","2010-01-22 00:00:00","34","2","0","0");
INSERT INTO tr_orderdetails VALUES("2559","399","2010-01-29 00:00:00","31","2","0","0");
INSERT INTO tr_orderdetails VALUES("2560","399","2010-02-05 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2561","399","2010-02-12 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2562","399","2010-02-19 00:00:00","32","2","0","0");
INSERT INTO tr_orderdetails VALUES("2563","399","2010-02-26 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2564","400","2010-01-19 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("2565","400","2010-02-02 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("2566","400","2010-02-16 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("2567","401","2010-01-22 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2568","401","2010-01-29 00:00:00","34","2","0","0");
INSERT INTO tr_orderdetails VALUES("2569","401","2010-02-05 00:00:00","35","2","0","0");
INSERT INTO tr_orderdetails VALUES("2570","401","2010-02-12 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2571","401","2010-02-19 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("2572","401","2010-02-26 00:00:00","34","2","0","0");
INSERT INTO tr_orderdetails VALUES("2573","402","2010-03-03 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2574","402","2010-03-10 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("2575","402","2010-03-24 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("2576","402","2010-03-31 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("2577","402","2010-04-07 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("2578","402","2010-04-14 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("2579","402","2010-04-21 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("2580","402","2010-04-28 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2581","403","2010-03-01 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2582","403","2010-03-05 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2583","403","2010-03-08 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2584","403","2010-03-12 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2585","403","2010-03-22 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2586","403","2010-03-26 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2587","403","2010-03-29 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2588","403","2010-03-31 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2589","403","2010-04-07 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2590","403","2010-04-09 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2591","403","2010-04-12 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2592","403","2010-04-16 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2593","403","2010-04-19 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2594","403","2010-04-23 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2595","403","2010-04-26 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2596","403","2010-04-30 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2597","404","2010-03-01 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2598","404","2010-03-05 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2599","404","2010-03-08 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2600","404","2010-03-12 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2601","404","2010-03-22 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2602","404","2010-03-26 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2603","404","2010-03-29 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2604","404","2010-03-31 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2605","404","2010-04-07 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2606","404","2010-04-09 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2607","404","2010-04-12 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2608","404","2010-04-16 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2609","404","2010-04-19 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2610","404","2010-04-23 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2611","404","2010-04-26 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2612","404","2010-04-30 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2613","405","2010-03-01 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2614","405","2010-03-08 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2615","405","2010-03-22 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("2616","405","2010-03-29 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2617","405","2010-04-12 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2618","405","2010-04-19 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2619","405","2010-04-26 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2620","406","2010-03-01 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("2621","406","2010-03-08 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("2622","406","2010-03-22 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("2623","406","2010-03-29 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("2624","406","2010-04-12 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("2625","406","2010-04-19 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("2626","406","2010-04-26 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("2627","407","2010-03-01 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2628","407","2010-03-08 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2629","407","2010-03-22 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2630","407","2010-03-29 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2631","407","2010-04-12 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2632","407","2010-04-19 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2633","407","2010-04-26 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2634","408","2010-03-03 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("2635","408","2010-03-10 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("2636","408","2010-03-24 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2637","408","2010-03-31 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("2638","408","2010-04-07 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("2639","408","2010-04-14 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("2640","408","2010-04-21 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2641","408","2010-04-28 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("2642","409","2010-03-01 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2643","409","2010-03-05 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2644","409","2010-03-10 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2645","409","2010-03-24 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2646","409","2010-03-31 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2647","409","2010-04-07 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2648","409","2010-04-14 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2649","409","2010-04-21 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2650","410","2010-03-01 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("2651","410","2010-03-08 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("2652","410","2010-03-22 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2653","410","2010-03-29 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2654","410","2010-04-12 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("2655","410","2010-04-19 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("2656","410","2010-04-26 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2657","411","2010-03-01 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2658","411","2010-03-08 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2659","411","2010-03-22 00:00:00","50","4","0","0");
INSERT INTO tr_orderdetails VALUES("2660","411","2010-04-07 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2661","411","2010-04-19 00:00:00","50","4","0","0");
INSERT INTO tr_orderdetails VALUES("2662","412","2010-03-01 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2663","412","2010-03-05 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2664","412","2010-03-08 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2665","412","2010-03-12 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2666","412","2010-03-22 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2667","412","2010-03-26 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2668","412","2010-03-29 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2669","412","2010-04-09 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2670","412","2010-04-12 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2671","412","2010-04-16 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2672","412","2010-04-19 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2673","412","2010-04-23 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2674","412","2010-04-26 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2675","412","2010-04-30 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2676","413","2010-03-01 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2677","413","2010-03-05 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2678","413","2010-03-08 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2679","413","2010-03-12 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2680","413","2010-03-22 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2681","413","2010-03-26 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2682","413","2010-03-29 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2683","413","2010-04-09 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2684","413","2010-04-12 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2685","413","2010-04-16 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2686","413","2010-04-19 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2687","413","2010-04-23 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2688","413","2010-04-26 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2689","413","2010-04-30 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2690","414","2010-03-01 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2691","414","2010-03-03 00:00:00","58","1","0","0");
INSERT INTO tr_orderdetails VALUES("2692","414","2010-03-05 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2693","414","2010-03-08 00:00:00","58","1","0","0");
INSERT INTO tr_orderdetails VALUES("2694","414","2010-03-10 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2695","414","2010-03-12 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2696","414","2010-03-22 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2697","414","2010-03-24 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2698","414","2010-03-26 00:00:00","58","1","0","0");
INSERT INTO tr_orderdetails VALUES("2699","414","2010-03-29 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2700","414","2010-03-31 00:00:00","58","1","0","0");
INSERT INTO tr_orderdetails VALUES("2701","414","2010-04-07 00:00:00","58","1","0","0");
INSERT INTO tr_orderdetails VALUES("2702","414","2010-04-09 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2703","414","2010-04-12 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2704","414","2010-04-14 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2705","414","2010-04-16 00:00:00","58","1","0","0");
INSERT INTO tr_orderdetails VALUES("2706","414","2010-04-19 00:00:00","58","1","0","0");
INSERT INTO tr_orderdetails VALUES("2707","414","2010-04-21 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2708","414","2010-04-23 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2709","414","2010-04-26 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2710","414","2010-04-28 00:00:00","58","1","0","0");
INSERT INTO tr_orderdetails VALUES("2711","414","2010-04-30 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2712","415","2010-03-01 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2713","415","2010-03-05 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2714","415","2010-03-08 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2715","415","2010-03-12 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2716","415","2010-03-22 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2717","415","2010-03-26 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2718","415","2010-03-29 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2719","415","2010-04-09 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2720","415","2010-04-12 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2721","415","2010-04-16 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2722","415","2010-04-19 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2723","415","2010-04-23 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2724","415","2010-04-26 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2725","415","2010-04-30 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2726","416","2010-03-01 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2727","416","2010-03-10 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2728","416","2010-03-26 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2729","416","2010-03-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2730","416","2010-04-07 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("2731","416","2010-04-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2732","416","2010-04-19 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2733","416","2010-04-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2734","417","2010-03-01 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("2735","417","2010-03-03 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("2736","417","2010-03-08 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("2737","417","2010-03-10 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("2738","417","2010-03-22 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("2739","417","2010-03-24 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("2740","417","2010-03-29 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("2741","417","2010-03-31 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("2742","417","2010-04-07 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("2743","417","2010-04-12 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("2744","417","2010-04-14 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("2745","417","2010-04-19 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("2746","417","2010-04-21 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("2747","417","2010-04-26 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("2748","417","2010-04-28 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("2749","418","2010-03-01 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("2750","418","2010-03-03 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("2751","418","2010-03-05 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("2752","418","2010-03-08 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("2753","418","2010-03-10 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("2754","418","2010-03-12 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("2755","418","2010-03-22 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("2756","418","2010-03-24 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("2757","418","2010-03-26 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("2758","418","2010-03-29 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("2759","418","2010-03-31 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("2760","418","2010-04-07 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("2761","418","2010-04-09 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("2762","418","2010-04-12 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("2763","418","2010-04-14 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("2764","418","2010-04-16 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("2765","418","2010-04-19 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("2766","418","2010-04-21 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("2767","418","2010-04-23 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("2768","418","2010-04-26 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("2769","418","2010-04-28 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("2770","418","2010-04-30 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("2771","419","2010-03-01 00:00:00","57","2","0","0");
INSERT INTO tr_orderdetails VALUES("2772","419","2010-03-03 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("2773","419","2010-03-05 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("2774","419","2010-03-08 00:00:00","26","2","0","0");
INSERT INTO tr_orderdetails VALUES("2775","419","2010-03-10 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("2776","419","2010-03-12 00:00:00","41","2","0","0");
INSERT INTO tr_orderdetails VALUES("2777","419","2010-03-22 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("2778","419","2010-03-24 00:00:00","29","2","0","0");
INSERT INTO tr_orderdetails VALUES("2779","419","2010-03-26 00:00:00","57","2","0","0");
INSERT INTO tr_orderdetails VALUES("2780","419","2010-03-29 00:00:00","56","2","0","0");
INSERT INTO tr_orderdetails VALUES("2781","419","2010-03-31 00:00:00","41","2","0","0");
INSERT INTO tr_orderdetails VALUES("2782","419","2010-04-07 00:00:00","26","2","0","0");
INSERT INTO tr_orderdetails VALUES("2783","419","2010-04-09 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("2784","419","2010-04-12 00:00:00","29","2","0","0");
INSERT INTO tr_orderdetails VALUES("2785","419","2010-04-14 00:00:00","57","2","0","0");
INSERT INTO tr_orderdetails VALUES("2786","419","2010-04-16 00:00:00","56","2","0","0");
INSERT INTO tr_orderdetails VALUES("2787","419","2010-04-19 00:00:00","41","2","0","0");
INSERT INTO tr_orderdetails VALUES("2788","419","2010-04-21 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("2789","419","2010-04-23 00:00:00","26","2","0","0");
INSERT INTO tr_orderdetails VALUES("2790","419","2010-04-26 00:00:00","57","2","0","0");
INSERT INTO tr_orderdetails VALUES("2791","419","2010-04-28 00:00:00","56","2","0","0");
INSERT INTO tr_orderdetails VALUES("2792","419","2010-04-30 00:00:00","29","2","0","0");
INSERT INTO tr_orderdetails VALUES("2793","420","2010-03-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2794","420","2010-03-03 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2795","420","2010-03-05 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2796","420","2010-03-08 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2797","420","2010-03-10 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2798","420","2010-03-12 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("2799","420","2010-03-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2800","420","2010-03-24 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2801","420","2010-03-26 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2802","420","2010-03-29 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("2803","420","2010-03-31 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2804","420","2010-04-07 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2805","420","2010-04-09 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2806","420","2010-04-12 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2807","420","2010-04-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2808","420","2010-04-16 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("2809","420","2010-04-19 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2810","420","2010-04-21 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2811","420","2010-04-23 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2812","420","2010-04-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2813","420","2010-04-28 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2814","420","2010-04-30 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2815","421","2010-03-03 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("2816","421","2010-03-12 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2817","421","2010-03-22 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2818","421","2010-03-31 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2819","421","2010-04-09 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2820","421","2010-04-12 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("2821","421","2010-04-23 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2822","421","2010-04-28 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2823","422","2010-03-03 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("2824","422","2010-03-12 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2825","422","2010-03-22 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2826","422","2010-03-31 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2827","422","2010-04-09 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2828","422","2010-04-12 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("2829","422","2010-04-23 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("2830","422","2010-04-28 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2831","423","2010-03-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2832","423","2010-03-08 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2833","423","2010-03-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2834","423","2010-03-29 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2835","423","2010-04-12 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2836","423","2010-04-19 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2837","423","2010-04-26 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2838","424","2010-03-01 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("2839","424","2010-03-08 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2840","424","2010-03-22 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("2841","424","2010-03-29 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("2842","424","2010-04-12 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("2843","424","2010-04-19 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("2844","424","2010-04-26 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("2845","425","2010-03-03 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2846","425","2010-03-10 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("2847","425","2010-03-24 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2848","425","2010-03-31 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2849","425","2010-04-07 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("2850","425","2010-04-14 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2851","425","2010-04-21 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2852","425","2010-04-28 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("2853","426","2010-03-03 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("2854","426","2010-03-10 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("2855","426","2010-03-24 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("2856","426","2010-03-31 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("2857","426","2010-04-07 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("2858","426","2010-04-14 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("2859","426","2010-04-21 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("2860","426","2010-04-28 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("2861","427","2010-03-03 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2862","427","2010-03-10 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2863","427","2010-03-24 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2864","427","2010-03-31 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2865","427","2010-04-07 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2866","427","2010-04-14 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2867","427","2010-04-21 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2868","427","2010-04-28 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2869","428","2010-03-01 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2870","428","2010-03-08 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2871","428","2010-03-22 00:00:00","55","1","0","0");
INSERT INTO tr_orderdetails VALUES("2872","428","2010-03-29 00:00:00","55","1","0","0");
INSERT INTO tr_orderdetails VALUES("2873","428","2010-04-12 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2874","428","2010-04-19 00:00:00","55","1","0","0");
INSERT INTO tr_orderdetails VALUES("2875","428","2010-04-26 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2876","429","2010-03-01 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2877","429","2010-03-03 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2878","429","2010-03-08 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2879","429","2010-03-10 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2880","429","2010-03-22 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2881","429","2010-03-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2882","429","2010-03-29 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2883","429","2010-03-31 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2884","429","2010-04-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2885","429","2010-04-12 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2886","429","2010-04-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2887","429","2010-04-19 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2888","429","2010-04-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2889","429","2010-04-26 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2890","429","2010-04-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2891","430","2010-03-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2892","430","2010-03-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2893","430","2010-03-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2894","430","2010-04-09 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2895","430","2010-04-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2896","430","2010-04-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2897","430","2010-04-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2898","431","2010-03-01 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("2899","431","2010-03-03 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2900","431","2010-03-05 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("2901","431","2010-03-08 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("2902","431","2010-03-10 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("2903","431","2010-03-12 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2904","431","2010-03-22 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("2905","431","2010-03-24 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("2906","431","2010-03-26 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("2907","431","2010-03-29 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2908","431","2010-03-31 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("2909","431","2010-04-07 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("2910","431","2010-04-09 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("2911","431","2010-04-12 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("2912","431","2010-04-14 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("2913","431","2010-04-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2914","431","2010-04-19 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2915","431","2010-04-21 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("2916","431","2010-04-23 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("2917","431","2010-04-26 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2918","431","2010-04-28 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("2919","431","2010-04-30 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("2920","432","2010-03-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2921","432","2010-03-12 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2922","432","2010-03-26 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2923","432","2010-03-31 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2924","432","2010-04-09 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2925","432","2010-04-16 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2926","432","2010-04-23 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2927","432","2010-04-30 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2928","433","2010-03-03 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2929","433","2010-03-05 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2930","433","2010-03-10 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2931","433","2010-03-12 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("2932","433","2010-03-24 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("2933","433","2010-03-26 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2934","433","2010-03-31 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2935","433","2010-04-07 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2936","433","2010-04-09 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2937","433","2010-04-14 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("2938","433","2010-04-16 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2939","433","2010-04-21 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2940","433","2010-04-23 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2941","433","2010-04-28 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2942","433","2010-04-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2943","434","2010-03-05 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("2944","434","2010-03-12 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2945","434","2010-03-26 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("2946","434","2010-04-09 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2947","434","2010-04-16 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("2948","434","2010-04-23 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("2949","434","2010-04-30 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("2950","435","2010-03-01 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("2951","435","2010-03-05 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("2952","435","2010-03-08 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("2953","435","2010-03-12 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("2954","435","2010-03-22 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("2955","435","2010-03-26 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("2956","435","2010-03-29 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("2957","435","2010-04-09 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("2958","435","2010-04-12 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("2959","435","2010-04-16 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("2960","435","2010-04-19 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("2961","435","2010-04-23 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("2962","435","2010-04-26 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("2963","435","2010-04-30 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("2964","435","1992-04-30 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("2965","436","2010-03-05 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2966","436","2010-03-12 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2967","436","2010-03-26 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("2968","436","2010-04-09 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2969","436","2010-04-16 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2970","436","2010-04-23 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("2971","436","2010-04-30 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2972","437","2010-03-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2973","437","2010-03-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2974","437","2010-03-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2975","437","2010-04-09 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2976","437","2010-04-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2977","437","2010-04-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2978","437","2010-04-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2979","438","2010-03-03 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2980","438","2010-03-10 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2981","438","2010-03-24 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2982","438","2010-03-31 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2983","438","2010-04-07 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2984","438","2010-04-14 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("2985","438","2010-04-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("2986","438","2010-04-28 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("2987","439","2010-03-05 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2988","439","2010-03-12 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("2989","439","2010-03-26 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2990","439","2010-04-09 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2991","439","2010-04-16 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("2992","439","2010-04-23 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("2993","439","2010-04-30 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("2994","440","2010-03-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("2995","440","2010-03-08 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("2996","440","2010-03-22 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("2997","440","2010-03-29 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("2998","440","2010-04-12 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("2999","440","2010-04-19 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3000","440","2010-04-26 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3001","441","2010-03-01 00:00:00","49","4","0","0");
INSERT INTO tr_orderdetails VALUES("3002","441","2010-03-08 00:00:00","59","4","0","0");
INSERT INTO tr_orderdetails VALUES("3003","441","2010-03-22 00:00:00","53","4","0","0");
INSERT INTO tr_orderdetails VALUES("3004","441","2010-03-29 00:00:00","49","4","0","0");
INSERT INTO tr_orderdetails VALUES("3005","441","2010-04-12 00:00:00","59","4","0","0");
INSERT INTO tr_orderdetails VALUES("3006","441","2010-04-19 00:00:00","53","4","0","0");
INSERT INTO tr_orderdetails VALUES("3007","441","2010-04-26 00:00:00","59","4","0","0");
INSERT INTO tr_orderdetails VALUES("3008","441","2000-04-26 00:00:00","51","4","0","0");
INSERT INTO tr_orderdetails VALUES("3009","442","2010-03-01 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("3010","442","2010-03-05 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3011","442","2010-03-08 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3012","442","2010-03-12 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3013","442","2010-03-22 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3014","442","2010-03-26 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("3015","442","2010-03-29 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3016","442","2010-04-09 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("3017","442","2010-04-12 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3018","442","2010-04-16 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3019","442","2010-04-19 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3020","442","2010-04-23 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3021","442","2010-04-26 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3022","442","2010-04-30 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("3023","443","2010-03-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3024","443","2010-03-08 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3025","443","2010-03-22 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3026","443","2010-03-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3027","443","2010-04-12 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3028","443","2010-04-19 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3029","443","2010-04-26 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3030","444","2010-03-01 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3031","444","2010-03-03 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3032","444","2010-03-08 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3033","444","2010-03-10 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("3034","444","2010-03-22 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("3035","444","2010-03-24 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3036","444","2010-03-29 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3037","444","2010-03-31 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3038","444","2010-04-07 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("3039","444","2010-04-12 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3040","444","2010-04-14 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3041","444","2010-04-19 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("3042","444","2010-04-21 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3043","444","2010-04-26 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3044","444","2010-04-28 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("3045","445","2010-03-03 00:00:00","48","4","0","0");
INSERT INTO tr_orderdetails VALUES("3046","445","2010-03-10 00:00:00","2","4","0","0");
INSERT INTO tr_orderdetails VALUES("3047","445","2010-03-24 00:00:00","51","4","0","0");
INSERT INTO tr_orderdetails VALUES("3048","445","2010-03-31 00:00:00","51","4","0","0");
INSERT INTO tr_orderdetails VALUES("3049","445","2010-04-07 00:00:00","54","4","0","0");
INSERT INTO tr_orderdetails VALUES("3050","445","2010-04-14 00:00:00","54","4","0","0");
INSERT INTO tr_orderdetails VALUES("3051","445","2010-04-21 00:00:00","54","4","0","0");
INSERT INTO tr_orderdetails VALUES("3052","445","2010-04-28 00:00:00","52","4","0","0");
INSERT INTO tr_orderdetails VALUES("3053","446","2010-03-05 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3054","446","2010-03-12 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3055","446","2010-03-26 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3056","446","2010-04-01 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3057","446","2010-04-09 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3058","446","2010-04-16 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3059","446","2010-04-23 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3060","446","2010-04-30 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3061","447","2010-03-05 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3062","447","2010-03-12 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3063","447","2010-03-26 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3064","447","2010-04-01 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3065","447","2010-04-09 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3066","447","2010-04-16 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3067","447","2010-04-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3068","447","2010-04-30 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3069","448","2010-03-05 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3070","448","2010-03-26 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3071","448","2010-04-16 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3072","448","2010-04-30 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3073","449","2010-03-05 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3074","449","2010-03-12 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3075","449","2010-03-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3076","449","2010-04-01 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("3077","449","2010-04-09 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3078","449","2010-04-16 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3079","449","2010-04-23 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3080","449","2010-04-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3081","450","2010-03-05 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3082","450","2010-03-12 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3083","450","2010-03-26 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3084","450","2010-04-01 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3085","450","2010-04-09 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3086","450","2010-04-16 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3087","450","2010-04-23 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3088","450","2010-04-30 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3089","451","2010-03-05 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3090","451","2010-03-12 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3091","451","2010-03-26 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3092","451","2010-04-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3093","451","2010-04-09 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3094","451","2010-04-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3095","451","2010-04-23 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3096","451","2010-04-30 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3097","452","2010-03-05 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3098","452","2010-03-12 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3099","452","2010-03-26 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3100","452","2010-04-01 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3101","452","2010-04-09 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3102","452","2010-04-16 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3103","452","2010-04-23 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3104","452","2010-04-30 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3105","453","2010-03-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3106","453","2010-03-12 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3107","453","2010-03-26 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3108","453","2010-04-01 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3109","453","2010-04-09 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3110","453","2010-04-16 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3111","453","2010-04-23 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3112","453","2010-04-30 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3113","454","2010-03-05 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3114","454","2010-03-12 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3115","454","2010-03-26 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3116","454","2010-04-01 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3117","454","2010-04-09 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3118","454","2010-04-16 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3119","454","2010-04-23 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3120","454","2010-04-30 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3121","455","2010-03-05 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3122","455","2010-03-12 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3123","455","2010-03-26 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3124","455","2010-04-01 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3125","455","2010-04-09 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3126","455","2010-04-16 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3127","455","2010-04-23 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3128","455","2010-04-30 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3129","456","2010-03-05 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3130","456","2010-03-12 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3131","456","2010-03-26 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3132","456","2010-04-01 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3133","456","2010-04-09 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3134","456","2010-04-16 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3135","456","2010-04-23 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3136","456","2010-04-30 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3137","457","2010-03-05 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3138","457","2010-03-12 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3139","457","2010-03-26 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3140","457","2010-04-01 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3141","457","2010-04-09 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3142","457","2010-04-16 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3143","457","2010-04-23 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3144","457","2010-04-30 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3145","458","2010-03-05 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3146","458","2010-03-12 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3147","458","2010-03-26 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3148","458","2010-04-01 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3149","458","2010-04-09 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3150","458","2010-04-16 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3151","458","2010-04-23 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3152","458","2010-04-30 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3153","459","2010-03-26 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3154","459","2010-04-01 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3155","459","2010-04-09 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3156","459","2010-04-16 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3157","459","2010-04-23 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3158","459","2010-04-30 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3159","460","2010-03-26 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3160","460","2010-04-01 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3161","460","2010-04-09 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3162","460","2010-04-16 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3163","460","2010-04-23 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("3164","460","2010-04-30 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3165","461","2010-03-05 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3166","461","2010-03-12 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3167","461","2010-03-26 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3168","461","2010-04-01 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3169","461","2010-04-09 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3170","461","2010-04-16 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3171","461","2010-04-23 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3172","461","2010-04-30 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3173","462","2010-03-05 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3174","462","2010-03-12 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3175","462","2010-03-26 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3176","462","2010-04-01 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3177","462","2010-04-09 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3178","462","2010-04-16 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3179","462","2010-04-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3180","462","2010-04-30 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3181","463","2010-03-05 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3182","463","2010-03-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3183","463","2010-03-26 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3184","463","2010-04-01 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3185","463","2010-04-09 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3186","463","2010-04-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3187","463","2010-04-23 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3188","463","2010-04-30 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3189","464","2010-03-05 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3190","464","2010-03-12 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3191","464","2010-03-26 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3192","464","2010-04-01 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3193","464","2010-04-09 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3194","464","2010-04-16 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3195","464","2010-04-23 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3196","464","2010-04-30 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3197","465","2010-03-05 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3198","465","2010-03-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3199","465","2010-03-26 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3200","465","2010-04-01 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3201","465","2010-04-09 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3202","465","2010-04-16 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3203","465","2010-04-23 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3204","465","2010-04-30 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("3205","466","2010-03-05 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3206","466","2010-03-12 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3207","466","2010-03-26 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3208","466","2010-04-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3209","466","2010-04-09 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3210","466","2010-04-16 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("3211","466","2010-04-23 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3212","466","2010-04-30 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3213","467","2010-03-05 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3214","467","2010-03-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3215","467","2010-03-26 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3216","467","2010-04-01 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3217","467","2010-04-09 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3218","467","2010-04-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3219","467","2010-04-23 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3220","467","2010-04-30 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3221","468","2010-03-05 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3222","468","2010-03-12 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3223","468","2010-03-26 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3224","468","2010-04-01 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3225","468","2010-04-09 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3226","468","2010-04-16 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3227","468","2010-04-23 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3228","468","2010-04-30 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3229","469","2010-03-05 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3230","469","2010-03-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3231","469","2010-03-26 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3232","469","2010-04-01 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("3233","469","2010-04-09 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3234","469","2010-04-16 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3235","469","2010-04-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3236","469","2010-04-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3245","471","2010-03-05 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3246","471","2010-03-12 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3247","471","2010-03-26 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("3248","471","2010-04-01 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3249","471","2010-04-09 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3250","471","2010-04-16 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3251","471","2010-04-23 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("3252","471","2010-04-30 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3253","472","2010-03-05 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3254","472","2010-03-12 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3255","472","2010-03-26 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3256","472","2010-04-01 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3257","472","2010-04-09 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3258","472","2010-04-16 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3259","472","2010-04-23 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3260","472","2010-04-30 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3261","473","2010-03-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3262","473","2010-03-12 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3263","473","2010-03-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3264","473","2010-04-01 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3265","473","2010-04-09 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3266","473","2010-04-16 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3267","473","2010-04-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3268","473","2010-04-30 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3269","474","2010-03-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3270","474","2010-03-12 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3271","474","2010-03-26 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3272","474","2010-04-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3273","474","2010-04-09 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3274","474","2010-04-16 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3275","474","2010-04-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3276","474","2010-04-30 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3277","475","2010-03-05 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3278","475","2010-03-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3279","475","2010-03-26 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3280","475","2010-04-01 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3281","475","2010-04-09 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3282","475","2010-04-16 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3283","475","2010-04-23 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3284","475","2010-04-30 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3285","476","2010-03-12 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3291","477","2010-03-05 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3292","477","2010-03-12 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3293","477","2010-03-26 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3294","477","2010-04-01 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3295","477","2010-04-09 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3296","477","2010-04-16 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3297","477","2010-04-23 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3298","477","2010-04-30 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3299","478","2010-03-05 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3300","478","2010-03-26 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3301","478","2010-04-09 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3302","478","2010-04-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3303","479","2010-03-05 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3304","479","2010-03-12 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3305","479","2010-03-26 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3306","479","2010-04-01 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3307","479","2010-04-09 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3308","479","2010-04-16 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("3309","479","2010-04-23 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3310","479","2010-04-30 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3311","480","2010-03-05 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3312","480","2010-03-12 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3313","480","2010-03-26 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3314","480","2010-04-01 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3315","480","2010-04-09 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3316","480","2010-04-16 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3317","480","2010-04-23 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3318","480","2010-04-30 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3319","481","2010-03-05 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3320","481","2010-03-12 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3321","481","2010-03-26 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3322","481","2010-04-01 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3323","481","2010-04-09 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3324","481","2010-04-16 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3325","481","2010-04-23 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3326","481","2010-04-30 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3327","482","2010-03-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3328","482","2010-03-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3329","482","2010-03-26 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3330","482","2010-04-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3331","482","2010-04-09 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3332","482","2010-04-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3333","482","2010-04-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3334","482","2010-04-30 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3335","483","2010-03-05 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3336","483","2010-03-12 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3337","483","2010-03-26 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3338","483","2010-04-01 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3339","483","2010-04-09 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3340","483","2010-04-16 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3341","483","2010-04-23 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3342","483","2010-04-30 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3343","484","2010-03-05 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3344","484","2010-03-12 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3345","484","2010-03-26 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3346","484","2010-04-01 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3347","484","2010-04-09 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3348","484","2010-04-16 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3349","484","2010-04-23 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3350","484","2010-04-30 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3351","485","2010-03-05 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3352","485","2010-03-12 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3353","485","2010-03-26 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3354","485","2010-04-01 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("3355","485","2010-04-09 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3356","485","2010-04-16 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3357","485","2010-04-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3358","485","2010-04-30 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3359","486","2010-03-05 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3360","486","2010-03-12 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("3361","486","2010-03-26 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3362","486","2010-04-01 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3363","486","2010-04-09 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("3364","486","2010-04-16 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3365","486","2010-04-23 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3366","486","2010-04-30 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3367","487","2010-03-05 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3368","487","2010-03-12 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3369","487","2010-03-26 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3370","487","2010-04-01 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3371","487","2010-04-09 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3372","487","2010-04-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3373","487","2010-04-23 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3374","487","2010-04-30 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3375","488","2010-03-05 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3376","488","2010-03-12 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3377","488","2010-03-26 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3378","488","2010-04-01 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3379","488","2010-04-09 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3380","488","2010-04-16 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3381","488","2010-04-23 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3382","488","2010-04-30 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3383","489","2010-03-05 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3384","489","2010-03-12 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3385","489","2010-03-26 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3386","489","2010-04-01 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3387","489","2010-04-09 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3388","489","2010-04-16 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3389","489","2010-04-23 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3390","489","2010-04-30 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3391","490","2010-03-05 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3392","490","2010-03-12 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3393","490","2010-03-26 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3394","490","2010-04-01 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3395","490","2010-04-09 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3396","490","2010-04-16 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3397","490","2010-04-23 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3398","490","2010-04-30 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3399","491","2010-03-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3400","491","2010-03-12 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3401","491","2010-03-26 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3402","491","2010-04-01 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3403","491","2010-04-16 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3404","491","2010-04-23 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3405","491","2010-04-30 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3406","492","2010-03-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3407","492","2010-03-12 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3408","492","2010-03-26 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3409","492","2010-04-01 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3410","492","2010-04-16 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3411","492","2010-04-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3412","492","2010-04-30 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3413","493","2010-03-05 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3414","493","2010-03-12 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3415","493","2010-03-26 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3416","493","2010-04-01 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3417","493","2010-04-09 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3418","493","2010-04-16 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3419","493","2010-04-23 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3420","493","2010-04-30 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3421","494","2010-03-05 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3422","494","2010-03-12 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3423","494","2010-03-26 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3424","494","2010-04-01 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3425","494","2010-04-09 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3426","494","2010-04-16 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3427","494","2010-04-23 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3428","494","2010-04-30 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3429","495","2010-03-05 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3430","495","2010-03-12 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("3431","495","2010-03-26 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3432","495","2010-04-01 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3433","495","2010-04-09 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("3434","495","2010-04-16 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3435","495","2010-04-23 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3436","495","2010-04-30 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("3437","496","2010-03-05 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3438","496","2010-03-12 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3439","496","2010-03-26 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3440","496","2010-04-09 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3441","496","2010-04-16 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("3442","496","2010-04-23 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3443","496","2010-04-30 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3445","497","2010-03-12 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3446","497","2010-03-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3447","497","2010-04-01 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3448","497","2010-04-09 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3449","497","2010-04-16 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3450","497","2010-04-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3451","497","2010-04-30 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3452","498","2010-03-05 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3453","498","2010-03-12 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3454","498","2010-03-26 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3455","498","2010-04-01 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3456","498","2010-04-09 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3457","498","2010-04-16 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3458","498","2010-04-23 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3459","498","2010-04-30 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3460","499","2010-03-05 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3461","499","2010-03-12 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3462","499","2010-03-26 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3463","499","2010-04-01 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3464","499","2010-04-09 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3465","499","2010-04-16 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3466","499","2010-04-23 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3467","499","2010-04-30 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3468","500","2010-03-05 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3469","500","2010-03-12 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3470","500","2010-03-26 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3471","500","2010-04-01 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3472","500","2010-04-09 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3473","500","2010-04-16 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3474","500","2010-04-23 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("3475","500","2010-04-30 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3476","501","2010-03-05 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3477","501","2010-03-12 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3478","501","2010-03-26 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3479","501","2010-04-01 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3480","501","2010-04-09 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3481","501","2010-04-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3482","501","2010-04-23 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3483","501","2010-04-30 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3484","502","2010-03-05 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3485","502","2010-03-12 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3486","502","2010-03-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3487","502","2010-04-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3488","502","2010-04-09 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3489","502","2010-04-16 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3490","502","2010-04-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3491","502","2010-04-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3492","503","2010-03-05 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3493","503","2010-03-12 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3494","503","2010-03-26 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3495","503","2010-04-01 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3496","503","2010-04-09 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3497","503","2010-04-16 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3498","503","2010-04-23 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3499","503","2010-04-30 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3500","504","2010-03-05 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3501","504","2010-03-12 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3502","504","2010-03-26 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3503","504","2010-04-01 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3504","504","2010-04-09 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3505","504","2010-04-23 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3506","504","2010-04-16 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3507","505","2010-03-05 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3508","505","2010-03-12 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3509","505","2010-03-26 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3510","505","2010-04-01 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3511","505","2010-04-09 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3512","505","2010-04-16 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3513","505","2010-04-23 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3514","505","2010-04-30 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3515","506","2010-03-05 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3516","506","2010-03-12 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3517","506","2010-03-26 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3518","506","2010-04-01 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3519","506","2010-04-09 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3520","506","2010-04-16 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3521","506","2010-04-23 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3522","506","2010-04-30 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3523","507","2010-03-26 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3524","507","2010-04-01 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3525","507","2010-04-09 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3526","507","2010-04-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3527","507","2010-04-23 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3528","507","2010-04-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3529","508","2010-03-05 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3530","508","2010-03-12 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3531","508","2010-03-26 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3532","508","2010-04-01 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3533","508","2010-04-09 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3534","508","2010-04-16 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3535","508","2010-04-23 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3536","508","2010-04-30 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3537","509","2010-03-05 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3538","509","2010-03-12 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3539","509","2010-03-26 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3540","509","2010-04-01 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3541","509","2010-04-09 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3542","509","2010-04-16 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3543","509","2010-04-23 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3544","509","2010-04-30 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3545","510","2010-03-05 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("3546","510","2010-03-12 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3547","510","2010-03-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3548","510","2010-04-01 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3549","510","2010-04-09 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3550","510","2010-04-16 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3551","510","2010-04-23 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3552","510","2010-04-30 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("3553","511","2010-03-05 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3554","511","2010-03-12 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3555","511","2010-03-26 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3556","511","2010-04-01 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3557","511","2010-04-09 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3558","511","2010-04-16 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3559","511","2010-04-23 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3560","511","2010-04-30 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3561","512","2010-03-05 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3562","512","2010-03-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3563","512","2010-03-26 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3564","512","2010-04-01 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3565","512","2010-04-16 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3566","512","2010-04-23 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3567","512","2010-04-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3568","513","2010-03-05 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3569","513","2010-03-12 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3570","513","2010-03-26 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3571","513","2010-04-01 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3572","513","2010-04-09 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3573","513","2010-04-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3574","513","2010-04-23 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3575","513","2010-04-30 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3576","514","2010-03-05 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3577","514","2010-03-26 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3578","514","2010-04-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3579","514","2010-04-09 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3580","514","2010-04-16 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3581","514","2010-04-23 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3582","514","2010-04-30 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3583","515","2010-03-05 00:00:00","45","1","0","0");
INSERT INTO tr_orderdetails VALUES("3584","515","2010-03-12 00:00:00","45","1","0","0");
INSERT INTO tr_orderdetails VALUES("3585","515","2010-03-26 00:00:00","45","1","0","0");
INSERT INTO tr_orderdetails VALUES("3586","515","2010-04-01 00:00:00","45","1","0","0");
INSERT INTO tr_orderdetails VALUES("3587","515","2010-04-09 00:00:00","45","1","0","0");
INSERT INTO tr_orderdetails VALUES("3588","515","2010-04-16 00:00:00","45","1","0","0");
INSERT INTO tr_orderdetails VALUES("3589","515","2010-04-23 00:00:00","45","1","0","0");
INSERT INTO tr_orderdetails VALUES("3590","516","2010-03-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3591","516","2010-03-12 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3592","516","2010-03-26 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3593","516","2010-04-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3594","516","2010-04-09 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3595","516","2010-04-16 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3596","516","2010-04-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3597","516","2010-04-30 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3598","517","2010-03-02 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3599","517","2010-03-23 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3600","517","2010-04-06 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3601","517","2010-04-20 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3602","518","2010-03-02 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3603","518","2010-03-23 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3604","518","2010-04-06 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3605","518","2010-04-20 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3606","519","2010-03-02 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3607","519","2010-03-23 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3608","519","2010-04-06 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3609","519","2010-04-20 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3610","520","2010-03-02 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3611","520","2010-03-23 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3612","520","2010-04-06 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3613","520","2010-04-20 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3614","521","2010-03-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3615","521","2010-03-23 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3616","521","2010-04-06 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3617","521","2010-04-20 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3618","522","2010-03-02 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3619","522","2010-03-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3620","522","2010-04-06 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3621","522","2010-04-20 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3622","523","2010-03-02 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3623","523","2010-03-23 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3624","523","2010-04-06 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3625","523","2010-04-20 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3626","524","2010-03-02 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3627","524","2010-03-23 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3628","524","2010-04-06 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3629","524","2010-04-20 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3630","525","2010-03-02 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3631","525","2010-03-23 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3632","525","2010-04-06 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3633","525","2010-04-20 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3634","526","2010-03-02 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3635","526","2010-03-23 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3636","526","2010-04-06 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3637","526","2010-04-20 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3638","527","2010-03-02 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3639","527","2010-03-23 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3640","527","2010-04-06 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3641","527","2010-04-20 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3642","528","2010-03-02 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3643","528","2010-03-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3644","528","2010-04-06 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3645","528","2010-04-20 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3646","529","2010-03-02 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3647","529","2010-03-23 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3648","529","2010-04-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3649","529","2010-04-20 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3650","530","2010-03-02 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3651","530","2010-03-23 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("3652","530","2010-04-06 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3653","530","2010-04-20 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3654","531","2010-03-02 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("3655","531","2010-03-23 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3656","531","2010-04-06 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3657","531","2010-04-20 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3658","532","2010-03-02 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3659","532","2010-03-23 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3660","532","2010-04-06 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3661","532","2010-04-20 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3662","533","2010-03-02 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3663","533","2010-03-23 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3664","533","2010-04-06 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3665","533","2010-04-20 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3666","534","2010-03-02 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3667","534","2010-03-23 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3668","534","2010-04-06 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3669","534","2010-04-20 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3670","535","2010-03-02 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3671","535","2010-03-23 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3672","535","2010-04-06 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("3673","535","2010-04-20 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3674","536","2010-03-02 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3675","536","2010-03-23 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3676","536","2010-04-06 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3677","536","2010-04-20 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3678","537","2010-03-02 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3679","537","2010-03-23 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3680","537","2010-04-06 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3681","537","2010-04-20 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3682","538","2010-03-02 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3683","538","2010-03-23 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3684","538","2010-04-06 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3685","538","2010-04-20 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3686","539","2010-03-02 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3687","539","2010-03-23 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3688","539","2010-04-06 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3689","539","2010-04-20 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3690","540","2010-03-02 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3691","540","2010-03-23 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3692","540","2010-04-06 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3693","540","2010-04-20 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3694","541","2010-03-02 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3695","541","2010-03-23 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3696","541","2010-04-06 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3697","541","2010-04-20 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3698","542","2010-03-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3699","542","2010-04-06 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3700","542","2010-04-20 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3701","543","2010-03-02 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3702","543","2010-03-23 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3703","543","2010-04-06 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3704","543","2010-04-20 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3705","544","2010-03-02 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3706","544","2010-03-23 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3707","544","2010-04-06 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3708","544","2010-04-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3709","545","2010-03-02 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3710","545","2010-03-23 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3711","545","2010-04-06 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3712","545","2010-04-20 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3713","546","2010-03-02 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3714","546","2010-03-23 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3715","546","2010-04-06 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3716","546","2010-04-20 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3717","547","2010-03-02 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3718","547","2010-03-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3719","547","2010-04-06 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3720","547","2010-04-20 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3721","548","2010-03-02 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3722","548","2010-03-23 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3723","548","2010-04-06 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("3724","548","2010-04-20 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3725","549","2010-03-02 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3726","549","2010-03-23 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3727","549","2010-04-06 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3728","549","2010-04-20 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3729","550","2010-03-02 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3730","550","2010-03-23 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3731","550","2010-04-06 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3732","550","2010-04-20 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3733","551","2010-03-02 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3734","551","2010-03-23 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("3735","551","2010-04-06 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3736","551","2010-04-20 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3737","552","2010-03-02 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3738","552","2010-03-23 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3739","552","2010-04-06 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3740","552","2010-04-20 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3741","553","2010-03-02 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3742","553","2010-03-23 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3743","553","2010-04-06 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3744","553","2010-04-20 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3745","554","2010-03-02 00:00:00","49","3","0","0");
INSERT INTO tr_orderdetails VALUES("3746","554","2010-03-23 00:00:00","54","3","0","0");
INSERT INTO tr_orderdetails VALUES("3747","554","2010-04-06 00:00:00","48","3","0","0");
INSERT INTO tr_orderdetails VALUES("3748","554","2010-04-20 00:00:00","50","3","0","0");
INSERT INTO tr_orderdetails VALUES("3749","555","2010-03-02 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3750","555","2010-04-06 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3751","555","2010-04-20 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3752","556","2010-03-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3753","556","2010-03-23 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3754","556","2010-04-06 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3755","556","2010-04-20 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3756","557","2010-03-02 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3757","557","2010-03-23 00:00:00","51","3","0","0");
INSERT INTO tr_orderdetails VALUES("3758","557","2010-04-06 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3759","557","2010-04-20 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3760","558","2010-03-02 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3761","558","2010-03-23 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3762","558","2010-04-06 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3763","558","2010-04-20 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3764","559","2010-03-02 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3765","559","2010-03-23 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3766","559","2010-04-06 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3771","560","2010-04-20 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3772","561","2010-03-02 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3773","561","2010-03-23 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3774","561","2010-04-06 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3775","561","2010-04-20 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3776","562","2010-03-02 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3777","562","2010-03-23 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3778","562","2010-04-06 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3779","562","2010-04-20 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3780","563","2010-03-05 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3781","563","2010-03-12 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3782","564","2010-03-05 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3783","564","2010-03-12 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3792","566","2010-03-02 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3793","566","2010-03-23 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3794","566","2010-04-06 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3795","566","2010-04-20 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3796","567","2010-03-02 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3797","567","2010-03-23 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3798","567","2010-04-06 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3799","567","2010-04-20 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3800","568","2010-03-16 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3801","568","2010-03-23 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3802","568","2010-04-06 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3803","568","2010-04-20 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3804","569","2010-03-05 00:00:00","60","1","0","0");
INSERT INTO tr_orderdetails VALUES("3805","569","2010-03-26 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3806","569","2010-04-16 00:00:00","60","1","0","0");
INSERT INTO tr_orderdetails VALUES("3807","569","2010-04-30 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3808","570","2010-03-02 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3809","570","2010-03-23 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3810","570","2010-04-06 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3811","570","2010-04-20 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3812","571","2010-03-02 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3813","571","2010-03-23 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3814","571","2010-04-06 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3815","571","2010-04-20 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3816","572","2010-03-03 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3817","572","2010-03-10 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3818","572","2010-03-24 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3819","572","2010-03-31 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3820","572","2010-04-09 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3821","572","2010-04-16 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3822","572","2010-04-23 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3823","572","2010-04-30 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3824","573","2010-03-01 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3825","573","2010-03-08 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3826","573","2010-03-22 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3827","573","2010-03-29 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3828","573","2010-04-12 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3829","573","2010-04-19 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3830","573","2010-04-26 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3831","574","2010-03-01 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3832","574","2010-03-08 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3833","574","2010-03-22 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3834","574","2010-03-29 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3835","574","2010-04-12 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3836","574","2010-04-19 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3837","574","2010-04-26 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3838","575","2010-03-03 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3839","575","2010-03-10 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3840","575","2010-03-24 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3841","575","2010-03-31 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3842","575","2010-04-07 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3843","575","2010-04-14 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3844","575","2010-04-21 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3845","575","2010-04-28 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3846","576","2010-03-01 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3847","576","2010-03-03 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3848","576","2010-03-05 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3849","576","2010-03-08 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3850","576","2010-03-10 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3851","576","2010-03-12 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3852","576","2010-03-22 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3853","576","2010-03-24 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3854","576","2010-03-26 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3855","576","2010-03-29 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3856","576","2010-03-31 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3857","576","2010-04-07 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3858","576","2010-04-09 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3859","576","2010-04-12 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3860","576","2010-04-14 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3861","576","2010-04-16 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3862","576","2010-04-19 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3863","576","2010-04-21 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3864","576","2010-04-23 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3865","576","2010-04-26 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3866","576","2010-04-28 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3867","576","2010-04-30 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3868","577","2010-03-01 00:00:00","61","1","0","0");
INSERT INTO tr_orderdetails VALUES("3869","577","2010-03-03 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3870","577","2010-03-05 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("3871","577","2010-03-08 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3872","577","2010-03-10 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3873","577","2010-03-12 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3874","577","2010-03-22 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3875","577","2010-03-24 00:00:00","61","1","0","0");
INSERT INTO tr_orderdetails VALUES("3876","577","2010-03-26 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3877","577","2010-03-29 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3878","577","2010-03-31 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3879","577","2010-04-07 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3880","577","2010-04-09 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3881","577","2010-04-12 00:00:00","61","1","0","0");
INSERT INTO tr_orderdetails VALUES("3882","577","2010-04-14 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3883","577","2010-04-16 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3884","577","2010-04-19 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3885","577","2010-04-21 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3886","577","2010-04-23 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3887","577","2010-04-26 00:00:00","52","1","0","0");
INSERT INTO tr_orderdetails VALUES("3888","577","2010-04-28 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3889","577","2010-04-30 00:00:00","61","1","0","0");
INSERT INTO tr_orderdetails VALUES("3890","578","2010-03-05 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3891","578","2010-03-12 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3892","578","2010-03-26 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3893","578","2010-04-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3894","578","2010-04-09 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3895","578","2010-04-16 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3896","578","2010-04-23 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3897","578","2010-04-30 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3898","579","2010-03-05 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3899","579","2010-03-12 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3900","579","2010-03-26 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3901","579","2010-04-01 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3902","579","2010-04-09 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("3903","579","2010-04-16 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3904","579","2010-04-23 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3905","579","2010-04-30 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3906","580","2010-03-05 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3907","580","2010-03-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3908","580","2010-03-26 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3909","580","2010-04-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3910","580","2010-04-09 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3911","580","2010-04-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3912","580","2010-04-23 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3913","580","2010-04-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3914","581","2010-03-12 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3915","581","2010-03-26 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3916","581","2010-03-05 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3917","581","2010-04-30 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3918","581","2010-04-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3919","581","2010-04-16 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3920","581","2010-04-23 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3921","581","2010-04-09 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3922","582","2010-02-26 00:00:00","31","1","0","0");
INSERT INTO tr_orderdetails VALUES("3923","582","2010-03-01 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3924","582","2010-03-03 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3925","583","2010-02-26 00:00:00","32","1","0","0");
INSERT INTO tr_orderdetails VALUES("3926","583","2010-03-01 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3927","583","2010-03-03 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3928","584","2010-03-23 00:00:00","34","2","0","0");
INSERT INTO tr_orderdetails VALUES("3929","584","2010-04-06 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3930","584","2010-04-20 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3931","585","2010-03-23 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3932","585","2010-04-06 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3933","585","2010-04-20 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3934","586","2010-03-02 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3935","586","2010-03-23 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("3936","586","2010-04-06 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3937","586","2010-04-20 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("3938","587","2010-03-02 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3939","587","2010-03-23 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3940","587","2010-04-06 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3941","587","2010-04-20 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3942","588","2010-03-05 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3943","588","2010-03-12 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3944","588","2010-03-26 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3945","588","2010-04-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3946","588","2010-04-09 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3947","588","2010-04-16 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3948","588","2010-04-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("3949","588","2010-04-30 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3950","589","2010-03-05 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3951","589","2010-03-26 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3952","589","2010-04-09 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3953","589","2010-04-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3954","590","2010-03-05 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3955","590","2010-03-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3956","590","2010-03-26 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3957","590","2010-04-01 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3958","590","2010-04-09 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3959","590","2010-04-16 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3960","590","2010-04-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("3962","591","2010-04-30 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3963","592","2010-03-05 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3964","592","2010-03-12 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3965","592","2010-03-26 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("3966","592","2010-04-01 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3967","592","2010-04-09 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3968","592","2010-04-16 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3969","592","2010-04-23 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3970","592","2010-04-30 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3971","593","2010-03-05 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3972","593","2010-03-12 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3973","593","2010-03-26 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3974","593","2010-04-01 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3975","593","2010-04-09 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3976","593","2010-04-16 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3977","593","2010-04-23 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3978","593","2010-04-30 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3979","594","2010-03-05 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3980","594","2010-03-12 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3981","594","2010-03-26 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3982","594","2010-04-01 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3983","594","2010-04-09 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3984","594","2010-04-16 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3985","594","2010-04-23 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("3986","594","2010-04-30 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3987","595","2010-03-05 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3988","595","2010-03-12 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3989","595","2010-03-26 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("3990","595","2010-04-01 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3991","595","2010-04-09 00:00:00","54","1","0","0");
INSERT INTO tr_orderdetails VALUES("3992","595","2010-04-16 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3993","595","2010-04-23 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("3994","595","2010-04-30 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("3995","596","2010-03-12 00:00:00","49","1","0","0");
INSERT INTO tr_orderdetails VALUES("3996","597","2010-03-08 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("3997","597","2010-03-22 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("3998","597","2010-03-29 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("3999","597","2010-04-12 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("4000","597","2010-04-19 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("4001","597","2010-04-26 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("4002","598","2010-03-12 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("4003","598","2010-03-26 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("4004","598","2010-04-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4005","598","2010-04-09 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("4006","598","2010-04-16 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("4007","598","2010-04-23 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("4008","598","2010-04-30 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("4009","599","2010-03-26 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("4010","599","2010-04-01 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("4011","599","2010-04-09 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4012","599","2010-04-16 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("4013","599","2010-04-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4014","599","2010-04-30 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("4015","600","2010-03-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4016","600","2010-04-01 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("4017","600","2010-04-09 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4018","600","2010-04-16 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("4019","600","2010-04-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4020","600","2010-04-30 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("4021","601","2010-04-09 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("4022","601","2010-04-16 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("4023","601","2010-04-23 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("4024","601","2010-04-30 00:00:00","48","1","0","0");
INSERT INTO tr_orderdetails VALUES("4025","602","2010-04-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4026","603","2010-04-16 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("4027","604","2010-04-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4028","605","2010-04-16 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("4029","606","2010-04-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4030","607","2010-04-16 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("4031","608","2010-04-16 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("4032","609","2010-04-16 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("4033","610","2010-04-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4034","611","2010-04-16 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("4035","612","2010-04-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4036","613","2010-04-16 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("4037","614","2010-04-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4038","615","2010-04-16 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("4039","616","2010-04-16 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("4040","617","2010-04-16 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("4041","618","2010-04-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4042","619","2010-04-16 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("4043","620","2010-04-16 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("4044","621","2010-04-16 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("4045","622","2010-04-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4046","623","2010-04-16 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("4047","624","2010-04-16 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("4048","625","2010-04-16 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("4049","626","2010-04-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4050","627","2010-04-16 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("4051","628","2010-04-16 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("4052","629","2010-04-16 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("4053","630","2010-04-16 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("4054","631","2010-04-16 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("4055","632","2010-04-16 00:00:00","48","5","0","0");
INSERT INTO tr_orderdetails VALUES("4056","633","2010-04-16 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("4057","634","2010-04-16 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("4058","635","2010-04-16 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("4059","636","2010-04-16 00:00:00","51","5","0","0");
INSERT INTO tr_orderdetails VALUES("4060","637","2010-04-16 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("4061","638","2010-04-16 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("4062","639","2010-04-16 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("4063","640","2010-04-16 00:00:00","51","2","0","0");
INSERT INTO tr_orderdetails VALUES("4064","641","2010-04-16 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("4065","642","2010-04-16 00:00:00","49","3","0","0");
INSERT INTO tr_orderdetails VALUES("4066","643","2010-04-16 00:00:00","49","2","0","0");
INSERT INTO tr_orderdetails VALUES("4067","644","2010-04-16 00:00:00","51","1","0","0");
INSERT INTO tr_orderdetails VALUES("4068","645","2010-04-16 00:00:00","50","5","0","0");
INSERT INTO tr_orderdetails VALUES("4069","646","2010-04-16 00:00:00","48","5","0","0");
INSERT INTO tr_orderdetails VALUES("4070","647","2010-04-16 00:00:00","2","4","0","0");
INSERT INTO tr_orderdetails VALUES("4071","648","2010-04-16 00:00:00","50","1","0","0");
INSERT INTO tr_orderdetails VALUES("4072","649","2010-04-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4073","650","2010-04-16 00:00:00","48","3","0","0");
INSERT INTO tr_orderdetails VALUES("4074","651","2010-04-16 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("4075","652","2010-04-16 00:00:00","54","2","0","0");
INSERT INTO tr_orderdetails VALUES("4076","653","2010-04-16 00:00:00","48","2","0","0");
INSERT INTO tr_orderdetails VALUES("4077","654","2010-04-16 00:00:00","52","2","0","0");
INSERT INTO tr_orderdetails VALUES("4078","655","2010-04-16 00:00:00","50","2","0","0");
INSERT INTO tr_orderdetails VALUES("4079","656","2010-04-16 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("4080","657","2010-04-16 00:00:00","50","4","0","0");
INSERT INTO tr_orderdetails VALUES("4081","658","2010-05-03 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4082","658","2010-05-05 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4083","658","2010-05-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4084","658","2010-05-10 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4085","658","2010-05-12 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4086","658","2010-05-14 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4087","658","2010-05-17 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4088","658","2010-05-19 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4089","658","2010-05-21 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4090","658","2010-05-26 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4091","658","2010-05-28 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4092","658","2010-05-31 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4093","658","2010-06-02 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4094","658","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4095","658","2010-06-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4096","658","2010-06-09 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4097","658","2010-06-11 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4098","658","2010-06-14 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4099","658","2010-06-16 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4100","658","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4101","658","2010-06-21 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4102","658","2010-06-23 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4103","658","2010-06-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4104","658","2010-06-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4105","659","2010-05-07 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4106","659","2010-05-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4107","659","2010-05-21 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4108","659","2010-05-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4109","659","2010-06-04 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4110","659","2010-06-11 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4111","659","2010-06-18 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4112","659","2010-06-25 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4113","660","2010-05-03 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("4114","660","2010-05-07 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4115","660","2010-05-10 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4116","660","2010-05-14 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4117","660","2010-05-21 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4118","660","2010-05-28 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("4119","660","2010-05-31 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4120","660","2010-06-04 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4121","660","2010-06-07 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4122","660","2010-06-11 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4123","660","2010-06-14 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("4124","660","2010-06-18 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4125","660","2010-06-21 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4126","660","2010-06-25 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4127","660","2010-06-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4128","661","2010-05-07 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4129","661","2010-05-14 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4130","661","2010-05-21 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4131","661","2010-05-28 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4132","661","2010-06-04 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4133","661","2010-06-11 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4134","661","2010-06-18 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4135","661","2010-06-25 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4136","662","2010-05-03 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4137","662","2010-05-10 00:00:00","66","1","0","0");
INSERT INTO tr_orderdetails VALUES("4138","662","2010-05-17 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4139","662","2010-05-31 00:00:00","66","1","0","0");
INSERT INTO tr_orderdetails VALUES("4140","662","2010-06-07 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4141","662","2010-06-14 00:00:00","66","1","0","0");
INSERT INTO tr_orderdetails VALUES("4142","662","2010-06-21 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4143","662","2010-06-28 00:00:00","66","1","0","0");
INSERT INTO tr_orderdetails VALUES("4144","663","2010-05-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4145","663","2010-05-12 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4146","663","2010-05-19 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4147","663","2010-05-26 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4148","663","2010-06-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4149","663","2010-06-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4150","663","2010-06-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4151","663","2010-06-23 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4152","664","2010-05-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4153","664","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4154","664","2010-05-21 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4155","664","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4156","664","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4157","664","2010-06-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4158","664","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4159","664","2010-06-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4160","665","2010-05-03 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4161","665","2010-05-10 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4162","665","2010-05-17 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4163","665","2010-05-31 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4164","665","2010-06-07 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4165","665","2010-06-14 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4166","665","2010-06-21 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4167","665","2010-06-28 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4168","666","2010-05-03 00:00:00","65","4","0","0");
INSERT INTO tr_orderdetails VALUES("4169","667","2010-05-03 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4170","667","2010-05-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4171","667","2010-05-10 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4172","667","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4173","667","2010-05-17 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4174","667","2010-05-21 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4175","667","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4176","667","2010-05-31 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4177","667","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4178","667","2010-06-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4179","667","2010-06-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4180","667","2010-06-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4181","667","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4182","667","2010-06-21 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4183","667","2010-06-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4184","667","2010-06-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4185","668","2010-05-07 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4186","668","2010-05-21 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4187","668","2010-06-04 00:00:00","67","1","0","0");
INSERT INTO tr_orderdetails VALUES("4188","668","2010-06-18 00:00:00","66","1","0","0");
INSERT INTO tr_orderdetails VALUES("4189","669","2010-05-03 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4190","669","2010-05-10 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4191","670","2010-05-07 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4192","670","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4193","670","2010-05-21 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4194","670","2010-05-28 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4195","670","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4196","670","2010-06-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4197","670","2010-06-18 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4198","670","2010-06-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4199","671","2010-05-05 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4200","671","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4201","671","2010-05-17 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4202","671","2010-05-28 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4203","671","2010-06-04 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4204","671","2010-06-07 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4205","671","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4206","671","2010-06-23 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4207","671","2010-06-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4208","672","2010-05-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4209","672","2010-05-12 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4210","672","2010-05-19 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4211","672","2010-05-28 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4212","672","2010-06-02 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4213","672","2010-06-09 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4214","672","2010-06-16 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4215","672","2010-06-23 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4216","672","2010-06-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4217","673","2010-05-03 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4218","673","2010-05-05 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4219","673","2010-05-10 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4220","673","2010-05-12 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4221","673","2010-05-17 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4222","673","2010-05-19 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4223","673","2010-05-26 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4224","673","2010-05-31 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4225","673","2010-06-02 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4226","673","2010-06-07 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4227","673","2010-06-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4228","673","2010-06-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4229","673","2010-06-16 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4230","673","2010-06-21 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4231","673","2010-06-23 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4232","673","2010-06-28 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4233","674","2010-05-05 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4234","674","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4235","674","2010-05-17 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4236","674","2010-05-26 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4237","674","2010-06-04 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4238","674","2010-06-07 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4239","674","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4240","674","2010-06-23 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4241","674","2010-06-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4242","675","2010-05-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4243","675","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4244","675","2010-05-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4245","675","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4246","675","2010-06-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4247","675","2010-06-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4248","675","2010-06-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4249","675","2010-06-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4250","676","2010-05-03 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4251","676","2010-05-05 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4252","676","2010-05-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4253","676","2010-05-10 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4254","676","2010-05-12 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4255","676","2010-05-14 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4256","676","2010-05-17 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4257","676","2010-05-19 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4258","676","2010-05-21 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4259","676","2010-05-26 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4260","676","2010-05-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4261","676","2010-05-31 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4262","676","2010-06-02 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4263","676","2010-06-04 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4264","676","2010-06-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4265","676","2010-06-09 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4266","676","2010-06-11 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4267","676","2010-06-14 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4268","676","2010-06-16 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4269","676","2010-06-18 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4270","676","2010-06-21 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4271","676","2010-06-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4272","676","2010-06-25 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4273","676","2010-06-28 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4274","677","2010-05-05 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4275","677","2010-05-12 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4276","677","2010-05-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4277","677","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4278","677","2010-06-02 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4279","677","2010-06-09 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4280","677","2010-06-16 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4281","677","2010-06-23 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4282","677","2010-06-28 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4283","678","2010-05-03 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4284","678","2010-05-10 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4285","678","2010-05-17 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4286","678","2010-05-31 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4287","678","2010-06-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4288","678","2010-06-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4289","678","2010-06-21 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4290","678","2010-06-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4291","679","2010-05-03 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4292","679","2010-05-10 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4293","679","2010-05-12 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4294","679","2010-05-17 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4295","679","2010-05-19 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4296","679","2010-05-31 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4297","679","2010-06-02 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4298","679","2010-06-07 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4299","679","2010-06-09 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4300","679","2010-06-14 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4302","679","2010-06-21 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4303","679","2010-06-23 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4305","680","2010-05-07 00:00:00","65","4","0","0");
INSERT INTO tr_orderdetails VALUES("4306","680","2010-06-09 00:00:00","65","4","0","0");
INSERT INTO tr_orderdetails VALUES("4307","681","2010-05-05 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4308","681","2010-05-12 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4309","681","2010-05-19 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4310","681","2010-05-26 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4311","681","2010-06-02 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4312","681","2010-06-09 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4313","681","2010-06-16 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4314","681","2010-06-23 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4315","681","2010-06-28 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4316","682","2010-05-03 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4317","682","2010-05-05 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4318","682","2010-05-07 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4319","682","2010-05-10 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4320","682","2010-05-12 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4321","682","2010-05-14 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4322","682","2010-05-17 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4323","682","2010-05-19 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4324","682","2010-05-21 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4325","682","2010-05-26 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4326","682","2010-05-28 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4327","682","2010-05-31 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4328","682","2010-06-02 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4329","682","2010-06-04 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4330","682","2010-06-07 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4331","682","2010-06-09 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4332","682","2010-06-11 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4333","682","2010-06-14 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4334","682","2010-06-16 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4335","682","2010-06-18 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4336","682","2010-06-21 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4337","682","2010-06-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4338","682","2010-06-25 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4339","682","2010-06-28 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4340","683","2010-05-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4341","683","2010-05-12 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4342","683","2010-05-19 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4343","683","2010-05-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4344","683","2010-06-02 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4345","683","2010-06-09 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4346","683","2010-06-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4347","683","2010-06-23 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4348","684","2010-05-03 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4349","684","2010-05-10 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4350","684","2010-05-17 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4351","684","2010-05-31 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4352","684","2010-06-07 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("4353","684","2010-06-14 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4354","684","2010-06-21 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4355","684","2010-06-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4356","685","2010-05-05 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4357","685","2010-05-12 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4358","685","2010-05-19 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4359","685","2010-05-26 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4360","685","2010-06-02 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4361","685","2010-06-09 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4362","685","2010-06-16 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4363","685","2010-06-23 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4364","686","2010-05-03 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4365","686","2010-05-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4366","686","2010-05-10 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4367","686","2010-05-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4368","686","2010-05-17 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4369","686","2010-05-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4370","686","2010-05-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4371","686","2010-05-31 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4372","686","2010-06-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4373","686","2010-06-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4374","686","2010-06-11 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4375","686","2010-06-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4376","686","2010-06-18 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4377","686","2010-06-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4378","686","2010-06-25 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4379","686","2010-06-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4380","687","2010-05-03 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4381","687","2010-05-10 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4382","688","2010-05-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4383","688","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4384","688","2010-05-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4385","688","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4386","688","2010-06-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4387","688","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4388","688","2010-06-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4389","689","2010-05-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4390","689","2010-05-21 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4391","689","2010-05-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4392","689","2010-06-04 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4393","689","2010-06-11 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4394","689","2010-06-18 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4395","689","2010-06-25 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4396","690","2010-04-28 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4397","690","2010-04-30 00:00:00","50","5","0","0");
INSERT INTO tr_orderdetails VALUES("4398","691","2010-05-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4399","691","2010-05-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4400","691","2010-06-01 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4401","691","2010-06-15 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4402","691","2010-06-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4403","692","2010-05-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4404","692","2010-05-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4405","692","2010-06-01 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4406","692","2010-06-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4407","692","2010-06-29 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4408","693","2010-05-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4409","693","2010-05-18 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4410","693","2010-06-01 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4411","693","2010-06-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4412","693","2010-06-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4413","694","2010-05-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4414","694","2010-05-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4415","694","2010-06-01 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4416","694","2010-06-15 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4417","694","2010-06-29 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4418","695","2010-05-04 00:00:00","64","3","0","0");
INSERT INTO tr_orderdetails VALUES("4419","695","2010-05-18 00:00:00","65","3","0","0");
INSERT INTO tr_orderdetails VALUES("4420","695","2010-06-01 00:00:00","64","3","0","0");
INSERT INTO tr_orderdetails VALUES("4421","695","2010-06-15 00:00:00","65","3","0","0");
INSERT INTO tr_orderdetails VALUES("4422","695","2010-06-29 00:00:00","64","3","0","0");
INSERT INTO tr_orderdetails VALUES("4423","696","2010-05-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4424","696","2010-05-18 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4425","696","2010-06-01 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4426","696","2010-06-15 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4427","696","2010-06-29 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4428","697","2010-05-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4429","697","2010-05-18 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4430","697","2010-06-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4431","697","2010-06-15 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4432","697","2010-06-29 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4433","698","2010-05-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4434","698","2010-05-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4435","698","2010-06-01 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4436","698","2010-06-15 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4437","698","2010-06-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4438","699","2010-05-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4439","699","2010-05-18 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4440","699","2010-06-01 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4441","699","2010-06-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4442","699","2010-06-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4443","700","2010-05-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4444","700","2010-05-18 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4445","700","2010-06-01 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4446","700","2010-06-15 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4448","701","2010-05-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4449","701","2010-05-18 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("4450","701","2010-06-01 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4451","701","2010-06-15 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4452","701","2010-06-29 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4453","702","2010-05-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4454","702","2010-05-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4455","702","2010-06-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4456","702","2010-06-15 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4457","702","2010-06-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4458","703","2010-05-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4459","703","2010-05-18 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4460","703","2010-06-01 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4461","703","2010-06-15 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4462","703","2010-06-29 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4464","704","2010-05-04 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4465","704","2010-05-18 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4466","704","2010-06-01 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4467","704","2010-06-15 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4468","704","2010-06-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4469","705","2010-05-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4470","705","2010-05-18 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4471","705","2010-06-01 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4472","705","2010-06-15 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4473","705","2010-06-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4474","706","2010-05-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4475","706","2010-05-18 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4476","706","2010-06-01 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4477","706","2010-06-15 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4478","706","2010-06-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4479","707","2010-05-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4480","707","2010-05-18 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("4481","707","2010-06-01 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4482","707","2010-06-15 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4483","707","2010-06-29 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4484","708","2010-05-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4485","708","2010-05-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4486","708","2010-06-01 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4487","708","2010-06-15 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4488","708","2010-06-29 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4489","709","2010-05-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4490","709","2010-05-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4491","709","2010-06-01 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4492","709","2010-06-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4493","709","2010-06-29 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4494","710","2010-05-04 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4495","710","2010-05-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4496","710","2010-06-01 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4497","710","2010-06-15 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4498","710","2010-06-29 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4499","711","2010-05-03 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4500","711","2010-05-17 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4501","711","2010-06-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4502","711","2010-06-28 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4504","712","2010-05-03 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4505","712","2010-05-10 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4506","712","2010-05-17 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4507","712","2010-05-31 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4508","712","2010-06-07 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4509","712","2010-06-14 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4510","712","2010-06-21 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4511","712","2010-06-28 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4512","713","2010-05-03 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4513","713","2010-05-05 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4514","713","2010-05-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4515","713","2010-05-10 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4516","713","2010-05-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4517","713","2010-05-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4518","713","2010-05-17 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4520","713","2010-05-21 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4521","713","2010-05-26 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4522","713","2010-05-28 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4523","713","2010-05-31 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4524","713","2010-06-02 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4525","713","2010-06-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4526","713","2010-06-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4527","713","2010-06-09 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4528","713","2010-06-11 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4529","713","2010-06-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4531","713","2010-06-18 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4532","713","2010-06-21 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4533","713","2010-06-23 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4534","713","2010-06-25 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4535","713","2010-06-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4536","714","2010-05-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4537","714","2010-05-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4538","714","2010-06-01 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4539","714","2010-06-15 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4540","714","2010-06-29 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4541","715","2010-05-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4542","715","2010-05-18 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4543","715","2010-06-01 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4544","715","2010-06-15 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4545","715","2010-06-29 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4546","716","2010-05-03 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4547","716","2010-05-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4548","716","2010-05-10 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4549","716","2010-05-12 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4550","716","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4551","716","2010-05-17 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4552","716","2010-05-19 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4553","716","2010-05-21 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4554","716","2010-05-26 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4555","716","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4556","716","2010-05-31 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4557","716","2010-06-02 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4558","716","2010-06-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4559","716","2010-06-07 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4560","716","2010-06-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4561","716","2010-06-11 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4562","716","2010-06-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4563","716","2010-06-16 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4564","716","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4565","716","2010-06-21 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4566","716","2010-06-23 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4567","716","2010-06-25 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4568","716","2010-06-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4569","717","2010-05-04 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("4570","717","2010-05-18 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4571","717","2010-06-01 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4572","717","2010-06-15 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4573","717","2010-06-29 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4574","718","2010-05-04 00:00:00","33","3","0","0");
INSERT INTO tr_orderdetails VALUES("4575","718","2010-05-18 00:00:00","64","3","0","0");
INSERT INTO tr_orderdetails VALUES("4576","718","2010-06-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4577","718","2010-06-15 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4578","718","2010-06-29 00:00:00","33","3","0","0");
INSERT INTO tr_orderdetails VALUES("4579","719","2010-05-03 00:00:00","23","1","0","0");
INSERT INTO tr_orderdetails VALUES("4580","719","2010-05-07 00:00:00","71","1","0","0");
INSERT INTO tr_orderdetails VALUES("4581","719","2010-05-10 00:00:00","71","1","0","0");
INSERT INTO tr_orderdetails VALUES("4582","719","2010-05-14 00:00:00","71","1","0","0");
INSERT INTO tr_orderdetails VALUES("4583","719","2010-05-17 00:00:00","71","1","0","0");
INSERT INTO tr_orderdetails VALUES("4584","719","2010-05-28 00:00:00","71","1","0","0");
INSERT INTO tr_orderdetails VALUES("4585","719","2010-05-31 00:00:00","71","1","0","0");
INSERT INTO tr_orderdetails VALUES("4586","719","2010-06-04 00:00:00","71","1","0","0");
INSERT INTO tr_orderdetails VALUES("4587","719","2010-06-07 00:00:00","71","1","0","0");
INSERT INTO tr_orderdetails VALUES("4588","719","2010-06-11 00:00:00","71","1","0","0");
INSERT INTO tr_orderdetails VALUES("4589","719","2010-06-14 00:00:00","71","1","0","0");
INSERT INTO tr_orderdetails VALUES("4590","719","2010-06-18 00:00:00","71","1","0","0");
INSERT INTO tr_orderdetails VALUES("4591","719","2010-06-21 00:00:00","71","1","0","0");
INSERT INTO tr_orderdetails VALUES("4592","719","2010-06-25 00:00:00","71","1","0","0");
INSERT INTO tr_orderdetails VALUES("4593","719","2010-06-28 00:00:00","71","1","0","0");
INSERT INTO tr_orderdetails VALUES("4594","720","2010-05-04 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4595","720","2010-05-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4596","720","2010-06-01 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4597","720","2010-06-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4598","720","2010-06-29 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4599","721","2010-05-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4600","721","2010-05-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4601","721","2010-06-01 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4602","721","2010-06-15 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4603","721","2010-06-29 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4604","722","2010-05-03 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4605","722","2010-05-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4606","722","2010-05-10 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4607","722","2010-05-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4608","722","2010-05-17 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4609","722","2010-05-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4610","722","2010-05-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4611","722","2010-05-31 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4612","722","2010-06-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4613","722","2010-06-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4614","722","2010-06-11 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4615","722","2010-06-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4616","722","2010-06-18 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4617","722","2010-06-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4618","722","2010-06-25 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4619","722","2010-06-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4620","723","2010-05-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4621","723","2010-05-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4622","723","2010-06-01 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4623","723","2010-06-15 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4624","723","2010-06-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4625","724","2010-05-04 00:00:00","33","3","0","0");
INSERT INTO tr_orderdetails VALUES("4626","724","2010-05-18 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4627","724","2010-06-01 00:00:00","33","3","0","0");
INSERT INTO tr_orderdetails VALUES("4628","724","2010-06-15 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4630","725","2010-05-03 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4631","725","2010-05-10 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4632","725","2010-05-17 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4633","725","2010-05-31 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4634","725","2010-06-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4635","725","2010-06-14 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4636","725","2010-06-21 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4637","725","2010-06-28 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4638","726","2010-05-04 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4639","726","2010-05-18 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("4640","726","2010-06-01 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4641","726","2010-06-15 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4642","726","2010-06-29 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4643","727","2010-05-05 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4644","727","2010-05-12 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4645","727","2010-05-19 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4646","727","2010-05-26 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4647","727","2010-06-02 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4648","727","2010-06-09 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4650","727","2010-06-23 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4651","728","2010-05-04 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4652","728","2010-05-18 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4653","728","2010-06-01 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4654","728","2010-06-15 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4655","728","2010-06-29 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("4656","729","2010-05-03 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4657","729","2010-05-10 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4658","729","2010-05-17 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4659","729","2010-05-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4660","729","2010-05-31 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4661","729","2010-06-07 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4662","729","2010-06-14 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4663","729","2010-06-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4664","729","2010-06-28 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4665","730","2010-05-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4666","730","2010-05-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4667","730","2010-06-01 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4668","730","2010-06-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4669","730","2010-06-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4670","731","2010-05-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4671","731","2010-05-18 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4672","731","2010-06-01 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4673","731","2010-06-15 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4674","731","2010-06-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4675","732","2010-05-03 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4676","732","2010-05-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4677","732","2010-05-10 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4678","732","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4679","732","2010-05-17 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4680","732","2010-05-21 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4681","732","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4682","732","2010-05-31 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4683","732","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4684","732","2010-06-07 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4685","732","2010-06-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4686","732","2010-06-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4687","732","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4688","732","2010-06-21 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4689","732","2010-06-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4690","732","2010-06-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4691","733","2010-05-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4692","733","2010-05-18 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4693","733","2010-06-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4694","734","2010-05-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4695","734","2010-05-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4696","734","2010-06-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4697","734","2010-06-15 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4698","734","2010-06-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4699","735","2010-05-03 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4700","735","2010-05-05 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4701","735","2010-05-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4702","735","2010-05-10 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4703","735","2010-05-12 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4704","735","2010-05-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4705","735","2010-05-17 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4706","735","2010-05-19 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4707","735","2010-05-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4708","735","2010-05-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4709","735","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4710","735","2010-05-31 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4711","735","2010-06-02 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4712","735","2010-06-04 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4713","735","2010-06-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4714","735","2010-06-09 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4715","735","2010-06-11 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4716","735","2010-06-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4718","735","2010-06-18 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4719","735","2010-06-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4720","736","2010-05-03 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4721","736","2010-05-10 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4722","736","2010-05-17 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4723","736","2010-05-31 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4724","736","2010-06-07 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4725","736","2010-06-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4726","736","2010-06-21 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4727","737","2010-05-04 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("4728","737","2010-05-18 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4729","737","2010-06-01 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4730","737","2010-06-15 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("4731","737","2010-06-29 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4732","738","2010-05-04 00:00:00","62","3","0","0");
INSERT INTO tr_orderdetails VALUES("4733","738","2010-05-18 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("4734","738","2010-06-01 00:00:00","64","3","0","0");
INSERT INTO tr_orderdetails VALUES("4735","738","2010-06-15 00:00:00","65","3","0","0");
INSERT INTO tr_orderdetails VALUES("4736","738","2010-06-29 00:00:00","2","3","0","0");
INSERT INTO tr_orderdetails VALUES("4737","739","2010-05-07 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4738","739","2010-05-14 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4739","739","2010-05-21 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4740","739","2010-05-28 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4741","739","2010-05-31 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4742","739","2010-06-02 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4743","739","2010-06-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4744","739","2010-06-09 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4745","739","2010-06-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4746","739","2010-06-16 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4747","739","2010-06-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4748","739","2010-06-23 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4749","739","2010-06-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4750","740","2010-05-03 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4751","740","2010-05-05 00:00:00","68","1","0","0");
INSERT INTO tr_orderdetails VALUES("4752","740","2010-05-07 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4753","740","2010-05-10 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4754","740","2010-05-12 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4755","740","2010-05-14 00:00:00","69","1","0","0");
INSERT INTO tr_orderdetails VALUES("4756","740","2010-05-17 00:00:00","68","1","0","0");
INSERT INTO tr_orderdetails VALUES("4757","740","2010-05-19 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4758","740","2010-05-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4759","740","2010-05-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4760","740","2010-05-28 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4761","740","2010-05-31 00:00:00","69","1","0","0");
INSERT INTO tr_orderdetails VALUES("4762","740","2010-06-02 00:00:00","68","1","0","0");
INSERT INTO tr_orderdetails VALUES("4763","740","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4764","740","2010-06-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4765","740","2010-06-09 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4766","740","2010-06-11 00:00:00","69","1","0","0");
INSERT INTO tr_orderdetails VALUES("4767","740","2010-06-14 00:00:00","68","1","0","0");
INSERT INTO tr_orderdetails VALUES("4768","740","2010-06-16 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4769","740","2010-06-18 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4770","740","2010-06-21 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4771","740","2010-06-23 00:00:00","68","1","0","0");
INSERT INTO tr_orderdetails VALUES("4772","740","2010-06-25 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("4773","740","2010-06-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4774","741","2010-05-03 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("4775","741","2010-05-05 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4776","741","2010-05-07 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4777","741","2010-05-10 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4778","741","2010-05-12 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4779","741","2010-05-14 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4780","741","2010-05-17 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4781","741","2010-05-19 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4782","741","2010-05-21 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4784","741","2010-05-28 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4785","741","2010-05-31 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4786","741","2010-06-02 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4787","741","2010-06-04 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4788","741","2010-06-07 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("4789","741","2010-06-09 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4790","741","2010-06-11 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4791","741","2010-06-14 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4792","741","2010-06-16 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4793","741","2010-06-18 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4794","741","2010-06-21 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4795","741","2010-06-23 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4796","741","2010-06-25 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4797","741","2010-06-28 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4798","742","2010-05-07 00:00:00","65","4","0","0");
INSERT INTO tr_orderdetails VALUES("4799","743","2010-05-05 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4800","743","2010-05-12 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4801","743","2010-05-19 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4802","743","2010-05-26 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4803","743","2010-06-02 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4804","743","2010-06-09 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4806","743","2010-06-23 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4807","744","2010-05-03 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4808","744","2010-05-05 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4809","744","2010-05-07 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4810","744","2010-05-10 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4811","744","2010-05-12 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4812","744","2010-05-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4813","744","2010-05-17 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4814","744","2010-05-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4815","744","2010-05-21 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4816","744","2010-05-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4817","744","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4818","744","2010-05-31 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4819","744","2010-06-02 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4820","744","2010-06-04 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4821","744","2010-06-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4822","744","2010-06-09 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4823","744","2010-06-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4824","744","2010-06-14 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4826","744","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4827","744","2010-06-21 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4828","744","2010-06-23 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4829","744","2010-06-25 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4830","744","2010-06-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4831","745","2010-05-05 00:00:00","2","4","0","0");
INSERT INTO tr_orderdetails VALUES("4832","745","2010-05-17 00:00:00","62","4","0","0");
INSERT INTO tr_orderdetails VALUES("4833","746","2010-05-03 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4834","746","2010-05-05 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4835","746","2010-05-07 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4836","746","2010-05-10 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4837","746","2010-05-12 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4838","746","2010-05-14 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4839","746","2010-05-17 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4840","746","2010-05-19 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4841","746","2010-05-21 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4842","746","2010-05-26 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4843","746","2010-05-28 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4844","746","2010-05-31 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4845","746","2010-06-02 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4846","746","2010-06-04 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4847","746","2010-06-07 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4848","746","2010-06-09 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4849","746","2010-06-11 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4850","746","2010-06-14 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4851","746","2010-06-16 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4852","746","2010-06-18 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4853","746","2010-06-21 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4854","746","2010-06-23 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4855","746","2010-06-25 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4856","746","2010-06-28 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4857","747","2010-05-03 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4858","747","2010-05-07 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4859","747","2010-05-10 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4860","747","2010-05-14 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4861","747","2010-05-17 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4862","747","2010-05-21 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4863","747","2010-05-28 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4864","747","2010-05-31 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4865","747","2010-06-04 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4866","747","2010-06-07 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4867","747","2010-06-11 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4868","747","2010-06-14 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4869","747","2010-06-18 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4870","747","2010-06-21 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4871","747","2010-06-25 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4872","747","2010-06-28 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4873","748","2010-05-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4874","748","2010-05-14 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4875","748","2010-05-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4876","748","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4878","748","2010-06-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4879","748","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4880","748","2010-06-25 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4881","749","2010-05-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4882","749","2010-05-14 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4883","749","2010-05-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4884","749","2010-05-28 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4885","749","2010-06-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4886","749","2010-06-11 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4887","749","2010-06-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4888","749","2010-06-25 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4889","750","2010-05-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4890","750","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4891","750","2010-05-20 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4892","750","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4893","750","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4894","750","2010-06-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4895","750","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4896","750","2010-06-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4897","751","2010-05-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4898","751","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4899","751","2010-05-20 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4900","751","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4901","751","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4902","751","2010-06-11 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4903","751","2010-06-18 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4904","751","2010-06-25 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4905","752","2010-05-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4906","752","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4907","752","2010-05-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4908","752","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4909","752","2010-06-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4910","752","2010-06-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4911","752","2010-06-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4912","752","2010-06-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4913","753","2010-05-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4914","753","2010-05-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4915","753","2010-05-20 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4916","753","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4917","753","2010-06-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4918","753","2010-06-11 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4919","753","2010-06-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4920","753","2010-06-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4921","754","2010-05-07 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4922","754","2010-05-14 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4923","754","2010-05-20 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4924","754","2010-05-28 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4925","754","2010-06-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4926","754","2010-06-11 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4927","754","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4928","754","2010-06-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4929","755","2010-05-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4930","755","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4931","755","2010-05-20 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4932","755","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4933","755","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4934","755","2010-06-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4935","755","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4936","755","2010-06-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4937","756","2010-05-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4938","756","2010-05-14 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4939","756","2010-05-20 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4940","756","2010-05-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4941","756","2010-06-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4942","756","2010-06-11 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4943","756","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4944","756","2010-06-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4945","757","2010-05-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4946","757","2010-05-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4947","757","2010-05-20 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4948","757","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4949","757","2010-06-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4950","757","2010-06-18 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4951","757","2010-06-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4952","758","2010-05-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4953","758","2010-05-14 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4954","758","2010-05-20 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4955","758","2010-05-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4956","758","2010-06-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4957","758","2010-06-11 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4958","758","2010-06-18 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("4959","758","2010-06-25 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4960","759","2010-05-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4961","759","2010-05-14 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("4962","759","2010-05-20 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("4963","759","2010-05-28 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4964","759","2010-06-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("4965","759","2010-06-11 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("4966","759","2010-06-18 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("4967","759","2010-06-25 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("4968","760","2010-05-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4969","760","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4970","760","2010-06-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4971","760","2010-06-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4972","761","2010-05-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4973","761","2010-05-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("4974","761","2010-05-20 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4975","761","2010-05-28 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4976","761","2010-06-04 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4977","761","2010-06-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4978","761","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4979","761","2010-06-25 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("4980","762","2010-05-07 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4981","762","2010-05-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4982","762","2010-05-20 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4983","762","2010-05-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4984","762","2010-06-04 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4985","762","2010-06-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4986","762","2010-06-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("4987","762","2010-06-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4988","763","2010-05-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4989","763","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4990","763","2010-05-20 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4991","763","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4992","763","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4993","763","2010-06-11 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4994","763","2010-06-18 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4995","763","2010-06-25 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("4996","764","2010-05-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("4997","764","2010-05-14 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("4998","764","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("4999","764","2010-06-18 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5000","764","2010-06-25 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("5001","765","2010-05-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5002","765","2010-05-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5003","765","2010-05-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5004","765","2010-05-28 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5005","765","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5006","765","2010-06-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5007","765","2010-06-18 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5008","765","2010-06-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5009","766","2010-05-07 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5010","766","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5011","766","2010-05-20 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5012","766","2010-05-28 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5013","766","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5014","766","2010-06-11 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5015","766","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5016","766","2010-06-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5017","767","2010-05-07 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5018","767","2010-05-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5019","767","2010-05-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5020","767","2010-05-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5021","767","2010-06-04 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5022","767","2010-06-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5023","767","2010-06-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5024","767","2010-06-25 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5025","768","2010-05-07 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5026","768","2010-05-14 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5027","768","2010-05-20 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5028","768","2010-05-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5029","768","2010-06-04 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5030","768","2010-06-11 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5031","768","2010-06-18 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5032","768","2010-06-25 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5033","769","2010-05-07 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5034","769","2010-05-14 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5035","769","2010-05-20 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5036","769","2010-05-28 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5037","769","2010-06-04 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5038","769","2010-06-11 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5039","769","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5040","769","2010-06-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5041","770","2010-05-07 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5042","770","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5043","770","2010-05-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5044","770","2010-05-28 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5045","770","2010-06-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5046","770","2010-06-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5047","770","2010-06-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5048","770","2010-06-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5049","771","2010-05-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5050","771","2010-05-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5051","771","2010-05-20 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5052","771","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5053","771","2010-06-04 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5054","771","2010-06-11 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5055","771","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5056","771","2010-06-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5057","772","2010-05-07 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5058","772","2010-05-14 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5059","772","2010-05-20 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5060","772","2010-05-28 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("5061","772","2010-06-04 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5062","772","2010-06-11 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5063","772","2010-06-18 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5064","772","2010-06-25 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5065","773","2010-05-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5066","773","2010-05-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5067","773","2010-05-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5068","773","2010-05-28 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5069","773","2010-06-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5070","773","2010-06-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5071","773","2010-06-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5072","773","2010-06-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5073","774","2010-05-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5074","774","2010-05-14 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5075","774","2010-05-20 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5076","774","2010-05-28 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5077","774","2010-06-04 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5078","774","2010-06-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5079","774","2010-06-18 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5080","774","2010-06-25 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5081","775","2010-05-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5082","775","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5083","775","2010-05-20 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5084","775","2010-05-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5085","775","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5086","775","2010-06-11 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5087","775","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5088","775","2010-06-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5089","776","2010-05-07 00:00:00","70","1","0","0");
INSERT INTO tr_orderdetails VALUES("5090","776","2010-05-14 00:00:00","70","1","0","0");
INSERT INTO tr_orderdetails VALUES("5091","776","2010-05-20 00:00:00","70","1","0","0");
INSERT INTO tr_orderdetails VALUES("5092","776","2010-05-28 00:00:00","70","1","0","0");
INSERT INTO tr_orderdetails VALUES("5093","776","2010-06-04 00:00:00","70","1","0","0");
INSERT INTO tr_orderdetails VALUES("5094","776","2010-06-11 00:00:00","70","1","0","0");
INSERT INTO tr_orderdetails VALUES("5095","776","2010-06-18 00:00:00","70","1","0","0");
INSERT INTO tr_orderdetails VALUES("5096","776","2010-06-25 00:00:00","70","1","0","0");
INSERT INTO tr_orderdetails VALUES("5097","777","2010-05-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5098","778","2010-05-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5099","778","2010-05-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5100","778","2010-05-20 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5101","778","2010-05-28 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5102","778","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5103","778","2010-06-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5104","778","2010-06-18 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5105","778","2010-06-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5106","779","2010-05-07 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5107","779","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5108","779","2010-05-20 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5109","779","2010-05-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5110","779","2010-06-04 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5111","779","2010-06-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5112","779","2010-06-18 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5113","779","2010-06-25 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5114","780","2010-05-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5115","780","2010-05-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5116","780","2010-05-20 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5117","780","2010-05-28 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5118","780","2010-06-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5119","780","2010-06-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5120","780","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5121","780","2010-06-25 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5122","781","2010-05-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5123","781","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5124","781","2010-05-20 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("5125","781","2010-05-28 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("5126","781","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5127","781","2010-06-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5128","781","2010-06-18 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("5129","781","2010-06-25 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("5130","782","2010-05-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5131","782","2010-05-14 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5132","782","2010-05-20 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5133","782","2010-05-28 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5134","782","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5135","782","2010-06-11 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5136","782","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5137","782","2010-06-25 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5138","783","2010-05-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5139","783","2010-05-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5140","783","2010-05-20 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5141","783","2010-05-28 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5142","783","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5143","783","2010-06-11 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5144","783","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5145","783","2010-06-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5146","784","2010-05-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5147","784","2010-05-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5148","784","2010-05-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5149","784","2010-05-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5150","784","2010-06-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5151","784","2010-06-11 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5152","784","2010-06-18 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5153","784","2010-06-25 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5154","785","2010-05-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5155","785","2010-05-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5156","785","2010-05-20 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5157","785","2010-05-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5158","785","2010-06-04 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5159","785","2010-06-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5160","785","2010-06-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5161","785","2010-06-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5162","786","2010-05-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5163","786","2010-05-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5164","786","2010-05-20 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5165","786","2010-05-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5167","786","2010-06-11 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5168","786","2010-06-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5169","786","2010-06-25 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5170","787","2010-05-07 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5171","787","2010-05-14 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5172","787","2010-05-28 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5174","787","2010-06-11 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5175","787","2010-06-18 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5176","787","2010-06-25 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5177","788","2010-05-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5178","788","2010-05-14 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5179","788","2010-05-20 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5180","788","2010-05-28 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5182","788","2010-06-11 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5183","788","2010-06-18 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5184","788","2010-06-25 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5185","789","2010-05-07 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5186","789","2010-05-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5187","789","2010-05-20 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5188","789","2010-05-28 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5190","789","2010-06-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5191","789","2010-06-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5192","789","2010-06-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5193","790","2010-05-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5194","790","2010-05-14 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5195","790","2010-05-20 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5196","790","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5198","790","2010-06-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5199","790","2010-06-18 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5200","790","2010-06-25 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5202","791","2010-05-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5203","791","2010-05-14 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5204","791","2010-05-28 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("5206","791","2010-06-11 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5207","791","2010-06-18 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5208","791","2010-06-25 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5209","792","2010-05-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5210","792","2010-05-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5211","792","2010-05-20 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5212","792","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5214","792","2010-06-11 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5215","792","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5216","792","2010-06-25 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5217","793","2010-05-07 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5218","793","2010-05-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5220","793","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5221","793","2010-06-25 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5222","794","2010-05-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5223","794","2010-05-14 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5224","794","2010-05-20 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5225","794","2010-05-28 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5227","794","2010-06-11 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5228","794","2010-06-18 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5229","794","2010-06-25 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5230","795","2010-05-07 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5231","795","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5232","795","2010-05-20 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5233","795","2010-05-28 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5235","795","2010-06-11 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5236","795","2010-06-18 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5237","795","2010-06-25 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5238","796","2010-05-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5246","797","2010-05-07 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5247","797","2010-06-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5248","797","2010-05-20 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5249","797","2010-05-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5250","797","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5251","797","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5252","797","2010-06-18 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5253","797","2010-06-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5254","798","2010-05-07 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5255","798","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5256","798","2010-05-20 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5257","798","2010-05-28 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5258","798","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5259","798","2010-06-11 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5260","798","2010-06-18 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5261","798","2010-06-25 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5262","799","2010-05-07 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5264","800","2010-05-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5265","800","2010-05-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5266","800","2010-05-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5267","800","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5268","800","2010-06-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5269","800","2010-06-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5270","800","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5271","800","2010-06-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5272","801","2010-05-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5273","801","2010-05-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5274","801","2010-06-04 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5275","801","2010-06-18 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5276","802","2010-05-07 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5277","802","2010-05-14 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5278","802","2010-05-20 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5279","802","2010-05-28 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5280","802","2010-06-04 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5281","802","2010-06-11 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("5282","802","2010-06-18 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5283","802","2010-06-25 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5284","803","2010-05-07 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5285","803","2010-05-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5286","803","2010-05-20 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5287","803","2010-05-28 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5288","803","2010-06-04 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5289","803","2010-06-11 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("5290","803","2010-06-18 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5291","803","2010-06-25 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5292","804","2010-05-07 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5293","804","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5294","804","2010-05-20 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5295","804","2010-05-28 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5296","804","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5297","804","2010-06-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5298","804","2010-06-18 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5299","804","2010-06-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5300","805","2010-05-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5301","805","2010-05-20 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("5302","805","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5303","805","2010-06-18 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5304","805","2010-06-25 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5305","806","2010-05-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5306","806","2010-05-14 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5307","806","2010-05-20 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("5308","806","2010-05-28 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5309","806","2010-06-04 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5310","806","2010-06-11 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5311","806","2010-06-18 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5312","806","2010-06-25 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5313","807","2010-05-07 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5314","807","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5315","807","2010-05-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5316","807","2010-05-28 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5317","807","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5318","807","2010-06-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5319","807","2010-06-18 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5320","807","2010-06-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5321","808","2010-05-07 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5322","808","2010-05-14 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5323","808","2010-05-20 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5324","808","2010-05-28 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5325","808","2010-06-04 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5326","808","2010-06-11 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5327","808","2010-06-18 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5328","808","2010-06-25 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5329","809","2010-05-07 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5330","809","2010-05-14 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5331","809","2010-05-20 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5332","809","2010-05-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5333","809","2010-06-04 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5334","809","2010-06-11 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5335","809","2010-06-18 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5336","809","2010-06-25 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5337","810","2010-05-07 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("5338","810","2010-05-14 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5339","810","2010-05-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5340","810","2010-05-28 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("5341","810","2010-06-11 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5342","811","2010-05-03 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5343","811","2010-05-10 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5344","811","2010-05-17 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("5345","811","2010-05-31 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5346","811","2010-06-07 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5347","811","2010-06-14 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5348","811","2010-06-21 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5349","811","2010-06-28 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5350","812","2010-05-05 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5351","812","2010-05-31 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5352","813","2010-05-04 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5353","813","2010-05-18 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5354","813","2010-06-01 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5355","813","2010-06-15 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5356","813","2010-06-29 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5357","814","2010-05-04 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5358","814","2010-05-18 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("5359","814","2010-06-01 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5360","814","2010-06-15 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5361","814","2010-06-29 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("5362","815","2010-05-04 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5363","815","2010-05-18 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5364","815","2010-06-01 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5365","815","2010-06-15 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5366","815","2010-06-29 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5367","816","2010-05-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5368","816","2010-05-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5369","816","2010-06-01 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5370","816","2010-06-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5371","816","2010-06-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5372","817","2010-06-16 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5373","817","2010-06-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5374","818","2010-05-04 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5375","818","2010-05-18 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5376","818","2010-06-01 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5377","818","2010-06-15 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("5378","818","2010-06-29 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5379","819","2010-05-04 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5380","819","2010-05-18 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5381","819","2010-06-01 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5382","819","2010-06-15 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5383","819","2010-06-29 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5384","820","2010-05-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5385","820","2010-05-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5386","820","2010-05-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5387","820","2010-05-28 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5388","820","2010-06-04 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5389","820","2010-06-11 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5390","820","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5391","820","2010-06-25 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5392","821","2010-05-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5393","821","2010-05-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5394","821","2010-05-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5395","821","2010-05-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5396","821","2010-06-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5397","821","2010-06-11 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5398","821","2010-06-18 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5399","821","2010-06-25 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5400","822","2010-05-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5401","822","2010-05-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5402","822","2010-05-20 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5403","822","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5404","822","2010-06-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5405","822","2010-06-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5406","822","2010-06-18 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5407","822","2010-06-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5408","823","2010-05-03 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5409","823","2010-05-10 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5410","823","2010-05-17 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5411","823","2010-05-31 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5412","823","2010-06-07 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5413","823","2010-06-14 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5414","824","2010-05-07 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5415","824","2010-05-14 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5416","824","2010-05-20 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5417","824","2010-05-28 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5418","824","2010-06-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5419","824","2010-06-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5420","824","2010-06-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5421","824","2010-06-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5422","825","2010-05-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5423","825","2010-05-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5424","825","2010-05-20 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5425","825","2010-05-28 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5426","825","2010-06-04 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5427","825","2010-06-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5428","825","2010-06-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5429","825","2010-06-25 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5430","826","2010-05-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5431","826","2010-05-14 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5432","826","2010-05-20 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5433","826","2010-05-28 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5434","826","2010-06-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5435","826","2010-06-11 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5436","826","2010-06-18 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5437","826","2010-06-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5438","827","2010-05-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5439","827","2010-05-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5440","827","2010-05-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5441","827","2010-05-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5443","827","2010-06-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5444","827","2010-06-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5445","827","2010-06-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5446","828","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5447","828","2010-06-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5448","829","2010-05-07 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5449","829","2010-05-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5450","829","2010-05-20 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5451","829","2010-05-28 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5452","829","2010-06-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5453","829","2010-06-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5454","829","2010-06-18 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5455","829","2010-06-25 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5456","830","2010-05-07 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5457","830","2010-05-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5458","830","2010-05-20 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5459","830","2010-05-28 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5460","830","2010-06-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5461","830","2010-06-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5462","830","2010-06-18 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5463","830","2010-06-25 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5464","831","2010-05-07 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5465","831","2010-05-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5466","831","2010-05-20 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5467","831","2010-05-28 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5468","831","2010-06-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5469","831","2010-06-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5470","831","2010-06-18 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5471","831","2010-06-25 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5472","832","2010-05-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5473","832","2010-05-14 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("5474","832","2010-05-20 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5475","832","2010-05-28 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5476","832","2010-06-04 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5477","832","2010-06-11 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5478","832","2010-06-18 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5479","832","2010-06-25 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5480","833","2010-05-07 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5481","833","2010-05-14 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5482","833","2010-05-20 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5483","833","2010-05-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5484","833","2010-06-11 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5485","833","2010-06-18 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5486","833","2010-06-25 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5487","834","2010-05-07 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5488","834","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5489","834","2010-05-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5490","834","2010-05-28 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5491","834","2010-06-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5492","834","2010-06-11 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5493","834","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5494","834","2010-06-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5495","835","2010-05-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5496","835","2010-05-14 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("5497","835","2010-05-20 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5498","835","2010-05-28 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5499","835","2010-06-04 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5500","835","2010-06-11 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5501","835","2010-06-18 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5502","835","2010-06-25 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5503","836","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5504","836","2010-05-28 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5505","836","2010-06-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5506","836","2010-06-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5507","837","2010-05-07 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5508","837","2010-05-14 00:00:00","71","1","0","0");
INSERT INTO tr_orderdetails VALUES("5509","837","2010-05-20 00:00:00","71","1","0","0");
INSERT INTO tr_orderdetails VALUES("5510","837","2010-05-28 00:00:00","71","1","0","0");
INSERT INTO tr_orderdetails VALUES("5511","837","2010-06-04 00:00:00","71","1","0","0");
INSERT INTO tr_orderdetails VALUES("5512","837","2010-06-11 00:00:00","71","1","0","0");
INSERT INTO tr_orderdetails VALUES("5513","837","2010-06-18 00:00:00","71","1","0","0");
INSERT INTO tr_orderdetails VALUES("5514","837","2010-06-25 00:00:00","71","1","0","0");
INSERT INTO tr_orderdetails VALUES("5515","838","2010-05-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5516","838","2010-05-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5517","838","2010-05-20 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5518","838","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5519","838","2010-06-04 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5520","838","2010-06-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5521","838","2010-06-18 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5522","838","2010-06-25 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5523","839","2010-05-04 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("5524","839","2010-05-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5525","839","2010-06-01 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("5526","839","2010-06-15 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5527","839","2010-06-29 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("5528","840","2010-05-06 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5529","841","2010-05-06 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5530","842","2010-05-14 00:00:00","70","1","0","0");
INSERT INTO tr_orderdetails VALUES("5531","843","2010-05-18 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("5532","843","2010-06-15 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("5533","843","2010-06-29 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5534","844","2010-05-12 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5535","845","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5536","845","2010-05-20 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5537","845","2010-05-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5538","845","2010-06-04 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5539","845","2010-06-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5540","845","2010-06-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5541","845","2010-06-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5542","846","2010-05-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5543","846","2010-06-01 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5544","846","2010-06-15 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5545","846","2010-06-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5546","847","2010-05-18 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5547","847","2010-06-01 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5548","847","2010-06-15 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5549","847","2010-06-29 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5551","848","2010-05-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5552","848","2010-06-01 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5553","848","2010-06-15 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5554","848","2010-06-29 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5555","849","2010-05-21 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5556","849","2010-06-07 00:00:00","65","5","0","0");
INSERT INTO tr_orderdetails VALUES("5557","850","2010-05-21 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5558","850","2010-06-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5559","851","2010-05-14 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5560","851","2010-05-21 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5562","851","2010-06-22 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5563","852","2010-05-14 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5564","852","2010-06-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5565","853","2010-05-14 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5566","853","2010-06-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5567","854","2010-05-14 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5568","854","2010-06-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5569","855","2010-05-14 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5570","855","2010-06-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5571","856","2010-05-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5572","856","2010-06-07 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5573","857","2010-05-21 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5574","857","2010-06-07 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5575","858","2010-05-21 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5576","858","2010-06-07 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5577","859","2010-05-21 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5578","859","2010-06-07 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5579","860","2010-05-14 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5580","860","2010-06-22 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5581","861","2010-05-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5582","861","2010-06-22 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5583","862","2010-05-14 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5584","862","2010-06-22 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5585","863","2010-05-14 00:00:00","72","1","0","0");
INSERT INTO tr_orderdetails VALUES("5586","863","2010-06-22 00:00:00","26","1","0","0");
INSERT INTO tr_orderdetails VALUES("5587","864","2010-05-14 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5588","864","2010-06-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5589","865","2010-05-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5590","865","2010-05-21 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5592","865","2010-06-22 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5593","866","2010-05-21 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5594","866","2010-06-07 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5596","867","2010-05-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5597","868","2010-05-21 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5598","868","2010-06-22 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5599","869","2010-05-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5600","869","2010-05-21 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5601","869","2010-06-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5602","869","2010-06-22 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5603","870","2010-05-14 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5604","870","2010-05-21 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5605","870","2010-06-07 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5606","870","2010-06-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5607","871","2010-05-14 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5608","872","2010-05-14 00:00:00","26","1","0","0");
INSERT INTO tr_orderdetails VALUES("5609","872","2010-05-21 00:00:00","25","1","0","0");
INSERT INTO tr_orderdetails VALUES("5610","872","2010-06-07 00:00:00","73","1","0","0");
INSERT INTO tr_orderdetails VALUES("5611","872","2010-06-22 00:00:00","26","1","0","0");
INSERT INTO tr_orderdetails VALUES("5612","873","2010-05-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5613","874","2010-05-14 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5614","874","2010-05-21 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5615","874","2010-06-07 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5616","874","2010-06-22 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5617","875","2010-05-14 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5618","875","2010-05-21 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5619","875","2010-06-07 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5620","875","2010-06-22 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5621","876","2010-05-14 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5622","876","2010-05-21 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5623","876","2010-06-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5624","876","2010-06-22 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5626","877","2010-05-21 00:00:00","33","6","0","0");
INSERT INTO tr_orderdetails VALUES("5628","878","2010-05-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5629","878","2010-05-21 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5630","878","2010-06-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5631","878","2010-06-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5632","879","2010-05-14 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5633","880","2010-05-14 00:00:00","2","3","0","0");
INSERT INTO tr_orderdetails VALUES("5634","880","2010-05-21 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("5635","880","2010-06-07 00:00:00","64","3","0","0");
INSERT INTO tr_orderdetails VALUES("5636","880","2010-06-22 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("5637","881","2010-05-14 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5638","881","2010-05-21 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5639","881","2010-06-07 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5640","881","2010-06-22 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5641","882","2010-05-14 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5642","882","2010-05-21 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5643","882","2010-06-07 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5644","882","2010-06-22 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5645","883","2010-05-14 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5646","884","2010-05-14 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5647","885","2010-05-14 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5648","885","2010-05-21 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5649","885","2010-06-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5650","885","2010-06-22 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5651","886","2010-05-21 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("5652","886","2010-06-07 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("5653","886","2010-06-22 00:00:00","62","2","0","0");
INSERT INTO tr_orderdetails VALUES("5654","887","2010-05-14 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5655","887","2010-05-21 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5656","887","2010-06-07 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5657","887","2010-06-22 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5658","888","2010-05-14 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5659","888","2010-05-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5660","889","2010-05-14 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5661","889","2010-05-21 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5662","889","2010-06-07 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5663","889","2010-06-22 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5664","890","2010-05-14 00:00:00","2","3","0","0");
INSERT INTO tr_orderdetails VALUES("5665","890","2010-05-21 00:00:00","63","3","0","0");
INSERT INTO tr_orderdetails VALUES("5666","890","2010-06-07 00:00:00","33","3","0","0");
INSERT INTO tr_orderdetails VALUES("5667","890","2010-06-22 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("5668","891","2010-05-14 00:00:00","2","3","0","0");
INSERT INTO tr_orderdetails VALUES("5669","891","2010-05-21 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("5670","891","2010-06-07 00:00:00","2","3","0","0");
INSERT INTO tr_orderdetails VALUES("5671","891","2010-06-22 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("5672","892","2010-05-14 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5673","892","2010-05-21 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5674","893","2010-05-14 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5675","893","2010-05-21 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5676","893","2010-06-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5677","893","2010-06-22 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5678","894","2010-05-21 00:00:00","33","6","0","0");
INSERT INTO tr_orderdetails VALUES("5680","895","2010-05-14 00:00:00","65","3","0","0");
INSERT INTO tr_orderdetails VALUES("5681","895","2010-05-21 00:00:00","65","3","0","0");
INSERT INTO tr_orderdetails VALUES("5682","895","2010-06-07 00:00:00","65","3","0","0");
INSERT INTO tr_orderdetails VALUES("5683","896","2010-05-14 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5684","896","2010-05-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5685","896","2010-06-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5686","896","2010-06-22 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5687","897","2010-05-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5688","897","2010-05-21 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5689","897","2010-06-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5690","897","2010-06-22 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5691","898","2010-05-14 00:00:00","74","1","0","0");
INSERT INTO tr_orderdetails VALUES("5692","898","2010-05-21 00:00:00","74","1","0","0");
INSERT INTO tr_orderdetails VALUES("5693","898","2010-06-07 00:00:00","73","1","0","0");
INSERT INTO tr_orderdetails VALUES("5694","898","2010-06-22 00:00:00","74","1","0","0");
INSERT INTO tr_orderdetails VALUES("5695","899","2010-05-14 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("5696","899","2010-05-21 00:00:00","65","3","0","0");
INSERT INTO tr_orderdetails VALUES("5697","899","2010-06-07 00:00:00","63","3","0","0");
INSERT INTO tr_orderdetails VALUES("5698","899","2010-06-22 00:00:00","65","3","0","0");
INSERT INTO tr_orderdetails VALUES("5699","900","2010-05-14 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5700","900","2010-05-21 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5703","901","2010-05-14 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5704","901","2010-05-20 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5705","901","2010-05-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5706","901","2010-06-04 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5707","901","2010-06-11 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("5708","901","2010-06-18 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5709","901","2010-06-25 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5710","902","2010-05-14 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5711","902","2010-06-22 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5712","903","2010-05-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5713","904","2010-05-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5714","904","2010-05-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5715","904","2010-06-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5716","904","2010-06-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5717","905","2010-05-14 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5718","905","2010-05-21 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5719","905","2010-06-07 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5720","905","2010-06-22 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5721","906","2010-05-21 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5722","906","2010-06-07 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5723","907","2010-05-14 00:00:00","64","4","0","0");
INSERT INTO tr_orderdetails VALUES("5724","907","2010-05-21 00:00:00","5","4","0","0");
INSERT INTO tr_orderdetails VALUES("5725","907","2010-06-07 00:00:00","65","4","0","0");
INSERT INTO tr_orderdetails VALUES("5726","907","2010-06-22 00:00:00","2","4","0","0");
INSERT INTO tr_orderdetails VALUES("5727","908","2010-05-14 00:00:00","64","4","0","0");
INSERT INTO tr_orderdetails VALUES("5728","908","2010-05-21 00:00:00","65","4","0","0");
INSERT INTO tr_orderdetails VALUES("5729","908","2010-06-07 00:00:00","5","4","0","0");
INSERT INTO tr_orderdetails VALUES("5730","908","2010-06-22 00:00:00","2","4","0","0");
INSERT INTO tr_orderdetails VALUES("5731","909","2010-05-14 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5732","909","2010-05-21 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5733","909","2010-06-07 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5734","909","2010-06-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5735","910","2010-05-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5736","910","2010-05-21 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5737","910","2010-06-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5738","910","2010-06-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5739","911","2010-05-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5740","911","2010-05-21 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5741","912","2010-05-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5742","912","2010-05-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5743","913","2010-05-14 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5744","913","2010-05-21 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5745","913","2010-06-07 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5746","913","2010-06-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5747","914","2010-05-14 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5748","914","2010-05-21 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5749","914","2010-06-07 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5750","914","2010-06-22 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5751","915","2010-05-14 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5752","915","2010-05-21 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5753","915","2010-06-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5754","915","2010-06-22 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5755","916","2010-05-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5756","916","2010-05-21 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5757","917","2010-05-14 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5758","917","2010-06-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5759","918","2010-05-14 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5760","918","2010-05-21 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5761","918","2010-06-07 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5762","918","2010-06-22 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5763","919","2010-05-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5764","920","2010-05-14 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5765","920","2010-05-21 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5766","920","2010-06-07 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5767","920","2010-06-22 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5768","921","2010-05-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5769","921","2010-05-21 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5770","921","2010-06-07 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5771","921","2010-06-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5772","922","2010-05-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5773","923","2010-05-14 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("5774","923","2010-05-21 00:00:00","62","1","0","0");
INSERT INTO tr_orderdetails VALUES("5775","924","2010-05-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5776","924","2010-05-21 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5777","924","2010-06-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5778","924","2010-06-22 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5779","925","2010-05-14 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5780","926","2010-05-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5781","926","2010-05-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5782","926","2010-06-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5783","926","2010-06-22 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5784","927","2010-05-14 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5785","927","2010-05-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5786","927","2010-06-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5787","927","2010-06-22 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5788","928","2010-05-14 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5789","928","2010-05-21 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5790","928","2010-06-07 00:00:00","65","2","0","0");
INSERT INTO tr_orderdetails VALUES("5791","928","2010-06-22 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5792","929","2010-05-14 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5793","929","2010-05-21 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5794","929","2010-06-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5795","929","2010-06-22 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5796","930","2010-05-19 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5797","930","2010-05-28 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5798","930","2010-05-31 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5799","930","2010-06-02 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5800","930","2010-06-07 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5801","930","2010-06-09 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5802","930","2010-06-14 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5803","930","2010-06-16 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5804","930","2010-06-21 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5805","930","2010-06-23 00:00:00","65","1","0","0");
INSERT INTO tr_orderdetails VALUES("5806","930","2010-06-28 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5807","931","2010-05-21 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5808","931","2010-06-07 00:00:00","64","5","0","0");
INSERT INTO tr_orderdetails VALUES("5809","931","2010-06-22 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5811","932","2010-06-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5812","932","2010-06-22 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("5813","933","2010-05-21 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5814","934","2010-05-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5815","934","2010-06-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5816","935","2010-05-28 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5818","935","2010-06-11 00:00:00","63","1","0","0");
INSERT INTO tr_orderdetails VALUES("5819","935","2010-06-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("5820","935","2010-06-25 00:00:00","70","1","0","0");
INSERT INTO tr_orderdetails VALUES("5821","936","2010-06-07 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5822","936","2010-06-14 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5823","936","2010-06-21 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("5824","937","2010-06-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5825","938","2010-06-07 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5826","939","2010-06-11 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5827","940","2010-06-11 00:00:00","63","2","0","0");
INSERT INTO tr_orderdetails VALUES("5828","940","2010-06-18 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("5829","940","2010-06-25 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("5830","941","2010-06-11 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("5831","942","2010-09-14 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("5832","943","2010-09-29 00:00:00","4","2","13","75");
INSERT INTO tr_orderdetails VALUES("5833","943","2010-10-13 00:00:00","11","2","12","76");
INSERT INTO tr_orderdetails VALUES("5834","943","2010-10-27 00:00:00","1","2","13","77");
INSERT INTO tr_orderdetails VALUES("5835","944","2010-09-29 00:00:00","5","2","13","77");
INSERT INTO tr_orderdetails VALUES("5836","944","2010-10-13 00:00:00","4","2","14","75");
INSERT INTO tr_orderdetails VALUES("5837","944","2010-10-27 00:00:00","5","2","13","77");
INSERT INTO tr_orderdetails VALUES("5838","945","2010-09-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5839","945","2010-10-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5840","945","2010-10-27 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5841","946","2010-09-29 00:00:00","1","2","20","75");
INSERT INTO tr_orderdetails VALUES("5842","946","2010-10-13 00:00:00","2","2","13","75");
INSERT INTO tr_orderdetails VALUES("5843","946","2010-10-27 00:00:00","3","2","14","75");
INSERT INTO tr_orderdetails VALUES("5844","947","2010-09-29 00:00:00","11","2","12","77");
INSERT INTO tr_orderdetails VALUES("5845","947","2010-10-13 00:00:00","53","2","13","75");
INSERT INTO tr_orderdetails VALUES("5846","947","2010-10-27 00:00:00","1","2","21","76");
INSERT INTO tr_orderdetails VALUES("5847","948","2010-09-29 00:00:00","11","2","13","76");
INSERT INTO tr_orderdetails VALUES("5848","948","2010-10-13 00:00:00","4","2","14","77");
INSERT INTO tr_orderdetails VALUES("5849","948","2010-10-27 00:00:00","3","2","13","76");
INSERT INTO tr_orderdetails VALUES("5850","949","2010-09-29 00:00:00","1","2","12","77");
INSERT INTO tr_orderdetails VALUES("5851","949","2010-10-13 00:00:00","3","2","12","76");
INSERT INTO tr_orderdetails VALUES("5852","949","2010-10-27 00:00:00","1","2","12","77");
INSERT INTO tr_orderdetails VALUES("5853","950","2010-09-29 00:00:00","4","2","12","76");
INSERT INTO tr_orderdetails VALUES("5854","950","2010-10-13 00:00:00","3","2","13","76");
INSERT INTO tr_orderdetails VALUES("5855","950","2010-10-27 00:00:00","2","2","21","76");
INSERT INTO tr_orderdetails VALUES("5856","951","2010-09-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5857","951","2010-10-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5858","951","2010-10-27 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5859","952","2010-09-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("5860","952","2010-10-13 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("5861","952","2010-10-27 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("5862","953","2010-09-29 00:00:00","4","2","13","76");
INSERT INTO tr_orderdetails VALUES("5863","953","2010-10-27 00:00:00","2","2","12","76");
INSERT INTO tr_orderdetails VALUES("5864","954","2010-09-29 00:00:00","2","2","20","77");
INSERT INTO tr_orderdetails VALUES("5865","954","2010-10-13 00:00:00","2","2","13","77");
INSERT INTO tr_orderdetails VALUES("5866","954","2010-10-27 00:00:00","2","2","21","75");
INSERT INTO tr_orderdetails VALUES("5867","955","2010-09-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("5868","955","2010-10-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5869","955","2010-10-27 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("5870","956","2010-09-29 00:00:00","2","2","13","77");
INSERT INTO tr_orderdetails VALUES("5871","956","2010-10-13 00:00:00","5","2","14","77");
INSERT INTO tr_orderdetails VALUES("5872","957","2010-09-29 00:00:00","11","2","13","77");
INSERT INTO tr_orderdetails VALUES("5873","957","2010-10-13 00:00:00","11","2","12","77");
INSERT INTO tr_orderdetails VALUES("5874","957","2010-10-27 00:00:00","11","2","12","77");
INSERT INTO tr_orderdetails VALUES("5875","958","2010-09-29 00:00:00","3","2","20","76");
INSERT INTO tr_orderdetails VALUES("5876","958","2010-10-13 00:00:00","4","2","13","76");
INSERT INTO tr_orderdetails VALUES("5877","958","2010-10-27 00:00:00","1","2","21","76");
INSERT INTO tr_orderdetails VALUES("5878","959","2010-09-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5879","959","2010-10-13 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("5880","959","2010-10-27 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("5881","960","2010-09-29 00:00:00","3","2","20","77");
INSERT INTO tr_orderdetails VALUES("5882","960","2010-10-13 00:00:00","2","2","13","76");
INSERT INTO tr_orderdetails VALUES("5883","960","2010-10-27 00:00:00","4","2","14","77");
INSERT INTO tr_orderdetails VALUES("5884","961","2010-09-29 00:00:00","2","2","14","76");
INSERT INTO tr_orderdetails VALUES("5885","961","2010-10-13 00:00:00","2","2","14","76");
INSERT INTO tr_orderdetails VALUES("5886","961","2010-10-27 00:00:00","2","2","13","76");
INSERT INTO tr_orderdetails VALUES("5887","962","2010-09-29 00:00:00","4","2","13","76");
INSERT INTO tr_orderdetails VALUES("5888","962","2010-10-13 00:00:00","4","2","14","76");
INSERT INTO tr_orderdetails VALUES("5889","962","2010-10-27 00:00:00","4","2","13","76");
INSERT INTO tr_orderdetails VALUES("5890","963","2010-09-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5891","963","2010-10-13 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("5892","963","2010-10-27 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("5893","964","2010-09-29 00:00:00","2","2","12","76");
INSERT INTO tr_orderdetails VALUES("5894","964","2010-10-13 00:00:00","3","2","12","76");
INSERT INTO tr_orderdetails VALUES("5895","964","2010-10-27 00:00:00","4","2","20","76");
INSERT INTO tr_orderdetails VALUES("5896","965","2010-09-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5897","965","2010-10-13 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("5898","965","2010-10-27 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("5899","966","2010-09-29 00:00:00","2","2","13","75");
INSERT INTO tr_orderdetails VALUES("5900","966","2010-10-13 00:00:00","3","2","14","75");
INSERT INTO tr_orderdetails VALUES("5901","966","2010-10-27 00:00:00","4","2","13","75");
INSERT INTO tr_orderdetails VALUES("5902","967","2010-09-29 00:00:00","5","2","13","75");
INSERT INTO tr_orderdetails VALUES("5903","967","2010-10-13 00:00:00","2","2","14","75");
INSERT INTO tr_orderdetails VALUES("5904","967","2010-10-27 00:00:00","3","2","13","75");
INSERT INTO tr_orderdetails VALUES("5905","968","2010-09-29 00:00:00","5","2","13","77");
INSERT INTO tr_orderdetails VALUES("5906","968","2010-10-13 00:00:00","11","2","12","76");
INSERT INTO tr_orderdetails VALUES("5907","968","2010-10-27 00:00:00","3","2","14","77");
INSERT INTO tr_orderdetails VALUES("5908","969","2010-09-29 00:00:00","2","2","12","76");
INSERT INTO tr_orderdetails VALUES("5909","969","2010-10-13 00:00:00","3","2","13","76");
INSERT INTO tr_orderdetails VALUES("5910","969","2010-10-27 00:00:00","4","2","20","76");
INSERT INTO tr_orderdetails VALUES("5911","970","2010-09-29 00:00:00","4","2","13","76");
INSERT INTO tr_orderdetails VALUES("5912","970","2010-10-13 00:00:00","2","2","12","75");
INSERT INTO tr_orderdetails VALUES("5913","970","2010-10-27 00:00:00","1","2","20","76");
INSERT INTO tr_orderdetails VALUES("5914","971","2010-09-29 00:00:00","3","2","12","77");
INSERT INTO tr_orderdetails VALUES("5915","971","2010-10-13 00:00:00","4","2","12","77");
INSERT INTO tr_orderdetails VALUES("5916","971","2010-10-27 00:00:00","2","2","12","77");
INSERT INTO tr_orderdetails VALUES("5917","972","2010-09-29 00:00:00","5","1","12","75");
INSERT INTO tr_orderdetails VALUES("5918","972","2010-10-13 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("5919","972","2010-10-27 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("5920","973","2010-09-29 00:00:00","11","2","20","76");
INSERT INTO tr_orderdetails VALUES("5921","973","2010-10-13 00:00:00","11","2","21","76");
INSERT INTO tr_orderdetails VALUES("5922","973","2010-10-27 00:00:00","11","2","21","76");
INSERT INTO tr_orderdetails VALUES("5923","974","2010-09-29 00:00:00","3","2","12","76");
INSERT INTO tr_orderdetails VALUES("5924","974","2010-10-13 00:00:00","4","2","12","77");
INSERT INTO tr_orderdetails VALUES("5925","974","2010-10-27 00:00:00","2","2","12","76");
INSERT INTO tr_orderdetails VALUES("5926","975","2010-09-29 00:00:00","2","2","13","76");
INSERT INTO tr_orderdetails VALUES("5927","975","2010-10-13 00:00:00","4","2","14","76");
INSERT INTO tr_orderdetails VALUES("5928","975","2010-10-27 00:00:00","2","2","13","76");
INSERT INTO tr_orderdetails VALUES("5929","976","2010-10-13 00:00:00","4","3","20","76");
INSERT INTO tr_orderdetails VALUES("5930","976","2010-10-27 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5931","977","2010-09-29 00:00:00","2","3","20","77");
INSERT INTO tr_orderdetails VALUES("5932","977","2010-10-13 00:00:00","3","3","21","77");
INSERT INTO tr_orderdetails VALUES("5933","977","2010-10-27 00:00:00","4","3","21","77");
INSERT INTO tr_orderdetails VALUES("5934","978","2010-09-29 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("5935","978","2010-10-13 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("5936","978","2010-10-27 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("5937","979","2010-09-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("5938","979","2010-10-13 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("5939","979","2010-10-27 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("5940","980","2010-09-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("5941","980","2010-10-13 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("5942","980","2010-10-27 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("5943","981","2010-09-20 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("5944","981","2010-09-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("5945","981","2010-09-24 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("5946","981","2010-09-27 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("5947","981","2010-09-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("5948","981","2010-10-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("5949","981","2010-10-04 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("5950","981","2010-10-06 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("5951","981","2010-10-13 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("5952","981","2010-10-15 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("5953","981","2010-10-18 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("5954","981","2010-10-20 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("5955","981","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("5956","981","2010-10-25 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("5957","981","2010-10-27 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("5958","981","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("5959","982","2010-09-20 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("5960","982","2010-09-27 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("5961","982","2010-10-04 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("5962","982","2010-10-18 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("5963","982","2010-10-25 00:00:00","4","2","12","75");
INSERT INTO tr_orderdetails VALUES("5964","983","2010-09-20 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("5965","983","2010-09-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("5966","983","2010-09-24 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5967","983","2010-09-27 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("5968","983","2010-09-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("5969","983","2010-10-01 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5970","983","2010-10-04 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("5971","983","2010-10-06 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("5972","983","2010-10-13 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5973","983","2010-10-15 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("5974","983","2010-10-18 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("5975","983","2010-10-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5976","983","2010-10-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("5977","983","2010-10-25 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("5978","983","2010-10-27 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5979","983","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("5980","984","2010-09-20 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("5981","985","2010-09-20 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("5982","985","2010-09-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("5983","985","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("5984","985","2010-09-27 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5985","985","2010-09-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("5986","985","2010-10-01 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("5987","985","2010-10-04 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("5988","985","2010-10-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5989","985","2010-10-13 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("5990","985","2010-10-15 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("5991","985","2010-10-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5992","985","2010-10-20 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("5993","985","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("5994","985","2010-10-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("5995","985","2010-10-27 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("5996","985","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("5997","986","2010-09-24 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("5998","986","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("5999","986","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6000","986","2010-10-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6001","986","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6002","987","2010-09-24 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6003","987","2010-10-01 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6004","987","2010-10-15 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6005","987","2010-10-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6006","987","2010-10-29 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6007","988","2010-09-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6008","988","2010-09-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6009","988","2010-10-06 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6010","988","2010-10-20 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6011","988","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6012","989","2010-09-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6013","989","2010-09-27 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6014","989","2010-10-04 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6015","989","2010-10-18 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("6016","989","2010-10-25 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6017","990","2010-09-22 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6018","990","2010-09-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6019","990","2010-10-06 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6020","990","2010-10-20 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6021","990","2010-10-27 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6022","991","2010-09-20 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6023","991","2010-09-22 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6024","991","2010-09-24 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6025","991","2010-09-27 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6026","991","2010-09-29 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6027","991","2010-10-01 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6028","991","2010-10-04 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6029","991","2010-10-06 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6030","991","2010-10-13 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6031","991","2010-10-15 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6032","991","2010-10-18 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6033","991","2010-10-20 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6034","991","2010-10-22 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6035","991","2010-10-25 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6036","991","2010-10-27 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6037","991","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6038","992","2010-09-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6039","992","2010-09-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6040","992","2010-09-27 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6041","992","2010-09-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6042","992","2010-10-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6043","992","2010-10-06 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6044","992","2010-10-13 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6045","992","2010-10-18 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6046","992","2010-10-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6047","992","2010-10-25 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6048","992","2010-10-27 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6049","993","2010-09-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6050","993","2010-09-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6051","993","2010-10-06 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6052","993","2010-10-20 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6053","993","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6054","994","2010-09-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6055","994","2010-09-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6056","994","2010-10-06 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6057","994","2010-10-13 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6058","994","2010-10-20 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6059","994","2010-10-25 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6060","994","2010-10-27 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6061","994","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6062","995","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6063","995","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6064","995","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6065","995","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6066","995","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6067","996","2010-09-24 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6068","996","2010-10-01 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6069","996","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6070","996","2010-10-22 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6071","996","2010-10-29 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6072","997","2010-09-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6073","997","2010-09-27 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6074","997","2010-10-04 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6075","997","2010-10-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6076","997","2010-10-25 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6077","998","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6078","998","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6079","998","2010-10-15 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6080","998","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6081","998","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6082","999","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6083","999","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6084","999","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6085","999","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6086","999","2010-10-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6087","1000","2010-09-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6088","1000","2010-09-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6089","1000","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6090","1000","2010-09-27 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6091","1000","2010-09-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6092","1000","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6093","1000","2010-10-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6094","1000","2010-10-06 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6095","1000","2010-10-13 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6096","1000","2010-10-15 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6097","1000","2010-10-18 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("6098","1000","2010-10-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6099","1000","2010-10-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6100","1000","2010-10-25 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6101","1000","2010-10-27 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6102","1000","2010-10-29 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("6103","1001","2010-09-20 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6104","1001","2010-09-22 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6105","1001","2010-09-24 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6106","1001","2010-09-27 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6107","1001","2010-09-29 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("6108","1001","2010-10-01 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6109","1001","2010-10-04 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6110","1001","2010-10-06 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6111","1001","2010-10-13 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6112","1001","2010-10-15 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6113","1001","2010-10-18 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6114","1001","2010-10-20 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6115","1001","2010-10-22 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("6116","1001","2010-10-25 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6117","1001","2010-10-27 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6118","1001","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6119","1002","2010-09-24 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6120","1002","2010-10-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6121","1002","2010-10-15 00:00:00","11","1","12","75");
INSERT INTO tr_orderdetails VALUES("6122","1002","2010-10-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6123","1002","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6124","1003","2010-09-20 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6125","1003","2010-09-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6126","1003","2010-09-24 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6127","1003","2010-09-27 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6128","1003","2010-09-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6129","1003","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6130","1003","2010-10-04 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6131","1003","2010-10-06 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6132","1003","2010-10-13 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6133","1003","2010-10-15 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6134","1003","2010-10-18 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6135","1003","2010-10-20 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6136","1003","2010-10-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6137","1003","2010-10-25 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6138","1003","2010-10-27 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6139","1003","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6140","1004","2010-09-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6141","1004","2010-09-27 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6142","1004","2010-10-04 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6143","1004","2010-10-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6144","1004","2010-10-25 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6145","1005","2010-09-20 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6146","1005","2010-09-27 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6147","1005","2010-10-04 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6148","1005","2010-10-18 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("6149","1005","2010-10-25 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6150","1006","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6151","1006","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6152","1006","2010-10-15 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6153","1006","2010-10-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6154","1006","2010-10-29 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6155","1007","2010-09-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6156","1007","2010-09-24 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6157","1007","2010-09-27 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6158","1007","2010-10-01 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6159","1007","2010-10-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6160","1007","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6161","1007","2010-10-18 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6162","1007","2010-10-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6163","1007","2010-10-25 00:00:00","5","1","12","75");
INSERT INTO tr_orderdetails VALUES("6164","1007","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6166","1008","2010-09-24 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6167","1008","2010-09-27 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6168","1008","2010-10-01 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6169","1008","2010-10-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6170","1008","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6171","1008","2010-10-18 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6172","1008","2010-10-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6173","1008","2010-10-25 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6174","1008","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6175","1009","2010-09-20 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6176","1009","2010-10-04 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("6177","1009","2010-10-18 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("6178","1009","2010-10-25 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("6179","1010","2010-09-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6180","1010","2010-09-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6181","1010","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6182","1010","2010-09-27 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("6183","1010","2010-09-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6184","1010","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6185","1010","2010-10-04 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6186","1010","2010-10-06 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6187","1010","2010-10-13 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6188","1010","2010-10-15 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6189","1010","2010-10-18 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6190","1010","2010-10-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6191","1010","2010-10-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6192","1010","2010-10-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6193","1010","2010-10-27 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6194","1010","2010-10-29 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6195","1011","2010-09-29 00:00:00","11","2","20","75");
INSERT INTO tr_orderdetails VALUES("6196","1011","2010-10-13 00:00:00","4","2","21","75");
INSERT INTO tr_orderdetails VALUES("6197","1011","2010-10-27 00:00:00","11","2","20","75");
INSERT INTO tr_orderdetails VALUES("6198","1012","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6199","1012","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6200","1012","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6201","1012","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6202","1012","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6203","1012","2010-10-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6204","1013","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6205","1013","2010-09-30 00:00:00","78","1","0","0");
INSERT INTO tr_orderdetails VALUES("6206","1013","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6207","1013","2010-10-14 00:00:00","78","1","0","0");
INSERT INTO tr_orderdetails VALUES("6208","1013","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6209","1013","2010-10-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6210","1014","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6211","1014","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6212","1014","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6213","1014","2010-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6214","1015","2010-09-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6215","1015","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6216","1015","2010-10-07 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6217","1015","2010-10-14 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6218","1015","2010-10-21 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6219","1015","2010-10-28 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6220","1016","2010-09-23 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6221","1016","2010-09-30 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6222","1016","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6223","1016","2010-10-14 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6224","1016","2010-10-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6225","1017","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6226","1017","2010-09-30 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6227","1017","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6228","1017","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6229","1017","2010-10-21 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6230","1017","2010-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6231","1018","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6232","1018","2010-09-30 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("6233","1018","2010-10-07 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("6234","1018","2010-10-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6235","1018","2010-10-21 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("6236","1018","2010-10-28 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("6237","1019","2010-09-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6238","1019","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6239","1019","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6240","1019","2010-10-14 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6241","1019","2010-10-21 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6242","1019","2010-10-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6243","1020","2010-09-23 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6244","1020","2010-09-30 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6245","1020","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6246","1020","2010-10-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6247","1020","2010-10-21 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6248","1020","2010-10-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6249","1021","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6250","1021","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6251","1021","2010-10-07 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6252","1021","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6253","1021","2010-10-21 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6254","1021","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6255","1022","2010-09-23 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6256","1022","2010-09-30 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6257","1022","2010-10-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6258","1022","2010-10-14 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6259","1022","2010-10-21 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6260","1022","2010-10-28 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6261","1023","2010-09-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6262","1023","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6263","1023","2010-10-21 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6264","1024","2010-09-23 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("6265","1024","2010-09-30 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("6266","1024","2010-10-07 00:00:00","1","3","0","0");
INSERT INTO tr_orderdetails VALUES("6267","1024","2010-10-14 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("6268","1024","2010-10-21 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("6269","1024","2010-10-28 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("6270","1025","2010-09-23 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6271","1025","2010-09-30 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6272","1025","2010-10-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6273","1025","2010-10-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6274","1025","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6275","1025","2010-10-28 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6276","1026","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6277","1026","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6278","1026","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6279","1026","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6280","1026","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6281","1026","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6282","1027","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6283","1027","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6284","1027","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6285","1027","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6286","1027","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6287","1027","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6288","1028","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6289","1028","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6290","1028","2010-10-07 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6291","1028","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6292","1028","2010-10-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6293","1028","2010-10-28 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6294","1029","2010-09-23 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6295","1029","2010-09-30 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6296","1029","2010-10-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6297","1029","2010-10-14 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6298","1029","2010-10-21 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6299","1029","2010-10-28 00:00:00","82","2","0","0");
INSERT INTO tr_orderdetails VALUES("6300","1030","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6301","1030","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6302","1030","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6303","1030","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6304","1030","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6305","1030","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6306","1031","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6307","1031","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6308","1031","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6309","1031","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6310","1031","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6311","1031","2010-10-28 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6312","1032","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6313","1032","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6314","1032","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6315","1032","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6316","1032","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6317","1032","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6318","1033","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6319","1033","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6320","1033","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6321","1033","2010-10-14 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6322","1033","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6323","1033","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6324","1034","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6325","1034","2010-09-30 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6326","1034","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6327","1034","2010-10-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6328","1034","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6329","1034","2010-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6330","1035","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6331","1035","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6332","1035","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6333","1035","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6334","1035","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6335","1035","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6336","1036","2010-09-23 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("6337","1036","2010-09-30 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("6338","1036","2010-10-07 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("6339","1036","2010-10-14 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("6340","1036","2010-10-21 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("6341","1036","2010-10-28 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("6342","1037","2010-09-23 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6343","1037","2010-09-30 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6344","1037","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6345","1037","2010-10-14 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6346","1037","2010-10-21 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6347","1037","2010-10-28 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6348","1038","2010-09-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6349","1038","2010-10-06 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("6351","1038","2010-10-20 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6352","1038","2010-10-26 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("6353","1039","2010-09-22 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6354","1039","2010-09-28 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6355","1039","2010-10-06 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6356","1039","2010-10-12 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6357","1039","2010-10-20 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6358","1039","2010-10-26 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6360","1040","2010-09-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6361","1040","2010-09-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6362","1040","2010-10-06 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6363","1040","2010-10-12 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6364","1040","2010-10-20 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6365","1040","2010-10-26 00:00:00","1","1","12","75");
INSERT INTO tr_orderdetails VALUES("6366","1041","2010-09-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6367","1041","2010-09-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6368","1041","2010-10-06 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6369","1041","2010-10-12 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("6370","1041","2010-10-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6371","1041","2010-10-26 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6372","1042","2010-09-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6373","1042","2010-09-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6374","1042","2010-10-06 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6375","1042","2010-10-12 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6376","1042","2010-10-20 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6377","1042","2010-10-26 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6378","1043","2010-09-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6379","1043","2010-09-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6380","1043","2010-10-06 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6381","1043","2010-10-12 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6382","1043","2010-10-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6383","1043","2010-10-26 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6384","1044","2010-09-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6385","1044","2010-09-28 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("6386","1044","2010-10-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6387","1044","2010-10-12 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6388","1044","2010-10-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6389","1044","2010-10-26 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("6390","1045","2010-10-06 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6391","1045","2010-10-12 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6392","1045","2010-10-20 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6393","1045","2010-10-26 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6394","1046","2010-09-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6395","1046","2010-09-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6396","1046","2010-10-06 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6397","1046","2010-10-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6398","1046","2010-10-20 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6399","1046","2010-10-26 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6400","1047","2010-09-22 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6401","1047","2010-09-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6402","1047","2010-10-06 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("6403","1047","2010-10-12 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6404","1047","2010-10-20 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6405","1047","2010-10-26 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6412","1049","2010-09-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6413","1049","2010-09-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6414","1049","2010-10-06 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6415","1049","2010-10-12 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("6416","1049","2010-10-20 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6417","1049","2010-10-26 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6418","1050","2010-09-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6419","1050","2010-09-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6420","1050","2010-10-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6421","1050","2010-10-12 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6422","1050","2010-10-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6423","1050","2010-10-26 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6424","1051","2010-09-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6425","1051","2010-10-06 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6426","1052","2010-09-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6427","1052","2010-10-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6428","1053","2010-09-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6429","1053","2010-09-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6430","1053","2010-10-06 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6431","1053","2010-10-12 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("6432","1053","2010-10-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6433","1053","2010-10-26 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6434","1054","2010-09-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6435","1054","2010-09-28 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6436","1054","2010-10-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6437","1054","2010-10-12 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6438","1054","2010-10-20 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6439","1054","2010-10-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6440","1055","2010-09-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6441","1055","2010-09-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6442","1055","2010-10-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6443","1055","2010-10-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6444","1055","2010-10-20 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6445","1055","2010-10-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6446","1056","2010-09-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6447","1056","2010-09-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6448","1056","2010-10-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6449","1056","2010-10-12 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6450","1056","2010-10-20 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6451","1056","2010-10-26 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6452","1057","2010-09-22 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6453","1057","2010-09-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6454","1057","2010-10-06 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6455","1057","2010-10-12 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6456","1057","2010-10-20 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6457","1057","2010-10-26 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6458","1058","2010-09-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6459","1058","2010-09-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6460","1058","2010-10-06 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6461","1058","2010-10-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6462","1058","2010-10-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6463","1058","2010-10-26 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6464","1059","2010-09-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6465","1059","2010-10-06 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6466","1059","2010-10-20 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6467","1060","2010-09-28 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("6468","1060","2010-10-12 00:00:00","1","3","0","0");
INSERT INTO tr_orderdetails VALUES("6469","1060","2010-10-26 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("6470","1061","2010-09-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6471","1061","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6472","1061","2010-10-21 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6473","1062","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6474","1062","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6475","1062","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6476","1062","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6477","1062","2010-10-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6478","1062","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6479","1063","2010-09-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6480","1063","2010-10-12 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6481","1063","2010-10-26 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6482","1064","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6483","1064","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6484","1064","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6485","1064","2010-10-14 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6486","1064","2010-10-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6487","1064","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6488","1065","2010-09-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6489","1065","2010-09-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6490","1065","2010-10-06 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6491","1065","2010-10-12 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6492","1065","2010-10-20 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6493","1065","2010-10-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6494","1066","2010-09-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6495","1066","2010-09-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6496","1066","2010-10-06 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6497","1066","2010-10-12 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6498","1066","2010-10-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6499","1066","2010-10-26 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6500","1067","2010-09-23 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6501","1067","2010-09-30 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6502","1067","2010-10-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6503","1067","2010-10-14 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6504","1067","2010-10-21 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6505","1067","2010-10-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6506","1068","2010-09-22 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6507","1068","2010-09-28 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("6508","1068","2010-10-06 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6509","1068","2010-10-12 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6510","1068","2010-10-20 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6511","1068","2010-10-26 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6512","1069","2010-09-22 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6513","1069","2010-09-28 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6514","1069","2010-10-06 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6515","1069","2010-10-12 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6516","1069","2010-10-20 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6517","1069","2010-10-26 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6518","1070","2010-09-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6519","1070","2010-09-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6520","1070","2010-10-06 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6521","1070","2010-10-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6522","1070","2010-10-20 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6523","1070","2010-10-26 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6524","1071","2010-09-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6525","1071","2010-10-12 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6526","1071","2010-10-26 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6527","1072","2010-09-24 00:00:00","37","1","0","0");
INSERT INTO tr_orderdetails VALUES("6528","1073","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6529","1073","2010-09-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6530","1073","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6531","1073","2010-10-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6532","1073","2010-10-21 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("6533","1073","2010-10-28 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6534","1074","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6535","1074","2010-09-30 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6536","1074","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6537","1074","2010-10-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6538","1074","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6539","1074","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6540","1075","2010-09-23 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6541","1075","2010-09-30 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6542","1075","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6543","1075","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6544","1075","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6545","1075","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6546","1076","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6547","1076","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6548","1076","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6549","1076","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6550","1076","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6551","1076","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6552","1077","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6553","1077","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6554","1077","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6555","1077","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6556","1077","2010-10-21 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6557","1077","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6558","1078","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6559","1078","2010-09-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6560","1078","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6561","1078","2010-10-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6562","1078","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6563","1078","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6564","1079","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6565","1079","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6566","1079","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6567","1079","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6568","1079","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6569","1079","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6570","1080","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6571","1080","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6572","1080","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6573","1080","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6574","1080","2010-10-21 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("6575","1080","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6576","1081","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6577","1081","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6578","1081","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6579","1081","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6580","1081","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6581","1081","2010-10-28 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6582","1082","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6583","1082","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6584","1082","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6585","1082","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6586","1082","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6587","1082","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6588","1083","2010-09-23 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6589","1083","2010-09-30 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6590","1083","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6591","1083","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6592","1083","2010-10-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6593","1083","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6594","1084","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6595","1084","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6596","1084","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6597","1084","2010-10-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6598","1084","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6599","1084","2010-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6600","1085","2010-09-23 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("6601","1085","2010-09-30 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("6602","1085","2010-10-07 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("6603","1085","2010-10-14 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("6604","1085","2010-10-21 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("6605","1085","2010-10-28 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("6606","1086","2010-09-23 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6607","1086","2010-09-30 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6608","1086","2010-10-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6609","1086","2010-10-14 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6610","1086","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6611","1086","2010-10-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6612","1087","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6613","1087","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6614","1087","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6615","1087","2010-10-14 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6616","1087","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6617","1087","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6618","1088","2010-09-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6619","1088","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6620","1088","2010-10-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6621","1088","2010-10-14 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6622","1088","2010-10-21 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6623","1088","2010-10-28 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6624","1089","2010-09-23 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6625","1089","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6626","1090","2010-09-23 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6627","1090","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6628","1090","2010-10-21 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6629","1091","2010-09-23 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6630","1091","2010-09-30 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6631","1091","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6632","1091","2010-10-14 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6633","1091","2010-10-21 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6634","1091","2010-10-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6635","1092","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6636","1092","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6637","1092","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6638","1092","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6639","1092","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6640","1092","2010-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6641","1093","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6642","1093","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6643","1093","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6644","1093","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6645","1093","2010-10-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6646","1093","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6647","1094","2010-09-23 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6648","1094","2010-09-30 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6649","1094","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6650","1094","2010-10-14 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("6651","1094","2010-10-21 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6652","1094","2010-10-28 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6653","1095","2010-09-23 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6654","1095","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6655","1095","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6656","1095","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6657","1095","2010-10-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6658","1095","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6659","1096","2010-09-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6660","1096","2010-09-30 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6661","1096","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6662","1096","2010-10-14 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6663","1096","2010-10-21 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6664","1096","2010-10-28 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6665","1097","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6666","1097","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6667","1097","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6668","1097","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6669","1097","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6670","1097","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6671","1098","2010-09-23 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6672","1098","2010-09-30 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6673","1098","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6674","1098","2010-10-14 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("6675","1098","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6676","1098","2010-10-28 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6677","1099","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6678","1099","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6679","1099","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6680","1099","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6681","1099","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6682","1099","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6683","1100","2010-09-23 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6684","1100","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6685","1100","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6686","1100","2010-10-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6687","1100","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6688","1100","2010-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6689","1101","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6690","1101","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6691","1101","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6692","1101","2010-10-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6693","1101","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6694","1102","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6695","1102","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6696","1102","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6697","1102","2010-10-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6698","1102","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6699","1102","2010-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6700","1103","2010-09-23 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6701","1103","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6702","1103","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6703","1103","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6704","1103","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6705","1103","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6706","1104","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6707","1104","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6708","1104","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6709","1104","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6710","1104","2010-10-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6711","1104","2010-10-28 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6712","1105","2010-09-23 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6713","1105","2010-09-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6714","1105","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6715","1105","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6716","1105","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6717","1105","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6718","1106","2010-09-23 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6719","1106","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6720","1106","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6721","1106","2010-10-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6722","1106","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6723","1106","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6724","1107","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6725","1107","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6726","1107","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6727","1107","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6728","1107","2010-10-21 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6729","1107","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6730","1108","2010-09-23 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6731","1108","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6732","1108","2010-10-07 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6733","1108","2010-10-14 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6734","1108","2010-10-21 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6735","1108","2010-10-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6736","1109","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6737","1109","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6738","1109","2010-10-07 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("6739","1109","2010-10-14 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6740","1109","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6741","1109","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6742","1110","2010-09-23 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6743","1110","2010-09-30 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6744","1110","2010-10-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6745","1110","2010-10-14 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6746","1110","2010-10-21 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6747","1110","2010-10-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6748","1111","2010-09-23 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("6749","1111","2010-09-30 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6750","1111","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6751","1111","2010-10-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6752","1111","2010-10-21 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("6753","1111","2010-10-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6754","1112","2010-09-23 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6755","1112","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6756","1112","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6757","1112","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6758","1112","2010-10-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6759","1112","2010-10-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6760","1113","2010-09-30 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6761","1113","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6762","1113","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6763","1113","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6764","1113","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6765","1114","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6766","1114","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6767","1114","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6768","1114","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6769","1114","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6770","1114","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6771","1115","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6772","1115","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6773","1115","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6774","1115","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6775","1115","2010-10-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6776","1115","2010-10-28 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6777","1116","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6778","1116","2010-09-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6779","1116","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6780","1116","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6781","1116","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6782","1116","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6783","1117","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6784","1117","2010-09-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6785","1117","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6786","1117","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6787","1117","2010-10-21 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6788","1117","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6789","1118","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6790","1118","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6791","1118","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6792","1118","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6793","1118","2010-10-21 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6794","1118","2010-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6795","1119","2010-09-23 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6796","1119","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6797","1119","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6798","1119","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6799","1119","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6800","1119","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6801","1120","2010-09-23 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6802","1120","2010-09-30 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6803","1120","2010-10-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6804","1120","2010-10-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6805","1120","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6806","1120","2010-10-28 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6807","1121","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6808","1121","2010-09-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6809","1121","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6810","1121","2010-10-14 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6811","1121","2010-10-21 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("6812","1121","2010-10-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6813","1122","2010-09-23 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6814","1122","2010-09-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6815","1122","2010-10-07 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6816","1122","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6817","1122","2010-10-21 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("6818","1122","2010-10-28 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6819","1123","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6820","1123","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6821","1123","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6822","1123","2010-10-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6823","1123","2010-10-21 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6824","1123","2010-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6825","1124","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6826","1124","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6827","1124","2010-10-07 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6828","1124","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6829","1124","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6830","1125","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6831","1126","2010-09-23 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6832","1126","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6833","1126","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6834","1126","2010-10-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6835","1126","2010-10-21 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6836","1126","2010-10-28 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6837","1127","2010-09-23 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("6838","1127","2010-09-30 00:00:00","3","3","0","0");
INSERT INTO tr_orderdetails VALUES("6839","1127","2010-10-07 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("6840","1127","2010-10-14 00:00:00","3","3","0","0");
INSERT INTO tr_orderdetails VALUES("6841","1127","2010-10-21 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("6842","1127","2010-10-28 00:00:00","3","3","0","0");
INSERT INTO tr_orderdetails VALUES("6843","1128","2010-09-23 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6844","1128","2010-09-30 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6845","1128","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6846","1128","2010-10-14 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6847","1128","2010-10-21 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6848","1128","2010-10-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6849","1129","2010-09-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6850","1129","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6851","1129","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6852","1129","2010-10-14 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6853","1129","2010-10-21 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6854","1129","2010-10-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6855","1130","2010-09-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6856","1130","2010-09-28 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6857","1130","2010-10-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6858","1130","2010-10-12 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6859","1130","2010-10-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6860","1130","2010-10-26 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6862","1131","2010-09-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6863","1131","2010-10-06 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6864","1131","2010-10-12 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6865","1131","2010-10-20 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6866","1131","2010-10-26 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6868","1132","2010-09-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6869","1132","2010-10-06 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6870","1132","2010-10-12 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6871","1132","2010-10-20 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6872","1132","2010-10-26 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6873","1133","2010-09-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6874","1133","2010-09-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6875","1133","2010-10-06 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6876","1133","2010-10-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6877","1133","2010-10-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6878","1133","2010-10-26 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6879","1134","2010-09-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6880","1134","2010-09-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6881","1134","2010-10-06 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6882","1134","2010-10-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6883","1134","2010-10-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6884","1134","2010-10-26 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6885","1135","2010-09-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6886","1135","2010-09-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6887","1135","2010-10-06 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6888","1135","2010-10-12 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6889","1135","2010-10-20 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6890","1135","2010-10-26 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6891","1136","2010-09-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6892","1136","2010-10-12 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6893","1136","2010-10-26 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6895","1137","2010-09-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6896","1137","2010-10-06 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6897","1137","2010-10-12 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6899","1137","2010-10-26 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6900","1138","2010-09-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6901","1138","2010-10-12 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6902","1138","2010-10-26 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6903","1139","2010-09-22 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6904","1139","2010-09-28 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6905","1139","2010-10-06 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6906","1139","2010-10-12 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6907","1139","2010-10-20 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("6908","1139","2010-10-26 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("6909","1140","2010-09-22 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("6910","1140","2010-09-28 00:00:00","3","3","0","0");
INSERT INTO tr_orderdetails VALUES("6911","1140","2010-10-06 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("6912","1140","2010-10-12 00:00:00","2","3","0","0");
INSERT INTO tr_orderdetails VALUES("6913","1140","2010-10-20 00:00:00","3","3","0","0");
INSERT INTO tr_orderdetails VALUES("6914","1140","2010-10-26 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("6915","1141","2010-09-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6916","1141","2010-09-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6917","1141","2010-10-06 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6918","1141","2010-10-12 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6919","1141","2010-10-20 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6920","1141","2010-10-26 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6921","1142","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6922","1142","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6923","1142","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6924","1142","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6925","1142","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6926","1142","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6927","1143","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6928","1143","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6929","1143","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6930","1143","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6931","1143","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6932","1143","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6939","1145","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6940","1145","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6941","1145","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6942","1145","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6943","1145","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6944","1145","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6945","1146","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6946","1146","2010-10-07 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("6947","1146","2010-10-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6948","1147","2010-09-23 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6949","1147","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6950","1147","2010-10-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6951","1147","2010-10-14 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6952","1147","2010-10-21 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6953","1147","2010-10-28 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6954","1148","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6955","1148","2010-09-30 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6956","1148","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6957","1148","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6958","1148","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6959","1148","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6960","1149","2010-09-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6961","1149","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6962","1149","2010-10-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("6963","1149","2010-10-14 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("6964","1149","2010-10-21 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6965","1149","2010-10-28 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("6966","1150","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6967","1150","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6972","1151","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("6973","1151","2010-09-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6974","1151","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6975","1151","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6976","1151","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6977","1151","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6978","1152","2010-09-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6979","1152","2010-09-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6980","1152","2010-10-06 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6981","1152","2010-10-12 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6982","1152","2010-10-20 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6983","1152","2010-10-26 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6984","1153","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6985","1153","2010-09-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6986","1153","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("6987","1153","2010-10-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6988","1153","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6989","1153","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6990","1154","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6991","1154","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6992","1154","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("6993","1154","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6994","1154","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6995","1154","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6996","1155","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("6997","1155","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("6998","1155","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("6999","1155","2010-10-14 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7000","1155","2010-10-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7001","1155","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7002","1156","2010-09-22 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7003","1156","2010-09-28 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7004","1156","2010-10-06 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7005","1156","2010-10-12 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7006","1156","2010-10-20 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7007","1156","2010-10-26 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7008","1157","2010-09-23 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7009","1157","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7010","1157","2010-10-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7011","1157","2010-10-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7012","1157","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7013","1157","2010-10-28 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7014","1158","2010-09-23 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7015","1158","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7016","1158","2010-10-07 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7017","1158","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7018","1158","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7019","1158","2010-10-28 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7020","1159","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7021","1159","2010-09-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7022","1159","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7023","1159","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7024","1159","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7025","1159","2010-10-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7026","1160","2010-09-23 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7027","1160","2010-09-30 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7028","1160","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7029","1160","2010-10-14 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7030","1160","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7031","1160","2010-10-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7032","1161","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7033","1161","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7034","1161","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7035","1161","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7036","1162","2010-09-23 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7037","1162","2010-09-30 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7038","1162","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7039","1162","2010-10-14 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7040","1162","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7041","1162","2010-10-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7042","1163","2010-09-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7043","1163","2010-09-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7044","1163","2010-10-06 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7045","1163","2010-10-12 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7046","1163","2010-10-20 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7047","1164","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7048","1164","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7049","1164","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7050","1164","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7051","1164","2010-10-21 00:00:00","4","1","12","75");
INSERT INTO tr_orderdetails VALUES("7052","1164","2010-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7053","1165","2010-09-22 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7054","1165","2010-10-06 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7055","1165","2010-10-20 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7056","1165","2010-10-26 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7057","1166","2010-09-22 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7058","1166","2010-09-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7059","1166","2010-10-06 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7060","1166","2010-10-12 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7061","1166","2010-10-20 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7062","1166","2010-10-26 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7063","1167","2010-09-22 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7064","1167","2010-09-28 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7065","1167","2010-10-06 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("7066","1167","2010-10-12 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7067","1167","2010-10-20 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7068","1167","2010-10-26 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7069","1168","2010-09-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7070","1168","2010-09-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7071","1168","2010-10-06 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7072","1168","2010-10-12 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7073","1168","2010-10-20 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7074","1168","2010-10-26 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7075","1169","2010-09-23 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7076","1169","2010-09-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7077","1169","2010-10-07 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("7078","1169","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7079","1169","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7080","1169","2010-10-28 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("7081","1170","2010-09-22 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7082","1170","2010-09-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7083","1170","2010-10-06 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7084","1170","2010-10-12 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7085","1170","2010-10-20 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7086","1170","2010-10-26 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7087","1171","2010-09-23 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7088","1171","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7089","1171","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7090","1171","2010-10-14 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7091","1171","2010-10-21 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7092","1171","2010-10-28 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7093","1172","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7094","1172","2010-09-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7095","1172","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7096","1172","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7097","1172","2010-10-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7098","1172","2010-10-28 00:00:00","3","1","12","75");
INSERT INTO tr_orderdetails VALUES("7099","1173","2010-09-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7100","1173","2010-09-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7101","1173","2010-10-06 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7102","1173","2010-10-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7103","1173","2010-10-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7104","1173","2010-10-26 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7105","1174","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7106","1174","2010-09-30 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7107","1174","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7108","1174","2010-10-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7109","1174","2010-10-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7110","1174","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7111","1175","2010-09-22 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7112","1175","2010-09-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7113","1175","2010-10-06 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7114","1175","2010-10-12 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7115","1175","2010-10-20 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7116","1175","2010-10-26 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7117","1176","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7118","1176","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7119","1176","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7120","1176","2010-10-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7121","1176","2010-10-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7122","1176","2010-10-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7123","1177","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7124","1177","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7125","1177","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7126","1177","2010-10-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7127","1177","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7128","1177","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7129","1178","2010-09-22 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7130","1178","2010-09-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7131","1178","2010-10-06 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7132","1178","2010-10-12 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7133","1178","2010-10-20 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7134","1178","2010-10-26 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7135","1179","2010-09-23 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7136","1179","2010-09-30 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7137","1179","2010-10-07 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7138","1179","2010-10-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7139","1179","2010-10-21 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7140","1179","2010-10-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7141","1180","2010-09-22 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7142","1180","2010-09-28 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7143","1180","2010-10-06 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7144","1180","2010-10-12 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7145","1180","2010-10-20 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7146","1180","2010-10-26 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7147","1181","2010-09-23 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("7148","1181","2010-09-30 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("7149","1181","2010-10-07 00:00:00","53","3","0","0");
INSERT INTO tr_orderdetails VALUES("7150","1181","2010-10-14 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("7151","1181","2010-10-21 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("7152","1181","2010-10-28 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("7153","1182","2010-09-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7154","1182","2010-09-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7155","1182","2010-10-06 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7156","1182","2010-10-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7157","1182","2010-10-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7158","1182","2010-10-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7159","1183","2010-09-23 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("7160","1183","2010-09-30 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("7161","1183","2010-10-07 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("7162","1183","2010-10-14 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("7163","1183","2010-10-21 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("7164","1183","2010-10-28 00:00:00","3","3","0","0");
INSERT INTO tr_orderdetails VALUES("7165","1184","2010-09-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7166","1184","2010-09-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7167","1184","2010-10-06 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7168","1184","2010-10-12 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7169","1184","2010-10-20 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7170","1184","2010-10-26 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7171","1185","2010-09-23 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("7172","1185","2010-09-30 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("7173","1185","2010-10-07 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("7174","1185","2010-10-14 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("7175","1185","2010-10-21 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("7176","1185","2010-10-28 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("7177","1186","2010-09-22 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7178","1186","2010-09-28 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7179","1186","2010-10-06 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7180","1186","2010-10-12 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7181","1186","2010-10-20 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7182","1186","2010-10-26 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7183","1187","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7184","1187","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7185","1187","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7186","1187","2010-10-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7187","1187","2010-10-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7188","1187","2010-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7189","1188","2010-09-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7190","1188","2010-09-28 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7191","1188","2010-10-06 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7192","1188","2010-10-12 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7193","1188","2010-10-20 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7194","1188","2010-10-26 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7195","1189","2010-09-23 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7196","1189","2010-09-30 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7197","1189","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7198","1189","2010-10-14 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("7199","1189","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7200","1189","2010-10-28 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7201","1190","2010-09-22 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7202","1190","2010-09-28 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("7203","1190","2010-10-06 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7204","1190","2010-10-12 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7205","1190","2010-10-20 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7206","1190","2010-10-26 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7207","1191","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7208","1191","2010-09-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7209","1191","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7210","1191","2010-10-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7211","1191","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7212","1191","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7213","1192","2010-09-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7214","1192","2010-09-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7215","1192","2010-10-06 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7216","1192","2010-10-12 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7217","1192","2010-10-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7218","1192","2010-10-26 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7219","1193","2010-09-23 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7220","1193","2010-09-30 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7221","1193","2010-10-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7222","1193","2010-10-14 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7223","1193","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7224","1193","2010-10-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7225","1194","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7226","1194","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7227","1194","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7228","1194","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7229","1194","2010-10-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7230","1194","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7231","1195","2010-09-22 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7232","1195","2010-09-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7233","1195","2010-10-06 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7234","1195","2010-10-12 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7235","1195","2010-10-20 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7236","1195","2010-10-26 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7238","1196","2010-09-23 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7239","1196","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7240","1196","2010-10-07 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7241","1196","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7242","1196","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7243","1196","2010-10-28 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7244","1197","2010-09-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7245","1197","2010-09-28 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7246","1197","2010-10-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7247","1197","2010-10-12 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7248","1197","2010-10-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7249","1197","2010-10-26 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7250","1198","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7251","1198","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7252","1198","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7253","1198","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7254","1198","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7255","1198","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7256","1199","2010-09-22 00:00:00","2","3","0","0");
INSERT INTO tr_orderdetails VALUES("7257","1199","2010-09-28 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("7258","1199","2010-10-06 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("7259","1199","2010-10-12 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("7260","1199","2010-10-20 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("7261","1199","2010-10-26 00:00:00","3","3","0","0");
INSERT INTO tr_orderdetails VALUES("7262","1200","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7263","1200","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7264","1200","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7265","1200","2010-10-14 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7266","1200","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7267","1200","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7268","1201","2010-09-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7269","1201","2010-09-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7270","1201","2010-10-06 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7271","1201","2010-10-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7272","1201","2010-10-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7273","1201","2010-10-26 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7274","1202","2010-09-22 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7275","1202","2010-09-28 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7276","1202","2010-10-06 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7277","1202","2010-10-12 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7278","1202","2010-10-20 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7279","1202","2010-10-26 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7280","1203","2010-09-23 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7281","1203","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7282","1203","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7283","1203","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7284","1203","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7285","1203","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7286","1204","2010-10-06 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7287","1204","2010-10-12 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7288","1204","2010-10-20 00:00:00","4","2","12","75");
INSERT INTO tr_orderdetails VALUES("7289","1204","2010-10-26 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7290","1205","2010-09-23 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("7291","1205","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7292","1206","2010-09-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7293","1206","2010-10-21 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7294","1207","2010-09-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7295","1207","2010-09-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7296","1208","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7297","1208","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7298","1208","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7299","1208","2010-10-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7300","1208","2010-10-21 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7301","1208","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7302","1209","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7303","1209","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7304","1209","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7305","1209","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7306","1209","2010-10-21 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7307","1209","2010-10-28 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7308","1210","2010-09-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7309","1210","2010-10-06 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7310","1210","2010-10-20 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7311","1211","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7312","1211","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7313","1211","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7314","1211","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7315","1211","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7316","1211","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7317","1212","2010-09-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7318","1212","2010-09-28 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7319","1212","2010-10-06 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7320","1212","2010-10-12 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7321","1212","2010-10-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7322","1212","2010-10-26 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7323","1213","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7324","1213","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7325","1213","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7326","1213","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7327","1213","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7328","1213","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7329","1214","2010-09-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7330","1214","2010-09-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7331","1214","2010-10-06 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7332","1214","2010-10-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7333","1214","2010-10-20 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7334","1214","2010-10-26 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7335","1215","2010-09-23 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7336","1215","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7337","1215","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7338","1215","2010-10-14 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7339","1215","2010-10-21 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7340","1215","2010-10-28 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7341","1216","2010-09-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7343","1216","2010-10-06 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7344","1216","2010-10-12 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7345","1216","2010-10-20 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7346","1216","2010-10-26 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7347","1217","2010-09-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7348","1217","2010-09-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7349","1217","2010-10-06 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7350","1217","2010-10-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7351","1217","2010-10-20 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("7352","1217","2010-10-26 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7353","1218","2010-09-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7354","1218","2010-09-30 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("7355","1218","2010-10-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7356","1218","2010-10-14 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("7357","1218","2010-10-21 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7358","1218","2010-10-28 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("7359","1219","2010-09-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7360","1219","2010-09-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7361","1219","2010-10-06 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7362","1219","2010-10-12 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7363","1219","2010-10-20 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7364","1219","2010-10-26 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("7365","1220","2010-09-23 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7366","1220","2010-09-30 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7367","1220","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7368","1220","2010-10-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7369","1220","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7370","1220","2010-10-28 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7371","1221","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7372","1221","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7373","1221","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7374","1221","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7375","1221","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7376","1221","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7377","1222","2010-09-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7378","1223","2010-09-23 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7379","1223","2010-10-14 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7381","1225","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7382","1225","2010-09-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7383","1225","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7384","1225","2010-10-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7385","1225","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7386","1225","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7387","1226","2010-09-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7388","1227","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7389","1227","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7390","1227","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7391","1227","2010-10-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7392","1227","2010-10-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7393","1227","2010-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7394","1228","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7395","1228","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7396","1228","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7397","1229","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7398","1229","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7399","1229","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7400","1229","2010-10-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7401","1229","2010-10-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7402","1229","2010-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7403","1230","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7404","1230","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7405","1230","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7406","1230","2010-10-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7407","1230","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7408","1230","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7410","1231","2010-10-20 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7411","1232","2010-09-22 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7412","1233","2010-09-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7413","1233","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7414","1233","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7415","1233","2010-10-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7416","1233","2010-10-21 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("7417","1233","2010-10-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7418","1234","2010-09-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7419","1234","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7420","1234","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7421","1234","2010-10-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7422","1234","2010-10-21 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("7423","1234","2010-10-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7424","1235","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7425","1235","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7426","1235","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7427","1235","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7428","1235","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7429","1236","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7430","1236","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7431","1236","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7432","1236","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7433","1236","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7434","1236","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7435","1237","2010-09-23 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7436","1237","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7437","1237","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7438","1237","2010-10-14 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7439","1237","2010-10-21 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7440","1237","2010-10-28 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7441","1238","2010-09-24 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7442","1238","2010-10-01 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7443","1238","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7444","1238","2010-10-15 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7445","1238","2010-10-22 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7446","1238","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7447","1239","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7448","1239","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7449","1239","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7450","1239","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7451","1239","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7452","1239","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7453","1240","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7454","1240","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7455","1240","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7456","1240","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7457","1240","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7458","1240","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7459","1241","2010-09-24 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7460","1241","2010-10-01 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7461","1241","2010-10-07 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("7462","1241","2010-10-15 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7463","1241","2010-10-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7464","1241","2010-10-29 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7465","1242","2010-09-24 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7466","1242","2010-10-01 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7467","1242","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7468","1242","2010-10-15 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7469","1242","2010-10-22 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7470","1242","2010-10-29 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7471","1243","2010-09-23 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7472","1243","2010-09-30 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7473","1243","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7474","1243","2010-10-14 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7475","1243","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7476","1243","2010-10-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7477","1244","2010-09-24 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7478","1244","2010-10-01 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7479","1244","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7480","1244","2010-10-15 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7481","1244","2010-10-22 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7482","1244","2010-10-29 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7483","1245","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7484","1245","2010-09-30 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("7485","1245","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7486","1245","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7487","1245","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7488","1245","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7489","1246","2010-09-24 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7490","1246","2010-10-01 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7491","1246","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7492","1246","2010-10-15 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7493","1246","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7494","1246","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7495","1247","2010-09-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7496","1247","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7497","1247","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7498","1247","2010-10-14 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7499","1247","2010-10-21 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7500","1247","2010-10-28 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7501","1248","2010-09-24 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7502","1248","2010-10-01 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7503","1248","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7504","1248","2010-10-15 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("7505","1248","2010-10-22 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7506","1248","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7507","1249","2010-09-23 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7508","1249","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7509","1249","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7510","1249","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7511","1249","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7512","1249","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7513","1250","2010-09-24 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7514","1250","2010-10-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7515","1250","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7516","1250","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7517","1250","2010-10-22 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7518","1250","2010-10-29 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7519","1251","2010-09-23 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("7520","1251","2010-09-30 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("7521","1251","2010-10-07 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("7522","1251","2010-10-14 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("7523","1251","2010-10-21 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("7524","1251","2010-10-28 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("7525","1252","2010-09-24 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7526","1252","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7527","1252","2010-10-07 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("7528","1252","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7529","1252","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7530","1252","2010-10-29 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7531","1253","2010-09-23 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7532","1253","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7533","1253","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7534","1253","2010-10-14 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7535","1253","2010-10-21 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7536","1253","2010-10-28 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7537","1254","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7538","1254","2010-10-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7539","1254","2010-10-07 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("7540","1254","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7541","1254","2010-10-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7542","1254","2010-10-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7543","1255","2010-09-23 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7544","1255","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7545","1255","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7546","1255","2010-10-14 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7547","1255","2010-10-21 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7548","1255","2010-10-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7549","1256","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7550","1256","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7551","1256","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7552","1256","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7553","1256","2010-10-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7554","1256","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7555","1257","2010-09-23 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7556","1257","2010-09-30 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7557","1257","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7558","1257","2010-10-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7559","1257","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7560","1257","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7561","1258","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7562","1258","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7563","1258","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7564","1258","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7565","1258","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7566","1259","2010-09-24 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7567","1259","2010-10-01 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7568","1259","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7569","1259","2010-10-15 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7570","1259","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7571","1259","2010-10-29 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7572","1260","2010-09-23 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7573","1260","2010-09-30 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7574","1260","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7575","1260","2010-10-14 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7576","1260","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7577","1260","2010-10-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7578","1261","2010-09-24 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7579","1261","2010-10-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7580","1261","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7581","1261","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7582","1261","2010-10-22 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("7583","1261","2010-10-29 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7584","1262","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7585","1262","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7586","1262","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7587","1262","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7588","1262","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7589","1262","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7590","1263","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7591","1263","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7592","1263","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7593","1263","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7594","1263","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7595","1263","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7596","1264","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7597","1264","2010-09-30 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7598","1264","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7599","1264","2010-10-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7600","1264","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7601","1264","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7602","1265","2010-09-24 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7603","1265","2010-10-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7604","1265","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7605","1265","2010-10-15 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7606","1265","2010-10-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7607","1265","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7608","1266","2010-09-23 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("7609","1266","2010-09-30 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7610","1266","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7611","1266","2010-10-14 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("7612","1266","2010-10-21 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7613","1266","2010-10-28 00:00:00","2","3","0","0");
INSERT INTO tr_orderdetails VALUES("7614","1267","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7615","1267","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7616","1267","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7617","1267","2010-10-15 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7618","1267","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7619","1267","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7620","1268","2010-09-23 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7621","1268","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7622","1268","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7623","1268","2010-10-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7624","1268","2010-10-21 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("7625","1268","2010-10-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7626","1269","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7627","1269","2010-10-01 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7628","1269","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7629","1269","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7630","1269","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7631","1269","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7632","1270","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7633","1270","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7634","1270","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7635","1270","2010-10-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7636","1270","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7637","1270","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7638","1271","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7639","1271","2010-10-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7640","1271","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7641","1271","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7642","1271","2010-10-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7643","1271","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7644","1272","2010-09-24 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7645","1272","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7646","1272","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7647","1272","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7648","1272","2010-10-22 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("7649","1272","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7650","1273","2010-09-23 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7651","1273","2010-09-30 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7652","1273","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7653","1273","2010-10-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7654","1273","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7655","1273","2010-10-28 00:00:00","11","2","12","75");
INSERT INTO tr_orderdetails VALUES("7656","1274","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7657","1274","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7658","1274","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7659","1274","2010-10-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7660","1274","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7661","1274","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7662","1275","2010-09-24 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7663","1275","2010-10-01 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7664","1275","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7668","1276","2010-09-24 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7669","1276","2010-10-01 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7670","1276","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7671","1276","2010-10-15 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7672","1276","2010-10-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7673","1276","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7674","1277","2010-09-24 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("7675","1277","2010-10-01 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7676","1277","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7677","1277","2010-10-15 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7678","1277","2010-10-22 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7679","1277","2010-10-29 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7680","1278","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7681","1278","2010-10-01 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7682","1278","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7683","1278","2010-10-15 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7684","1278","2010-10-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7685","1278","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7686","1279","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7687","1279","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7688","1279","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7689","1279","2010-10-15 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7690","1279","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7691","1279","2010-10-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7692","1280","2010-09-24 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7693","1280","2010-10-01 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7694","1280","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7695","1280","2010-10-15 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7696","1280","2010-10-22 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7697","1280","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7698","1281","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7699","1281","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7700","1281","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7701","1281","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7702","1281","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7703","1281","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7704","1282","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7705","1282","2010-10-01 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7706","1282","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7707","1282","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7708","1282","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7709","1282","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7710","1283","2010-09-24 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7711","1283","2010-10-01 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7712","1283","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7713","1283","2010-10-15 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7714","1283","2010-10-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7715","1283","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7716","1284","2010-09-24 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7717","1284","2010-10-01 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7718","1284","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7719","1284","2010-10-15 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7720","1284","2010-10-22 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7721","1284","2010-10-29 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7722","1285","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7723","1285","2010-10-01 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7724","1285","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7725","1285","2010-10-15 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7726","1285","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7727","1285","2010-10-29 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7728","1286","2010-09-24 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7729","1286","2010-10-01 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7730","1286","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7731","1286","2010-10-15 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7732","1286","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7733","1286","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7734","1287","2010-09-24 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7735","1287","2010-10-01 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7736","1287","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7737","1287","2010-10-15 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7738","1287","2010-10-22 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7739","1287","2010-10-29 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7740","1288","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7741","1288","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7742","1288","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7743","1288","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7744","1288","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7745","1288","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7746","1289","2010-09-24 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7747","1289","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7748","1289","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7749","1289","2010-10-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7750","1289","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7751","1289","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7752","1290","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7753","1290","2010-10-01 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7754","1290","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7755","1290","2010-10-15 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7756","1290","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7757","1290","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7758","1291","2010-09-24 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7759","1291","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7760","1291","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7761","1291","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7762","1291","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7763","1292","2010-09-24 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("7764","1292","2010-10-01 00:00:00","3","3","0","0");
INSERT INTO tr_orderdetails VALUES("7765","1292","2010-10-07 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("7766","1292","2010-10-15 00:00:00","3","3","0","0");
INSERT INTO tr_orderdetails VALUES("7767","1292","2010-10-22 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("7768","1292","2010-10-29 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("7769","1293","2010-10-01 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7770","1293","2010-10-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7771","1293","2010-10-15 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7772","1293","2010-10-22 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7773","1293","2010-10-29 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7774","1294","2010-09-24 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7775","1294","2010-10-01 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7776","1294","2010-10-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7777","1294","2010-10-15 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7778","1294","2010-10-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7779","1294","2010-10-29 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7780","1295","2010-09-24 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7781","1295","2010-10-01 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7782","1295","2010-10-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7783","1295","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7784","1295","2010-10-22 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7785","1295","2010-10-29 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7786","1296","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7787","1296","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7788","1296","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7789","1296","2010-10-15 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7790","1296","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7791","1296","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7792","1297","2010-09-24 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7793","1297","2010-10-01 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7794","1297","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7795","1297","2010-10-15 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7796","1297","2010-10-22 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7797","1297","2010-10-29 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7798","1298","2010-09-24 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7799","1298","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7800","1298","2010-10-07 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7801","1298","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7802","1298","2010-10-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7803","1298","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7804","1299","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7805","1299","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7806","1299","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7807","1299","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7808","1299","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7809","1299","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7810","1300","2010-09-24 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7811","1300","2010-10-01 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7812","1300","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7813","1300","2010-10-15 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7814","1300","2010-10-22 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7815","1300","2010-10-29 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7822","1302","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7823","1302","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7824","1302","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7825","1302","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7826","1302","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7827","1302","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7828","1303","2010-09-24 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7829","1303","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7830","1303","2010-10-07 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7831","1303","2010-10-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7832","1303","2010-10-22 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("7833","1303","2010-10-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7834","1304","2010-09-24 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7835","1304","2010-10-01 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7836","1304","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7837","1304","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7838","1304","2010-10-22 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7839","1304","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7840","1305","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7841","1305","2010-10-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7842","1305","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7843","1305","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7844","1305","2010-10-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7845","1305","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7846","1306","2010-09-24 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7847","1306","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7848","1306","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7849","1306","2010-10-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7850","1306","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7851","1306","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7852","1307","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7853","1307","2010-10-01 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7854","1307","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7855","1307","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7856","1307","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7857","1307","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7858","1308","2010-09-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7861","1311","2010-09-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7862","1312","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7863","1312","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7864","1312","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7865","1312","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7866","1312","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7867","1312","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7868","1313","2010-09-24 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7869","1313","2010-10-01 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7870","1313","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7871","1313","2010-10-15 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7872","1313","2010-10-22 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7873","1313","2010-10-29 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7874","1314","2010-09-24 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7875","1314","2010-10-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7876","1314","2010-10-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7877","1314","2010-10-15 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7878","1314","2010-10-22 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7879","1314","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7880","1315","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7881","1315","2010-10-01 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7882","1315","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7883","1315","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7884","1315","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7885","1315","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7886","1316","2010-09-24 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7887","1316","2010-10-01 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7888","1316","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7889","1316","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7890","1316","2010-10-22 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7891","1316","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7892","1317","2010-09-24 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7893","1317","2010-10-01 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7894","1317","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7895","1317","2010-10-15 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7896","1317","2010-10-22 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7897","1317","2010-10-29 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7898","1318","2010-09-24 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7899","1318","2010-10-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7900","1318","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7901","1318","2010-10-15 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7902","1318","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7903","1318","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7904","1319","2010-09-24 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7905","1319","2010-10-01 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7906","1319","2010-10-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7907","1319","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7908","1319","2010-10-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7909","1319","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("7910","1320","2010-09-24 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7911","1320","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7912","1320","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7913","1320","2010-10-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7914","1320","2010-10-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7915","1320","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7916","1321","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7917","1321","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7918","1321","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7919","1321","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7920","1321","2010-10-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7921","1321","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7922","1322","2010-09-24 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7923","1322","2010-10-01 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7924","1322","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7925","1322","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7926","1322","2010-10-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7927","1322","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7928","1323","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7929","1323","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7930","1323","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7931","1323","2010-10-15 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7932","1323","2010-10-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7933","1323","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7934","1324","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7935","1324","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7936","1324","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7937","1324","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7938","1324","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7939","1324","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7940","1325","2010-09-24 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7941","1325","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7942","1325","2010-10-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7943","1325","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7944","1326","2010-09-24 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7945","1326","2010-10-01 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("7946","1326","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7947","1326","2010-10-15 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("7948","1326","2010-10-22 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7949","1326","2010-10-29 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7950","1327","2010-10-01 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7951","1327","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7952","1327","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7953","1327","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7954","1327","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7955","1328","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7956","1328","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7957","1328","2010-10-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7958","1329","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7959","1329","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7960","1329","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7961","1329","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7962","1329","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7963","1329","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7964","1330","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7965","1330","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7966","1330","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7967","1330","2010-10-15 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("7968","1330","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7969","1330","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7976","1332","2010-09-23 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7977","1332","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7978","1332","2010-10-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7979","1332","2010-10-14 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("7980","1332","2010-10-21 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("7981","1332","2010-10-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("7982","1333","2010-09-23 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7983","1333","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7984","1333","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7985","1334","2010-09-23 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7986","1334","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7987","1334","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7988","1334","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7989","1334","2010-10-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("7990","1334","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("7991","1335","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7992","1335","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7993","1335","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7994","1335","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7995","1335","2010-10-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("7996","1335","2010-10-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("7997","1336","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("7998","1336","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("7999","1336","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8000","1336","2010-10-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8001","1336","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8002","1336","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8003","1337","2010-09-23 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8004","1337","2010-09-30 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8005","1337","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8006","1337","2010-10-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8007","1337","2010-10-21 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8008","1337","2010-10-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8009","1338","2010-09-23 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8010","1338","2010-09-30 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8011","1338","2010-10-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8012","1338","2010-10-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8013","1338","2010-10-21 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("8014","1338","2010-10-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8015","1339","2010-09-23 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8016","1339","2010-09-30 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8017","1339","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8018","1339","2010-10-14 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8019","1339","2010-10-21 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8020","1339","2010-10-28 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8021","1340","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8022","1340","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8023","1340","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8024","1340","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8025","1340","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8026","1340","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8027","1341","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8028","1341","2010-10-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8029","1341","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8030","1341","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8031","1342","2010-09-23 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8032","1342","2010-09-30 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8033","1342","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8034","1342","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8035","1342","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8036","1342","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8037","1343","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8038","1343","2010-10-01 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8039","1343","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8040","1343","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8041","1343","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8042","1343","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8043","1344","2010-09-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8044","1344","2010-09-30 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8045","1344","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8046","1344","2010-10-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8047","1344","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8048","1344","2010-10-28 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8049","1345","2010-09-24 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8050","1345","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8051","1345","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8052","1345","2010-10-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8053","1345","2010-10-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8054","1345","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8055","1346","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8056","1346","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8057","1346","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8058","1346","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8059","1346","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8060","1346","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8061","1347","2010-09-24 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8062","1347","2010-10-01 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8063","1347","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8064","1347","2010-10-15 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("8065","1347","2010-10-22 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8066","1347","2010-10-29 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8067","1348","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8068","1348","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8069","1348","2010-10-07 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("8070","1348","2010-10-14 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8071","1348","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8072","1348","2010-10-28 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("8073","1349","2010-09-24 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8074","1349","2010-10-01 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8075","1349","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8076","1349","2010-10-15 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8077","1349","2010-10-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8078","1349","2010-10-29 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8079","1350","2010-09-23 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8080","1350","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8081","1350","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8082","1350","2010-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8083","1351","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8084","1351","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8085","1351","2010-10-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8086","1351","2010-10-28 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8087","1352","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8088","1352","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8089","1352","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8090","1352","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8091","1352","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8092","1352","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8093","1353","2010-09-23 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8094","1353","2010-09-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8095","1353","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8096","1353","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8097","1353","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8098","1353","2010-10-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8099","1354","2010-09-24 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8100","1354","2010-10-01 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8101","1354","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8102","1354","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8103","1354","2010-10-22 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8104","1354","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8105","1355","2010-09-23 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8106","1355","2010-09-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8107","1355","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8108","1355","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8109","1355","2010-10-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8110","1355","2010-10-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8111","1356","2010-09-24 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8112","1356","2010-10-01 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8113","1356","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8114","1356","2010-10-15 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("8115","1356","2010-10-22 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8116","1356","2010-10-29 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8117","1357","2010-09-24 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8118","1357","2010-10-01 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8119","1357","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8120","1357","2010-10-15 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8121","1357","2010-10-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8122","1357","2010-10-29 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8123","1358","2010-09-23 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("8124","1358","2010-09-30 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("8125","1358","2010-10-07 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("8126","1358","2010-10-14 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("8127","1358","2010-10-21 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("8128","1358","2010-10-28 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("8129","1359","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8130","1359","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8131","1359","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8132","1359","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8133","1359","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8134","1359","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8135","1360","2010-09-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8136","1360","2010-09-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8137","1360","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8138","1360","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8139","1360","2010-10-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8140","1360","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8141","1361","2010-10-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8142","1361","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8143","1362","2010-09-23 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8144","1362","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8145","1362","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8146","1362","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8147","1362","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8148","1362","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8149","1363","2010-09-24 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8150","1363","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8151","1363","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8152","1363","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8153","1363","2010-10-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8154","1363","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8155","1364","2010-09-23 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8156","1364","2010-09-30 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8157","1364","2010-10-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8158","1364","2010-10-14 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8159","1364","2010-10-21 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8160","1364","2010-10-28 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8161","1365","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8162","1365","2010-10-01 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8163","1365","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8164","1365","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8165","1365","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8166","1365","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8167","1366","2010-09-23 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8168","1366","2010-09-30 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8169","1366","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8170","1366","2010-10-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8171","1366","2010-10-21 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("8172","1366","2010-10-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8173","1367","2010-09-24 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8174","1367","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8175","1367","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8176","1368","2010-09-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8177","1368","2010-09-30 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8178","1368","2010-10-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8179","1368","2010-10-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8180","1368","2010-10-21 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8181","1368","2010-10-28 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8182","1369","2010-09-24 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8183","1369","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8184","1369","2010-10-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8186","1370","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8187","1370","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8188","1370","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8189","1370","2010-10-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8190","1370","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8191","1370","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8192","1371","2010-09-24 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8193","1371","2010-10-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8194","1371","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8195","1371","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8196","1371","2010-10-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8197","1371","2010-10-29 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8198","1372","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8199","1372","2010-09-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8200","1372","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8201","1372","2010-10-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8202","1372","2010-10-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8203","1372","2010-10-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8204","1373","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8205","1373","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8206","1373","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8207","1373","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8208","1373","2010-10-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8209","1373","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8210","1374","2010-09-23 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8211","1374","2010-09-30 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8212","1374","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8213","1374","2010-10-14 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8214","1374","2010-10-21 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8215","1374","2010-10-28 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8216","1375","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8217","1375","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8218","1375","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8219","1375","2010-10-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8220","1375","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8221","1375","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8222","1376","2010-09-24 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8223","1376","2010-10-01 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8224","1376","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8225","1376","2010-10-15 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8226","1376","2010-10-22 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8227","1376","2010-10-29 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8228","1377","2010-09-23 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8229","1377","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8230","1377","2010-10-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8231","1377","2010-10-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8232","1377","2010-10-21 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8233","1377","2010-10-28 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8234","1378","2010-09-24 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8235","1378","2010-10-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8236","1378","2010-10-07 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("8237","1378","2010-10-15 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8238","1378","2010-10-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8239","1378","2010-10-29 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("8240","1379","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8241","1379","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8242","1379","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8243","1379","2010-10-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8244","1379","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8245","1379","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8246","1380","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8247","1380","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8248","1380","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8249","1380","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8250","1380","2010-10-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8251","1380","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8252","1381","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8253","1381","2010-09-30 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8254","1381","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8255","1381","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8256","1381","2010-10-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8257","1381","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8258","1382","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8259","1382","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8260","1382","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8261","1382","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8262","1382","2010-10-21 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("8263","1382","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8264","1383","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8265","1383","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8266","1383","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8267","1383","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8268","1383","2010-10-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8269","1383","2010-10-28 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8270","1384","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8271","1384","2010-09-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8272","1384","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8273","1384","2010-10-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8274","1384","2010-10-21 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8275","1384","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8276","1385","2010-09-23 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8277","1385","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8278","1385","2010-10-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8279","1385","2010-10-14 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8280","1385","2010-10-21 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8281","1385","2010-10-28 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8282","1386","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8283","1386","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8284","1386","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8285","1386","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8286","1386","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8287","1386","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8288","1387","2010-09-24 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8289","1387","2010-10-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8290","1387","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8291","1387","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8292","1387","2010-10-22 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8293","1387","2010-10-29 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8294","1388","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8295","1388","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8296","1388","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8297","1388","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8298","1388","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8299","1388","2010-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8300","1389","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8301","1389","2010-09-30 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8302","1389","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8303","1389","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8304","1389","2010-10-21 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8305","1389","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8306","1390","2010-09-24 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("8307","1390","2010-10-01 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8308","1390","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8309","1390","2010-10-15 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("8310","1390","2010-10-22 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8311","1390","2010-10-29 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8312","1391","2010-09-23 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8313","1391","2010-09-30 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("8314","1391","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8315","1391","2010-10-14 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8316","1391","2010-10-21 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8317","1391","2010-10-28 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8318","1392","2010-09-24 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8319","1392","2010-10-01 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8320","1392","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8321","1392","2010-10-15 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8322","1392","2010-10-22 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8323","1392","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8324","1393","2010-09-23 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8325","1393","2010-09-30 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8326","1393","2010-10-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8327","1393","2010-10-14 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8328","1393","2010-10-21 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8329","1393","2010-10-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8330","1394","2010-09-24 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8336","1395","2010-09-24 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8337","1395","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8338","1395","2010-10-29 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8339","1396","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8340","1396","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8341","1396","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8342","1397","2010-09-23 00:00:00","78","1","0","0");
INSERT INTO tr_orderdetails VALUES("8343","1397","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8344","1397","2010-10-07 00:00:00","78","1","0","0");
INSERT INTO tr_orderdetails VALUES("8345","1397","2010-10-14 00:00:00","78","1","0","0");
INSERT INTO tr_orderdetails VALUES("8346","1397","2010-10-21 00:00:00","78","1","0","0");
INSERT INTO tr_orderdetails VALUES("8347","1397","2010-10-28 00:00:00","78","1","0","0");
INSERT INTO tr_orderdetails VALUES("8348","1398","2010-09-24 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8349","1398","2010-10-01 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8350","1398","2010-10-07 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("8351","1398","2010-10-15 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8352","1398","2010-10-22 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8353","1398","2010-10-29 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8354","1399","2010-09-23 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8355","1399","2010-09-30 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8356","1399","2010-10-07 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("8357","1399","2010-10-14 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8358","1399","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8359","1399","2010-10-28 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8360","1400","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8361","1400","2010-09-30 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8362","1400","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8363","1400","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8364","1400","2010-10-21 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8365","1400","2010-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8366","1401","2010-09-24 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8367","1401","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8368","1401","2010-10-07 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8369","1401","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8370","1401","2010-10-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8371","1401","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8372","1402","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8373","1402","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8374","1402","2010-10-07 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8375","1402","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8376","1402","2010-10-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8377","1402","2010-10-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8378","1403","2010-09-24 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8379","1403","2010-10-01 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8380","1403","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8381","1403","2010-10-15 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8382","1403","2010-10-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8383","1403","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8384","1404","2010-09-24 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8385","1404","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8386","1404","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8387","1404","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8388","1404","2010-10-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8389","1404","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8390","1405","2010-09-24 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8391","1405","2010-10-01 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8392","1405","2010-10-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8393","1405","2010-10-15 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8394","1405","2010-10-22 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8395","1405","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8396","1406","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8397","1406","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8398","1406","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8399","1406","2010-10-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8400","1406","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8401","1406","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8402","1407","2010-09-23 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8403","1407","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8404","1407","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8405","1407","2010-10-14 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8406","1407","2010-10-21 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8407","1407","2010-10-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8408","1408","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8409","1408","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8410","1408","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8411","1408","2010-10-14 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8412","1408","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8413","1408","2010-10-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8414","1409","2010-09-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8415","1409","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8416","1409","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8417","1409","2010-10-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8418","1409","2010-10-21 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8419","1409","2010-10-28 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8420","1410","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8421","1410","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8422","1410","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8423","1410","2010-10-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8424","1410","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8425","1410","2010-10-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8426","1411","2010-09-23 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8427","1411","2010-09-30 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("8428","1411","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8429","1411","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8430","1411","2010-10-21 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("8431","1411","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8432","1412","2010-09-23 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8433","1412","2010-09-30 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8434","1412","2010-10-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8435","1412","2010-10-14 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8436","1412","2010-10-21 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8437","1412","2010-10-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8438","1413","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8439","1413","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8440","1413","2010-10-07 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("8441","1413","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8442","1413","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8443","1413","2010-10-28 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("8444","1414","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8445","1414","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8446","1414","2010-10-07 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("8447","1414","2010-10-14 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8448","1414","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8449","1415","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8450","1415","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8451","1415","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8452","1416","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8453","1416","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8454","1416","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8455","1416","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8456","1416","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8457","1416","2010-10-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8458","1417","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8459","1417","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8460","1417","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8461","1417","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8462","1417","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8463","1417","2010-10-28 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8464","1418","2010-09-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8465","1418","2010-09-30 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8466","1418","2010-10-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8467","1418","2010-10-14 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8468","1418","2010-10-21 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8469","1418","2010-10-28 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8470","1419","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8471","1419","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8472","1419","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8473","1419","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8474","1419","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8475","1419","2010-10-28 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("8476","1420","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8477","1420","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8478","1420","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8479","1420","2010-10-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8480","1420","2010-10-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8481","1420","2010-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8482","1421","2010-09-23 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8483","1421","2010-09-30 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8484","1421","2010-10-07 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8485","1421","2010-10-14 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8486","1421","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8487","1421","2010-10-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8488","1422","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8489","1422","2010-09-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8490","1422","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8491","1422","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8492","1422","2010-10-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8493","1422","2010-10-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8494","1423","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8495","1423","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8496","1423","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8497","1423","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8498","1423","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8499","1423","2010-10-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8500","1424","2010-09-23 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8501","1424","2010-09-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8502","1424","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8503","1424","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8504","1424","2010-10-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8505","1424","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8506","1425","2010-09-30 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8507","1425","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8508","1425","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8509","1425","2010-10-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8510","1425","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8511","1426","2010-09-23 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8512","1426","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8513","1426","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8514","1426","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8515","1426","2010-10-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8516","1426","2010-10-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8517","1427","2010-09-23 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8518","1427","2010-09-30 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8519","1427","2010-10-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8520","1427","2010-10-14 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8521","1427","2010-10-21 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8522","1427","2010-10-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8523","1428","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8524","1428","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8525","1428","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8526","1428","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8527","1428","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8528","1428","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8529","1429","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8530","1429","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8531","1429","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8532","1429","2010-10-14 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8533","1429","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8534","1429","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8535","1430","2010-09-23 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8536","1430","2010-09-30 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8537","1430","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8538","1430","2010-10-14 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8539","1430","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8540","1430","2010-10-28 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8541","1431","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8542","1431","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8543","1431","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8544","1431","2010-10-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8545","1431","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8546","1431","2010-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8547","1432","2010-09-23 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8548","1432","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8549","1432","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8550","1432","2010-10-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8551","1432","2010-10-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8552","1432","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8553","1433","2010-09-23 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8554","1433","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8555","1433","2010-10-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8556","1434","2010-09-23 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8557","1434","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8558","1434","2010-10-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8559","1435","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8560","1435","2010-09-30 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8561","1435","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8562","1435","2010-10-14 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("8563","1435","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8564","1435","2010-10-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8565","1436","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8566","1436","2010-09-30 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("8567","1436","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8568","1436","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8569","1436","2010-10-21 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("8570","1436","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8571","1437","2010-09-23 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8572","1437","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8573","1437","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8574","1437","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8575","1437","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8576","1437","2010-10-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8577","1438","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8578","1438","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8579","1438","2010-10-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8580","1438","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8581","1438","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8582","1439","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8583","1439","2010-09-30 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8584","1439","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8585","1439","2010-10-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8586","1439","2010-10-21 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8587","1439","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8588","1440","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8589","1440","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8590","1440","2010-10-07 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("8591","1441","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8592","1441","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8593","1441","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8594","1441","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8595","1441","2010-10-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8596","1441","2010-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8597","1442","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8598","1442","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8599","1442","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8600","1442","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8601","1442","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8602","1442","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8603","1443","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8604","1443","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8605","1443","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8606","1443","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8607","1443","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8608","1443","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8609","1444","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8610","1444","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8611","1444","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8612","1444","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8613","1444","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8614","1444","2010-10-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8615","1445","2010-09-23 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8616","1445","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8617","1445","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8618","1446","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8619","1446","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8620","1446","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8621","1446","2010-10-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8622","1446","2010-10-21 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8623","1446","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8624","1447","2010-09-23 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8625","1447","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8626","1447","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8627","1447","2010-10-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8628","1447","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8629","1447","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8630","1448","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8631","1448","2010-09-30 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8632","1448","2010-10-07 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8633","1448","2010-10-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8634","1448","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8635","1448","2010-10-28 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8636","1449","2010-09-23 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8637","1449","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8638","1449","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8639","1449","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8640","1449","2010-10-21 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8641","1449","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8642","1450","2010-09-23 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8643","1450","2010-09-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8644","1450","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8645","1450","2010-10-14 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8646","1450","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8647","1450","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8648","1451","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8649","1451","2010-09-30 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8650","1451","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8651","1451","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8652","1451","2010-10-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8653","1451","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8654","1452","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8655","1452","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8656","1452","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8657","1452","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8658","1452","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8659","1452","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8660","1453","2010-09-24 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8661","1453","2010-10-01 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8662","1453","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8663","1453","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8664","1453","2010-10-22 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8665","1453","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8666","1454","2010-09-24 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8667","1454","2010-10-01 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8668","1454","2010-10-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8669","1454","2010-10-15 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8670","1454","2010-10-22 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8671","1454","2010-10-29 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8672","1455","2010-09-23 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8673","1455","2010-09-30 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8674","1455","2010-10-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8675","1455","2010-10-14 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8676","1455","2010-10-21 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8677","1455","2010-10-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8678","1456","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8679","1456","2010-10-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8680","1456","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8681","1456","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8682","1457","2010-09-23 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8683","1457","2010-09-30 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8684","1457","2010-10-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8685","1457","2010-10-14 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8686","1457","2010-10-21 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8687","1457","2010-10-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8688","1458","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8689","1458","2010-10-01 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("8690","1458","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8691","1458","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8692","1459","2010-09-24 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("8693","1459","2010-10-01 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8694","1459","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8695","1459","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8696","1459","2010-10-22 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8697","1459","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8698","1460","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8699","1460","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8700","1460","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8701","1460","2010-10-14 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("8702","1461","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8703","1461","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8704","1461","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8705","1461","2010-10-15 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8706","1461","2010-10-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8707","1461","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8708","1462","2010-09-23 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8709","1462","2010-09-30 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8710","1463","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8711","1463","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8712","1463","2010-10-07 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8713","1463","2010-10-15 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8714","1463","2010-10-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8715","1463","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8716","1464","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8717","1464","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8718","1464","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8719","1464","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8720","1464","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8721","1464","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8722","1465","2010-09-23 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8723","1465","2010-09-30 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8724","1465","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8725","1465","2010-10-14 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8726","1465","2010-10-21 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8727","1465","2010-10-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8728","1466","2010-09-24 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8729","1466","2010-10-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8730","1466","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8731","1466","2010-10-15 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8732","1466","2010-10-22 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8733","1466","2010-10-29 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8734","1467","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8735","1467","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8736","1467","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8737","1467","2010-10-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8738","1467","2010-10-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8739","1467","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8740","1468","2010-09-24 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8741","1468","2010-10-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8742","1468","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8743","1468","2010-10-15 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8744","1468","2010-10-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8745","1468","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8746","1469","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8752","1470","2010-09-24 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("8753","1470","2010-10-01 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("8754","1470","2010-10-07 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("8755","1470","2010-10-15 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("8756","1470","2010-10-22 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("8757","1470","2010-10-29 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("8758","1471","2010-09-24 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8759","1471","2010-10-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8760","1471","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8761","1471","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8762","1471","2010-10-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8764","1472","2010-09-24 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8765","1472","2010-10-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8766","1472","2010-10-29 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8767","1473","2010-09-24 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8768","1473","2010-10-01 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8769","1473","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8770","1473","2010-10-15 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8771","1473","2010-10-22 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8772","1473","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8773","1474","2010-09-24 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8774","1474","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8775","1474","2010-10-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8776","1475","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8777","1475","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8778","1475","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8779","1475","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8780","1475","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8781","1475","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8794","1478","2010-09-24 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8795","1478","2010-10-01 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8796","1478","2010-10-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8797","1478","2010-10-15 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8798","1478","2010-10-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8799","1478","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8800","1479","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8801","1479","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8802","1479","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8803","1479","2010-10-15 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8804","1479","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8805","1479","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8806","1480","2010-09-24 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8807","1480","2010-10-01 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8808","1480","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8809","1480","2010-10-15 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8810","1480","2010-10-22 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8811","1480","2010-10-29 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8812","1481","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8813","1481","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8814","1481","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8815","1481","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8816","1481","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8817","1481","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8818","1482","2010-09-24 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8819","1482","2010-10-07 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8820","1482","2010-10-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8821","1483","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8822","1483","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8823","1483","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8824","1483","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8825","1483","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8826","1483","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8827","1484","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8828","1484","2010-10-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8829","1485","2010-09-24 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8830","1485","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8831","1485","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8832","1485","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8833","1485","2010-10-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8834","1485","2010-10-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8835","1486","2010-09-24 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8836","1486","2010-10-01 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8837","1486","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8838","1486","2010-10-15 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8839","1486","2010-10-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8840","1486","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8841","1487","2010-09-24 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8842","1487","2010-10-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8843","1487","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8844","1487","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8845","1487","2010-10-22 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8846","1487","2010-10-29 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("8847","1488","2010-09-24 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8848","1488","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8849","1488","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8850","1488","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8851","1488","2010-10-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8852","1488","2010-10-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8853","1489","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8854","1489","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8855","1489","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8856","1489","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8857","1489","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8858","1489","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8865","1491","2010-09-24 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8866","1491","2010-10-01 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8867","1491","2010-10-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8868","1491","2010-10-15 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8869","1491","2010-10-22 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8870","1491","2010-10-29 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8871","1492","2010-09-24 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8872","1492","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8873","1492","2010-10-07 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8874","1492","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8875","1492","2010-10-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8876","1492","2010-10-29 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("8877","1493","2010-09-24 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8878","1493","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8879","1493","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8880","1493","2010-10-15 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8881","1493","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8882","1493","2010-10-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8883","1494","2010-09-24 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8884","1494","2010-10-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8885","1494","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8886","1494","2010-10-15 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8887","1494","2010-10-22 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8888","1494","2010-10-29 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8889","1495","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8890","1495","2010-10-01 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8891","1495","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8892","1495","2010-10-15 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("8893","1495","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8894","1495","2010-10-29 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8895","1496","2010-09-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8896","1496","2010-09-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8897","1496","2010-09-27 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8898","1496","2010-09-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8899","1496","2010-10-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8900","1496","2010-10-06 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("8901","1496","2010-10-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8902","1496","2010-10-27 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8903","1497","2010-09-20 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8904","1497","2010-09-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8905","1497","2010-09-24 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8906","1497","2010-09-27 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8907","1497","2010-09-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8908","1497","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8909","1497","2010-10-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8910","1497","2010-10-06 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8911","1497","2010-10-13 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8912","1497","2010-10-15 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8913","1497","2010-10-18 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8914","1497","2010-10-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8915","1497","2010-10-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8916","1497","2010-10-25 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8917","1497","2010-10-27 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8918","1497","2010-10-29 00:00:00","37","1","0","0");
INSERT INTO tr_orderdetails VALUES("8919","1498","2010-09-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8920","1498","2010-09-24 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8921","1498","2010-10-04 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8922","1498","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8923","1498","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8924","1499","2010-09-22 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8925","1499","2010-09-29 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8926","1499","2010-10-06 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8927","1499","2010-10-13 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8928","1499","2010-10-20 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8929","1499","2010-10-27 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("8930","1500","2010-09-20 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8931","1500","2010-09-27 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8932","1500","2010-10-04 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8933","1500","2010-10-18 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8934","1500","2010-10-25 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8935","1501","2010-09-20 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8936","1501","2010-09-22 00:00:00","25","2","0","0");
INSERT INTO tr_orderdetails VALUES("8937","1501","2010-09-24 00:00:00","29","1","0","0");
INSERT INTO tr_orderdetails VALUES("8938","1501","2010-09-27 00:00:00","27","1","0","0");
INSERT INTO tr_orderdetails VALUES("8939","1501","2010-09-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8940","1501","2010-10-01 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8941","1501","2010-10-04 00:00:00","40","1","0","0");
INSERT INTO tr_orderdetails VALUES("8942","1501","2010-10-06 00:00:00","25","2","0","0");
INSERT INTO tr_orderdetails VALUES("8943","1501","2010-10-13 00:00:00","29","1","0","0");
INSERT INTO tr_orderdetails VALUES("8944","1501","2010-10-15 00:00:00","27","2","0","0");
INSERT INTO tr_orderdetails VALUES("8945","1501","2010-10-18 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8946","1501","2010-10-20 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("8947","1501","2010-10-22 00:00:00","40","1","0","0");
INSERT INTO tr_orderdetails VALUES("8948","1501","2010-10-25 00:00:00","25","1","0","0");
INSERT INTO tr_orderdetails VALUES("8949","1501","2010-10-27 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8950","1501","2010-10-29 00:00:00","40","1","0","0");
INSERT INTO tr_orderdetails VALUES("8951","1502","2010-09-20 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8952","1502","2010-09-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8953","1502","2010-09-24 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8954","1502","2010-09-27 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8955","1502","2010-09-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8956","1502","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8957","1502","2010-10-04 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8958","1502","2010-10-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8959","1502","2010-10-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8960","1502","2010-10-15 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8961","1502","2010-10-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8962","1502","2010-10-20 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8963","1502","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8964","1502","2010-10-25 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8965","1502","2010-10-27 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8966","1502","2010-10-29 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8967","1503","2010-09-20 00:00:00","1","2","12","75");
INSERT INTO tr_orderdetails VALUES("8968","1503","2010-09-27 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("8969","1503","2010-10-04 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("8970","1503","2010-10-18 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("8971","1503","2010-10-25 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("8972","1504","2010-09-20 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8973","1504","2010-09-27 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8974","1504","2010-10-04 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8975","1504","2010-10-18 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8976","1504","2010-10-25 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8977","1505","2010-09-20 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8978","1505","2010-09-27 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8979","1505","2010-10-04 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8980","1505","2010-10-18 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8981","1505","2010-10-25 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8982","1506","2010-09-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8983","1506","2010-09-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8984","1506","2010-10-06 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8985","1506","2010-10-13 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8986","1506","2010-10-20 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8987","1506","2010-10-27 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8988","1507","2010-09-20 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8989","1507","2010-09-24 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8990","1507","2010-09-27 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8991","1507","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8992","1507","2010-10-04 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8993","1507","2010-10-06 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("8994","1508","2010-09-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("8995","1508","2010-10-04 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("8996","1508","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("8997","1508","2010-10-27 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("8998","1509","2010-09-22 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("8999","1509","2010-09-29 00:00:00","2","3","0","0");
INSERT INTO tr_orderdetails VALUES("9000","1509","2010-10-06 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("9001","1509","2010-10-13 00:00:00","53","3","0","0");
INSERT INTO tr_orderdetails VALUES("9002","1509","2010-10-20 00:00:00","1","3","0","0");
INSERT INTO tr_orderdetails VALUES("9003","1509","2010-10-27 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("9004","1510","2010-09-20 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9005","1510","2010-09-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9006","1510","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9007","1510","2010-09-27 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9008","1510","2010-09-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9009","1510","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9010","1510","2010-10-04 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9011","1510","2010-10-06 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9012","1510","2010-10-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9013","1510","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9014","1510","2010-10-18 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9015","1510","2010-10-20 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9016","1510","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9017","1510","2010-10-25 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9018","1510","2010-10-27 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9019","1510","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9020","1511","2010-09-20 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9021","1511","2010-09-27 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9022","1511","2010-10-04 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9023","1511","2010-10-18 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9024","1511","2010-10-25 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9025","1512","2010-09-29 00:00:00","3","2","0","75");
INSERT INTO tr_orderdetails VALUES("9026","1512","2010-10-13 00:00:00","11","2","0","75");
INSERT INTO tr_orderdetails VALUES("9027","1512","2010-10-27 00:00:00","5","2","0","75");
INSERT INTO tr_orderdetails VALUES("9028","1513","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9029","1513","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9030","1513","2010-10-07 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9031","1513","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9032","1513","2010-10-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9033","1513","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9034","1514","2010-09-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9035","1514","2010-10-27 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9036","1515","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9037","1515","2010-10-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9038","1515","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9039","1515","2010-10-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9040","1515","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9041","1515","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9042","1516","2010-09-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9043","1516","2010-10-13 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9044","1516","2010-10-27 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9045","1517","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9046","1517","2010-10-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9047","1517","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9048","1517","2010-10-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9049","1517","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9050","1517","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9051","1518","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9052","1518","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9053","1518","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9054","1518","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9055","1518","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9056","1518","2010-10-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9057","1519","2010-09-29 00:00:00","1","2","13","76");
INSERT INTO tr_orderdetails VALUES("9058","1519","2010-10-13 00:00:00","3","2","12","75");
INSERT INTO tr_orderdetails VALUES("9059","1520","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9060","1520","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9061","1520","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9062","1520","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9063","1520","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9064","1520","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9065","1521","2010-09-29 00:00:00","3","2","13","77");
INSERT INTO tr_orderdetails VALUES("9066","1521","2010-10-13 00:00:00","4","2","20","75");
INSERT INTO tr_orderdetails VALUES("9067","1521","2010-10-27 00:00:00","1","2","12","76");
INSERT INTO tr_orderdetails VALUES("9068","1522","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9069","1522","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9070","1522","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9071","1522","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9072","1522","2010-10-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9073","1522","2010-10-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9074","1523","2010-09-29 00:00:00","4","2","12","76");
INSERT INTO tr_orderdetails VALUES("9075","1523","2010-10-13 00:00:00","11","2","13","76");
INSERT INTO tr_orderdetails VALUES("9076","1523","2010-10-27 00:00:00","4","2","20","76");
INSERT INTO tr_orderdetails VALUES("9077","1524","2010-09-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9078","1524","2010-10-27 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9079","1525","2010-09-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9080","1525","2010-10-13 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9081","1525","2010-10-27 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9082","1526","2010-09-29 00:00:00","3","2","12","76");
INSERT INTO tr_orderdetails VALUES("9083","1526","2010-10-13 00:00:00","11","2","13","76");
INSERT INTO tr_orderdetails VALUES("9084","1526","2010-10-27 00:00:00","5","2","20","76");
INSERT INTO tr_orderdetails VALUES("9085","1527","2010-09-29 00:00:00","1","6","20","77");
INSERT INTO tr_orderdetails VALUES("9086","1527","2010-10-13 00:00:00","3","6","21","77");
INSERT INTO tr_orderdetails VALUES("9087","1527","2010-10-27 00:00:00","11","6","22","77");
INSERT INTO tr_orderdetails VALUES("9088","1528","2010-09-22 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9089","1528","2010-09-28 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9090","1528","2010-10-06 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9091","1528","2010-10-12 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9092","1528","2010-10-20 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9093","1528","2010-10-26 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9095","1529","2010-09-22 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9097","1529","2010-10-06 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9098","1529","2010-10-12 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9099","1529","2010-10-20 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9100","1529","2010-10-26 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("9101","1530","2010-09-28 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9102","1531","2010-09-24 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9103","1531","2010-10-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9104","1531","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9105","1531","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9106","1531","2010-10-22 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9107","1531","2010-10-29 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("9108","1532","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9109","1532","2010-10-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9110","1532","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9111","1532","2010-10-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9112","1532","2010-10-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9113","1532","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9114","1533","2010-09-24 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9115","1533","2010-10-01 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9116","1533","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9117","1533","2010-10-15 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9118","1533","2010-10-22 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9119","1533","2010-10-29 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9120","1534","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9121","1534","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9122","1534","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9123","1534","2010-10-15 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9124","1534","2010-10-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9125","1534","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9126","1535","2010-09-24 00:00:00","3","3","0","0");
INSERT INTO tr_orderdetails VALUES("9127","1535","2010-10-01 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("9128","1535","2010-10-07 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("9129","1535","2010-10-15 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("9130","1535","2010-10-22 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("9131","1535","2010-10-29 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("9132","1536","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9133","1536","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9134","1536","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9135","1536","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9136","1536","2010-10-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9137","1536","2010-10-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9138","1537","2010-09-24 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9139","1537","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9140","1537","2010-10-07 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9141","1537","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9142","1537","2010-10-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9143","1537","2010-10-29 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9144","1538","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9145","1538","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9146","1538","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9147","1538","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9148","1538","2010-10-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9149","1538","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9150","1539","2010-09-24 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9151","1539","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9152","1539","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9153","1539","2010-10-15 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9154","1539","2010-10-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9155","1539","2010-10-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9156","1540","2010-09-29 00:00:00","11","2","13","76");
INSERT INTO tr_orderdetails VALUES("9157","1540","2010-10-13 00:00:00","4","2","14","76");
INSERT INTO tr_orderdetails VALUES("9158","1540","2010-10-27 00:00:00","3","2","13","76");
INSERT INTO tr_orderdetails VALUES("9159","1541","2010-09-29 00:00:00","11","2","13","75");
INSERT INTO tr_orderdetails VALUES("9160","1541","2010-10-13 00:00:00","4","2","14","75");
INSERT INTO tr_orderdetails VALUES("9161","1541","2010-10-27 00:00:00","5","2","12","75");
INSERT INTO tr_orderdetails VALUES("9162","1542","2010-09-29 00:00:00","2","1","20","76");
INSERT INTO tr_orderdetails VALUES("9163","1542","2010-10-13 00:00:00","3","1","13","76");
INSERT INTO tr_orderdetails VALUES("9164","1542","2010-10-27 00:00:00","4","1","14","76");
INSERT INTO tr_orderdetails VALUES("9165","1543","2010-09-29 00:00:00","11","2","13","75");
INSERT INTO tr_orderdetails VALUES("9166","1543","2010-10-13 00:00:00","4","2","14","75");
INSERT INTO tr_orderdetails VALUES("9167","1543","2010-10-27 00:00:00","2","2","13","75");
INSERT INTO tr_orderdetails VALUES("9168","1544","2010-09-29 00:00:00","2","2","12","77");
INSERT INTO tr_orderdetails VALUES("9169","1544","2010-10-13 00:00:00","4","2","20","77");
INSERT INTO tr_orderdetails VALUES("9170","1544","2010-10-27 00:00:00","3","2","12","77");
INSERT INTO tr_orderdetails VALUES("9171","1545","2010-09-29 00:00:00","3","1","20","75");
INSERT INTO tr_orderdetails VALUES("9172","1545","2010-10-13 00:00:00","11","1","20","75");
INSERT INTO tr_orderdetails VALUES("9173","1545","2010-10-27 00:00:00","3","1","20","75");
INSERT INTO tr_orderdetails VALUES("9174","1546","2010-09-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9175","1546","2010-10-13 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9176","1546","2010-10-27 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9177","1547","2010-09-29 00:00:00","4","1","20","77");
INSERT INTO tr_orderdetails VALUES("9178","1547","2010-10-13 00:00:00","4","1","13","76");
INSERT INTO tr_orderdetails VALUES("9179","1547","2010-10-27 00:00:00","4","1","20","77");
INSERT INTO tr_orderdetails VALUES("9180","1548","2010-09-29 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9181","1548","2010-10-13 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9182","1548","2010-10-27 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9183","1549","2010-09-29 00:00:00","5","3","13","77");
INSERT INTO tr_orderdetails VALUES("9184","1549","2010-10-13 00:00:00","3","3","13","77");
INSERT INTO tr_orderdetails VALUES("9185","1549","2010-10-27 00:00:00","4","3","13","77");
INSERT INTO tr_orderdetails VALUES("9186","1550","2010-09-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9187","1550","2010-10-13 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9188","1550","2010-10-27 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9189","1551","2010-09-29 00:00:00","4","2","13","76");
INSERT INTO tr_orderdetails VALUES("9190","1551","2010-10-13 00:00:00","4","2","13","76");
INSERT INTO tr_orderdetails VALUES("9191","1551","2010-10-27 00:00:00","4","2","13","76");
INSERT INTO tr_orderdetails VALUES("9192","1552","2010-09-29 00:00:00","11","3","20","76");
INSERT INTO tr_orderdetails VALUES("9193","1552","2010-10-13 00:00:00","53","3","20","76");
INSERT INTO tr_orderdetails VALUES("9194","1552","2010-10-27 00:00:00","5","3","20","76");
INSERT INTO tr_orderdetails VALUES("9195","1553","2010-09-29 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9196","1553","2010-10-13 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9197","1553","2010-10-27 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9198","1554","2010-09-29 00:00:00","3","2","13","76");
INSERT INTO tr_orderdetails VALUES("9199","1554","2010-10-13 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9200","1554","2010-10-27 00:00:00","2","2","20","76");
INSERT INTO tr_orderdetails VALUES("9201","1555","2010-09-29 00:00:00","2","1","13","76");
INSERT INTO tr_orderdetails VALUES("9202","1555","2010-10-13 00:00:00","4","1","20","76");
INSERT INTO tr_orderdetails VALUES("9203","1555","2010-10-27 00:00:00","3","1","13","76");
INSERT INTO tr_orderdetails VALUES("9204","1556","2010-09-29 00:00:00","4","5","20","76");
INSERT INTO tr_orderdetails VALUES("9205","1556","2010-10-13 00:00:00","4","5","20","76");
INSERT INTO tr_orderdetails VALUES("9206","1556","2010-10-27 00:00:00","4","5","20","76");
INSERT INTO tr_orderdetails VALUES("9207","1557","2010-09-29 00:00:00","4","5","13","76");
INSERT INTO tr_orderdetails VALUES("9208","1557","2010-10-13 00:00:00","4","5","13","76");
INSERT INTO tr_orderdetails VALUES("9209","1557","2010-10-27 00:00:00","4","5","13","76");
INSERT INTO tr_orderdetails VALUES("9210","1558","2010-09-29 00:00:00","1","2","13","77");
INSERT INTO tr_orderdetails VALUES("9211","1558","2010-10-13 00:00:00","3","2","20","76");
INSERT INTO tr_orderdetails VALUES("9212","1558","2010-10-27 00:00:00","4","2","12","77");
INSERT INTO tr_orderdetails VALUES("9213","1559","2010-09-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9214","1559","2010-10-13 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9215","1559","2010-10-27 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9216","1560","2010-09-29 00:00:00","81","2","13","76");
INSERT INTO tr_orderdetails VALUES("9217","1560","2010-10-13 00:00:00","81","2","13","76");
INSERT INTO tr_orderdetails VALUES("9218","1560","2010-10-27 00:00:00","81","2","13","76");
INSERT INTO tr_orderdetails VALUES("9219","1561","2010-09-29 00:00:00","11","3","12","76");
INSERT INTO tr_orderdetails VALUES("9220","1561","2010-10-13 00:00:00","53","3","12","76");
INSERT INTO tr_orderdetails VALUES("9221","1561","2010-10-27 00:00:00","11","3","12","76");
INSERT INTO tr_orderdetails VALUES("9222","1562","2010-09-29 00:00:00","3","2","12","76");
INSERT INTO tr_orderdetails VALUES("9223","1562","2010-10-13 00:00:00","1","2","12","76");
INSERT INTO tr_orderdetails VALUES("9224","1562","2010-10-27 00:00:00","4","2","12","76");
INSERT INTO tr_orderdetails VALUES("9225","1563","2010-09-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9226","1563","2010-10-13 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9227","1563","2010-10-27 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9228","1564","2010-09-29 00:00:00","3","2","13","76");
INSERT INTO tr_orderdetails VALUES("9229","1564","2010-10-13 00:00:00","4","2","20","77");
INSERT INTO tr_orderdetails VALUES("9230","1564","2010-10-27 00:00:00","2","2","13","75");
INSERT INTO tr_orderdetails VALUES("9231","1565","2010-09-29 00:00:00","4","2","20","77");
INSERT INTO tr_orderdetails VALUES("9232","1565","2010-10-13 00:00:00","2","2","13","75");
INSERT INTO tr_orderdetails VALUES("9233","1565","2010-10-27 00:00:00","3","2","12","76");
INSERT INTO tr_orderdetails VALUES("9234","1566","2010-09-29 00:00:00","4","2","13","75");
INSERT INTO tr_orderdetails VALUES("9235","1566","2010-10-13 00:00:00","4","2","20","75");
INSERT INTO tr_orderdetails VALUES("9236","1566","2010-10-29 00:00:00","4","2","13","75");
INSERT INTO tr_orderdetails VALUES("9237","1567","2010-09-29 00:00:00","1","2","13","77");
INSERT INTO tr_orderdetails VALUES("9238","1567","2010-10-13 00:00:00","3","2","13","77");
INSERT INTO tr_orderdetails VALUES("9239","1567","2010-10-27 00:00:00","4","2","20","77");
INSERT INTO tr_orderdetails VALUES("9240","1568","2010-09-29 00:00:00","11","2","20","77");
INSERT INTO tr_orderdetails VALUES("9241","1568","2010-10-13 00:00:00","4","2","20","75");
INSERT INTO tr_orderdetails VALUES("9242","1568","2010-10-27 00:00:00","3","2","20","75");
INSERT INTO tr_orderdetails VALUES("9243","1569","2010-09-29 00:00:00","4","2","13","76");
INSERT INTO tr_orderdetails VALUES("9244","1569","2010-10-13 00:00:00","4","2","13","76");
INSERT INTO tr_orderdetails VALUES("9245","1569","2010-10-27 00:00:00","3","2","13","76");
INSERT INTO tr_orderdetails VALUES("9246","1570","2010-09-29 00:00:00","5","2","13","75");
INSERT INTO tr_orderdetails VALUES("9247","1570","2010-10-13 00:00:00","4","2","12","77");
INSERT INTO tr_orderdetails VALUES("9248","1570","2010-10-27 00:00:00","3","2","20","76");
INSERT INTO tr_orderdetails VALUES("9249","1571","2010-09-29 00:00:00","2","2","12","75");
INSERT INTO tr_orderdetails VALUES("9250","1571","2010-10-13 00:00:00","3","2","20","76");
INSERT INTO tr_orderdetails VALUES("9251","1571","2010-10-27 00:00:00","5","2","13","77");
INSERT INTO tr_orderdetails VALUES("9252","1572","2010-09-29 00:00:00","1","2","12","76");
INSERT INTO tr_orderdetails VALUES("9253","1572","2010-10-13 00:00:00","3","2","13","77");
INSERT INTO tr_orderdetails VALUES("9254","1572","2010-10-27 00:00:00","1","2","20","76");
INSERT INTO tr_orderdetails VALUES("9255","1573","2010-09-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9256","1573","2010-10-13 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9257","1573","2010-10-27 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9258","1574","2010-09-29 00:00:00","4","2","13","75");
INSERT INTO tr_orderdetails VALUES("9259","1574","2010-10-13 00:00:00","3","2","13","75");
INSERT INTO tr_orderdetails VALUES("9260","1575","2010-09-23 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9261","1575","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9262","1575","2010-10-07 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9263","1575","2010-10-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9264","1575","2010-10-21 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9265","1575","2010-10-28 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9266","1576","2010-09-23 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9267","1576","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9268","1576","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9269","1576","2010-10-14 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9270","1576","2010-10-21 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9271","1576","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9272","1577","2010-09-23 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9273","1577","2010-09-30 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9274","1577","2010-10-07 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9275","1577","2010-10-14 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9276","1577","2010-10-21 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9277","1577","2010-10-28 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9278","1578","2010-09-23 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9279","1578","2010-09-30 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9280","1578","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9281","1578","2010-10-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9282","1578","2010-10-21 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9283","1578","2010-10-28 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9284","1579","2010-09-23 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9285","1579","2010-09-30 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9286","1579","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9287","1579","2010-10-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9288","1579","2010-10-21 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9289","1579","2010-10-28 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9290","1580","2010-09-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9291","1580","2010-09-30 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9292","1580","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9293","1580","2010-10-14 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("9294","1580","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9295","1580","2010-10-28 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9296","1581","2010-09-23 00:00:00","2","3","0","0");
INSERT INTO tr_orderdetails VALUES("9297","1581","2010-09-30 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("9298","1581","2010-10-07 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("9299","1581","2010-10-14 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("9300","1581","2010-10-21 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("9301","1581","2010-10-28 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("9302","1582","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9303","1582","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9304","1582","2010-10-07 00:00:00","78","1","0","0");
INSERT INTO tr_orderdetails VALUES("9305","1582","2010-10-14 00:00:00","78","1","0","0");
INSERT INTO tr_orderdetails VALUES("9306","1582","2010-10-21 00:00:00","78","1","0","0");
INSERT INTO tr_orderdetails VALUES("9307","1582","2010-10-28 00:00:00","78","1","0","0");
INSERT INTO tr_orderdetails VALUES("9308","1583","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9309","1583","2010-09-30 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9310","1583","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9311","1583","2010-10-14 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9312","1583","2010-10-21 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9313","1583","2010-10-28 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9314","1584","2010-09-30 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("9315","1584","2010-10-14 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9316","1585","2010-09-23 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9317","1585","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9318","1585","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9319","1585","2010-10-21 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9320","1585","2010-10-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9321","1586","2010-09-23 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("9322","1586","2010-09-30 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9323","1586","2010-10-07 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9324","1586","2010-10-14 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("9325","1586","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9326","1586","2010-10-28 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("9327","1587","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9328","1587","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9329","1587","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9330","1587","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9331","1587","2010-10-21 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9332","1587","2010-10-28 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9333","1588","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9334","1588","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9335","1588","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9336","1588","2010-10-14 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9337","1588","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9338","1588","2010-10-28 00:00:00","47","1","0","0");
INSERT INTO tr_orderdetails VALUES("9339","1589","2010-09-24 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9340","1589","2010-10-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9341","1589","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9342","1589","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9343","1589","2010-10-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9344","1589","2010-10-29 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9345","1590","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9346","1590","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9347","1590","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9348","1590","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9349","1590","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9350","1590","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9351","1591","2010-09-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9352","1591","2010-09-24 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9353","1591","2010-09-27 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9354","1591","2010-09-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9355","1591","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9356","1591","2010-10-04 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9357","1591","2010-10-06 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9358","1591","2010-10-13 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9359","1591","2010-10-18 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9360","1591","2010-10-20 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9361","1591","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9362","1591","2010-10-25 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9363","1591","2010-10-27 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9364","1591","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9365","1592","2010-09-24 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9366","1592","2010-10-01 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9367","1592","2010-10-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9368","1592","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9369","1592","2010-10-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9370","1592","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9371","1593","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9372","1593","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9373","1593","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9374","1593","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9375","1593","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9376","1594","2010-09-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9377","1594","2010-09-24 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9378","1594","2010-09-27 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9379","1594","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9380","1595","2010-09-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9381","1595","2010-09-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9382","1595","2010-10-06 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9383","1595","2010-10-12 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9384","1595","2010-10-20 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9385","1595","2010-10-26 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9386","1596","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9387","1596","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9388","1596","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9389","1596","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9390","1596","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9391","1596","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9392","1597","2010-09-24 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9393","1597","2010-10-01 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9394","1597","2010-10-07 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9395","1597","2010-10-15 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("9396","1597","2010-10-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9397","1597","2010-10-29 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("9398","1598","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9399","1598","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9400","1598","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9401","1598","2010-10-15 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9402","1598","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9403","1598","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9404","1599","2010-09-24 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9405","1599","2010-10-01 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9406","1599","2010-10-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9407","1599","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9408","1599","2010-10-22 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9409","1599","2010-10-29 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9410","1600","2010-09-24 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9411","1600","2010-10-01 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9412","1600","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9413","1600","2010-10-15 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9414","1600","2010-10-22 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("9415","1600","2010-10-29 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9416","1601","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9417","1601","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9418","1601","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9419","1601","2010-10-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9420","1601","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9421","1601","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9422","1602","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9423","1602","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9424","1602","2010-10-07 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("9425","1602","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9426","1602","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9427","1602","2010-10-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9428","1603","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9429","1603","2010-10-01 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9430","1603","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9431","1603","2010-10-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9432","1603","2010-10-22 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("9433","1603","2010-10-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9434","1604","2010-09-24 00:00:00","80","1","0","0");
INSERT INTO tr_orderdetails VALUES("9435","1604","2010-10-01 00:00:00","80","1","0","0");
INSERT INTO tr_orderdetails VALUES("9436","1604","2010-10-07 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("9437","1604","2010-10-15 00:00:00","80","1","0","0");
INSERT INTO tr_orderdetails VALUES("9438","1604","2010-10-22 00:00:00","80","1","0","0");
INSERT INTO tr_orderdetails VALUES("9439","1604","2010-10-29 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("9440","1605","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9441","1605","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9442","1605","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9443","1605","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9444","1605","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9445","1605","2010-10-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9446","1606","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9452","1607","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9453","1607","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9454","1607","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9455","1607","2010-10-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9456","1607","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9457","1607","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9458","1608","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9459","1608","2010-10-01 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9460","1608","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9461","1608","2010-10-15 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9462","1608","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9463","1608","2010-10-29 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9464","1609","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9465","1609","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9466","1609","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9467","1609","2010-10-15 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9468","1609","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9469","1609","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9470","1610","2010-09-24 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9471","1610","2010-10-01 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("9472","1610","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9473","1610","2010-10-15 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("9474","1610","2010-10-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9475","1610","2010-10-29 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("9476","1611","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9477","1611","2010-10-01 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9478","1611","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9479","1611","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9480","1611","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9481","1611","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9482","1612","2010-09-24 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("9483","1612","2010-10-01 00:00:00","3","3","0","0");
INSERT INTO tr_orderdetails VALUES("9484","1612","2010-10-07 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("9485","1612","2010-10-15 00:00:00","4","3","0","0");
INSERT INTO tr_orderdetails VALUES("9486","1612","2010-10-22 00:00:00","3","3","0","0");
INSERT INTO tr_orderdetails VALUES("9487","1612","2010-10-29 00:00:00","11","3","0","0");
INSERT INTO tr_orderdetails VALUES("9488","1613","2010-09-24 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9489","1613","2010-10-01 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9490","1613","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9491","1613","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9492","1613","2010-10-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9493","1613","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9494","1614","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9495","1614","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9496","1614","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9497","1614","2010-10-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9498","1614","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9499","1615","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9500","1615","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9501","1615","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9502","1615","2010-10-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9503","1615","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9504","1615","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9505","1616","2010-09-24 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9506","1616","2010-10-01 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9507","1616","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9508","1616","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9509","1616","2010-09-22 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9510","1616","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9511","1617","2010-09-24 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9512","1617","2010-10-01 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9513","1617","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9514","1617","2010-10-15 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9515","1617","2010-10-22 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("9516","1617","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9517","1618","2010-09-24 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9518","1618","2010-10-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9519","1618","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9520","1618","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9521","1618","2010-10-22 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("9522","1618","2010-10-29 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("9523","1619","2010-09-24 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9524","1619","2010-10-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9525","1619","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9526","1619","2010-10-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9527","1619","2010-10-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9528","1619","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9529","1620","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9530","1620","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9531","1620","2010-10-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9532","1621","2010-09-24 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9533","1621","2010-10-01 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9534","1621","2010-10-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9535","1621","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9536","1621","2010-10-22 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9537","1621","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9538","1622","2010-09-24 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9539","1622","2010-10-01 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9540","1622","2010-10-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9541","1622","2010-10-15 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9542","1622","2010-10-22 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9543","1622","2010-10-29 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9544","1623","2010-09-24 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9545","1623","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9546","1623","2010-10-07 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("9547","1623","2010-10-15 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9548","1623","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9549","1623","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9550","1624","2010-09-24 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9551","1624","2010-10-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9552","1624","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9553","1624","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9554","1624","2010-10-22 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9555","1624","2010-10-29 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9556","1625","2010-09-24 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9557","1625","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9558","1625","2010-10-07 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9559","1625","2010-10-15 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9560","1625","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9561","1625","2010-10-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9562","1626","2010-09-23 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9563","1626","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9564","1626","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9565","1626","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9566","1626","2010-10-21 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9567","1626","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9568","1627","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9569","1627","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9570","1627","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9571","1627","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9572","1627","2010-10-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9573","1627","2010-10-29 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9574","1628","2010-09-24 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9575","1628","2010-10-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9576","1628","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9577","1628","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9578","1628","2010-10-22 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9579","1628","2010-10-29 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("9580","1629","2010-09-24 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9581","1629","2010-10-01 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("9582","1629","2010-10-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9583","1629","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9584","1629","2010-10-22 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9585","1629","2010-10-29 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9586","1630","2010-09-24 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9587","1630","2010-10-01 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9588","1630","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9589","1630","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9590","1630","2010-10-22 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9591","1630","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9592","1631","2010-09-24 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9593","1631","2010-10-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9594","1631","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9595","1631","2010-10-15 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9596","1631","2010-10-22 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("9597","1631","2010-10-29 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9598","1632","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9599","1632","2010-10-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9600","1632","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9601","1632","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9602","1632","2010-10-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9603","1632","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9604","1633","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9605","1633","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9606","1633","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9607","1634","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9608","1634","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9613","1635","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9614","1635","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9615","1635","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9616","1635","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9617","1635","2010-10-22 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("9618","1635","2010-10-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9619","1636","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9620","1636","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9621","1636","2010-10-07 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("9622","1636","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9623","1636","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9624","1636","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9625","1637","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9626","1637","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9627","1637","2010-10-22 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9628","1638","2010-09-24 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9629","1638","2010-10-01 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9630","1638","2010-10-07 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9631","1638","2010-10-15 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9632","1638","2010-10-22 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9633","1638","2010-10-29 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9634","1639","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9635","1639","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9636","1639","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9637","1639","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9638","1639","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9639","1639","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9640","1640","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9641","1640","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9642","1640","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9643","1640","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9644","1640","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9645","1640","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9646","1641","2010-09-24 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9647","1641","2010-10-01 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9648","1641","2010-10-07 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("9649","1641","2010-10-15 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9650","1641","2010-10-22 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9651","1641","2010-10-29 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9652","1642","2010-09-24 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9653","1642","2010-10-01 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9654","1642","2010-10-07 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9655","1642","2010-10-15 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9656","1642","2010-10-22 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9657","1642","2010-10-29 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9658","1643","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9659","1644","2010-09-24 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9660","1644","2010-10-01 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9661","1644","2010-10-07 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("9662","1644","2010-10-15 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9663","1644","2010-10-22 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9664","1644","2010-10-29 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("9665","1645","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9666","1645","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9667","1645","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9668","1645","2010-10-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9669","1645","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9670","1646","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9671","1646","2010-10-01 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9672","1646","2010-10-07 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9673","1646","2010-10-15 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9674","1646","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9675","1646","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9676","1647","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9677","1647","2010-10-01 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9678","1647","2010-10-07 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9679","1647","2010-10-15 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9680","1647","2010-10-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9681","1647","2010-10-29 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9682","1648","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9683","1648","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9684","1648","2010-10-07 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9685","1648","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9686","1648","2010-10-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9687","1648","2010-10-29 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9688","1649","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9689","1649","2010-10-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9690","1649","2010-10-07 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("9691","1649","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9692","1649","2010-10-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9693","1649","2010-10-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9694","1650","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9695","1650","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9696","1650","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9697","1651","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9698","1651","2010-10-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9699","1651","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9700","1651","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9701","1651","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9702","1651","2010-10-29 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9703","1652","2010-09-24 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9704","1653","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9705","1653","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9706","1653","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9707","1653","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9708","1653","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9709","1653","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9710","1654","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9711","1654","2010-10-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9712","1654","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9713","1654","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9714","1654","2010-10-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9715","1654","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9716","1655","2010-09-24 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9717","1655","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9718","1655","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9719","1655","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9720","1655","2010-10-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9721","1655","2010-10-29 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("9722","1656","2010-09-24 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9723","1656","2010-10-07 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9724","1656","2010-10-29 00:00:00","83","2","0","0");
INSERT INTO tr_orderdetails VALUES("9725","1657","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9726","1657","2010-10-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9727","1657","2010-10-07 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("9728","1657","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9729","1657","2010-10-22 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9730","1657","2010-10-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9731","1658","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9732","1658","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9733","1658","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9734","1658","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9735","1658","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9736","1658","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9737","1659","2010-09-24 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9738","1659","2010-10-01 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9739","1659","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9740","1659","2010-10-15 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("9741","1659","2010-10-22 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9742","1659","2010-10-29 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9743","1660","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9744","1660","2010-10-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9745","1661","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9746","1661","2010-10-01 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9747","1661","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9748","1661","2010-10-15 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9749","1661","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9750","1661","2010-10-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9751","1662","2010-10-07 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9752","1663","2010-09-24 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9753","1663","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9754","1663","2010-10-07 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9755","1663","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9756","1663","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9757","1663","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9758","1664","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9759","1664","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9760","1664","2010-10-07 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9761","1664","2010-10-15 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9762","1664","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9763","1664","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9764","1665","2010-09-23 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9765","1666","2010-09-29 00:00:00","2","2","13","76");
INSERT INTO tr_orderdetails VALUES("9766","1666","2010-10-13 00:00:00","3","2","20","76");
INSERT INTO tr_orderdetails VALUES("9767","1666","2010-10-27 00:00:00","4","2","13","76");
INSERT INTO tr_orderdetails VALUES("9768","1667","2010-09-29 00:00:00","1","2","12","76");
INSERT INTO tr_orderdetails VALUES("9769","1667","2010-10-13 00:00:00","3","2","13","76");
INSERT INTO tr_orderdetails VALUES("9770","1667","2010-10-27 00:00:00","11","2","20","76");
INSERT INTO tr_orderdetails VALUES("9771","1668","2010-09-29 00:00:00","5","2","20","76");
INSERT INTO tr_orderdetails VALUES("9772","1668","2010-10-13 00:00:00","4","2","13","77");
INSERT INTO tr_orderdetails VALUES("9773","1668","2010-10-27 00:00:00","5","2","13","75");
INSERT INTO tr_orderdetails VALUES("9774","1669","2010-09-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9775","1669","2010-10-13 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9776","1669","2010-10-27 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9777","1670","2010-09-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9778","1670","2010-10-13 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9779","1671","2010-09-29 00:00:00","1","2","13","77");
INSERT INTO tr_orderdetails VALUES("9780","1671","2010-10-13 00:00:00","4","2","12","76");
INSERT INTO tr_orderdetails VALUES("9781","1671","2010-10-27 00:00:00","5","2","20","76");
INSERT INTO tr_orderdetails VALUES("9782","1672","2010-09-29 00:00:00","11","2","13","76");
INSERT INTO tr_orderdetails VALUES("9783","1672","2010-10-13 00:00:00","4","2","13","76");
INSERT INTO tr_orderdetails VALUES("9784","1672","2010-10-27 00:00:00","2","2","13","76");
INSERT INTO tr_orderdetails VALUES("9785","1673","2010-09-29 00:00:00","4","2","20","76");
INSERT INTO tr_orderdetails VALUES("9786","1674","2010-09-24 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9787","1674","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9788","1675","2010-09-30 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9789","1675","2010-10-07 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9790","1675","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9791","1675","2010-10-21 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9792","1675","2010-10-28 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9793","1676","2010-09-30 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9794","1676","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9795","1676","2010-10-14 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9796","1676","2010-10-21 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9797","1676","2010-10-28 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9798","1677","2010-10-01 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9799","1677","2010-10-07 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9800","1677","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9801","1677","2010-10-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9802","1677","2010-10-29 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9803","1678","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9804","1678","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9805","1678","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9806","1678","2010-10-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9807","1678","2010-10-29 00:00:00","53","1","0","0");
INSERT INTO tr_orderdetails VALUES("9808","1679","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9809","1679","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9810","1679","2010-10-22 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9811","1679","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9812","1680","2010-09-29 00:00:00","4","2","12","76");
INSERT INTO tr_orderdetails VALUES("9813","1680","2010-10-13 00:00:00","1","2","12","76");
INSERT INTO tr_orderdetails VALUES("9814","1680","2010-10-27 00:00:00","4","2","12","76");
INSERT INTO tr_orderdetails VALUES("9815","1681","2010-09-29 00:00:00","53","2","13","76");
INSERT INTO tr_orderdetails VALUES("9816","1681","2010-10-13 00:00:00","5","2","20","77");
INSERT INTO tr_orderdetails VALUES("9817","1681","2010-10-27 00:00:00","5","2","13","75");
INSERT INTO tr_orderdetails VALUES("9818","1682","2010-09-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9819","1682","2010-10-13 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9820","1682","2010-10-27 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9821","1683","2010-09-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9822","1683","2010-10-13 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9823","1683","2010-10-27 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9824","1684","2010-09-29 00:00:00","1","2","13","76");
INSERT INTO tr_orderdetails VALUES("9825","1684","2010-10-13 00:00:00","2","2","20","76");
INSERT INTO tr_orderdetails VALUES("9826","1684","2010-10-27 00:00:00","3","2","13","76");
INSERT INTO tr_orderdetails VALUES("9827","1685","2010-09-29 00:00:00","11","2","20","77");
INSERT INTO tr_orderdetails VALUES("9828","1685","2010-10-13 00:00:00","2","2","20","77");
INSERT INTO tr_orderdetails VALUES("9829","1685","2010-10-27 00:00:00","11","2","20","77");
INSERT INTO tr_orderdetails VALUES("9830","1686","2010-09-29 00:00:00","11","2","20","76");
INSERT INTO tr_orderdetails VALUES("9831","1686","2010-10-13 00:00:00","2","2","20","76");
INSERT INTO tr_orderdetails VALUES("9832","1686","2010-10-27 00:00:00","11","2","20","76");
INSERT INTO tr_orderdetails VALUES("9833","1687","2010-09-29 00:00:00","1","2","12","76");
INSERT INTO tr_orderdetails VALUES("9834","1687","2010-10-13 00:00:00","3","2","12","76");
INSERT INTO tr_orderdetails VALUES("9835","1687","2010-10-27 00:00:00","4","2","12","76");
INSERT INTO tr_orderdetails VALUES("9836","1688","2010-09-29 00:00:00","2","2","12","75");
INSERT INTO tr_orderdetails VALUES("9837","1688","2010-10-13 00:00:00","3","2","12","75");
INSERT INTO tr_orderdetails VALUES("9838","1688","2010-10-27 00:00:00","2","2","12","75");
INSERT INTO tr_orderdetails VALUES("9839","1689","2010-09-29 00:00:00","1","2","13","77");
INSERT INTO tr_orderdetails VALUES("9840","1689","2010-10-13 00:00:00","3","2","20","77");
INSERT INTO tr_orderdetails VALUES("9841","1689","2010-10-27 00:00:00","3","2","13","77");
INSERT INTO tr_orderdetails VALUES("9842","1690","2010-09-29 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9843","1690","2010-10-13 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9844","1690","2010-10-27 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9845","1691","2010-09-29 00:00:00","4","2","13","77");
INSERT INTO tr_orderdetails VALUES("9846","1692","2010-09-29 00:00:00","11","3","12","76");
INSERT INTO tr_orderdetails VALUES("9847","1692","2010-10-13 00:00:00","1","3","13","76");
INSERT INTO tr_orderdetails VALUES("9848","1692","2010-10-27 00:00:00","4","3","20","76");
INSERT INTO tr_orderdetails VALUES("9849","1693","2010-09-29 00:00:00","11","2","12","76");
INSERT INTO tr_orderdetails VALUES("9850","1693","2010-10-13 00:00:00","1","2","13","76");
INSERT INTO tr_orderdetails VALUES("9851","1693","2010-10-27 00:00:00","4","2","20","76");
INSERT INTO tr_orderdetails VALUES("9852","1694","2010-09-29 00:00:00","2","2","12","76");
INSERT INTO tr_orderdetails VALUES("9853","1694","2010-10-13 00:00:00","5","2","13","76");
INSERT INTO tr_orderdetails VALUES("9854","1694","2010-10-27 00:00:00","3","2","12","77");
INSERT INTO tr_orderdetails VALUES("9855","1695","2010-09-28 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9856","1695","2010-10-06 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9857","1695","2010-10-12 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("9858","1695","2010-10-20 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("9859","1695","2010-10-26 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("9860","1696","2010-09-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9861","1696","2010-10-06 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("9862","1696","2010-10-12 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9863","1696","2010-10-20 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("9864","1696","2010-10-26 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9865","1697","2010-10-01 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9866","1698","2010-10-01 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9867","1699","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9868","1700","2010-10-06 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9869","1700","2010-10-12 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9870","1700","2010-10-20 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9871","1700","2010-10-26 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9872","1701","2010-10-01 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9873","1701","2010-10-07 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9874","1701","2010-10-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9875","1701","2010-10-29 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9876","1701","2010-10-29 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9877","1702","2010-10-01 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9878","1703","2010-10-07 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9879","1703","2010-10-14 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9880","1703","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("9881","1703","2010-10-28 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9882","1704","2010-10-13 00:00:00","1","1","0","0");
INSERT INTO tr_orderdetails VALUES("9883","1704","2010-10-27 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9884","1705","2010-10-04 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("9885","1705","2010-10-06 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9886","1705","2010-10-13 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("9887","1705","2010-10-18 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("9888","1705","2010-10-20 00:00:00","1","2","0","0");
INSERT INTO tr_orderdetails VALUES("9889","1705","2010-10-27 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("9890","1705","2010-10-29 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("9891","1706","2010-10-07 00:00:00","53","2","0","0");
INSERT INTO tr_orderdetails VALUES("9892","1706","2010-10-15 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("9893","1706","2010-10-22 00:00:00","11","2","0","0");
INSERT INTO tr_orderdetails VALUES("9894","1706","2010-10-29 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9896","1707","2010-10-07 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9897","1707","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9898","1707","2010-10-22 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9899","1707","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9900","1708","2010-10-07 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9901","1708","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9902","1708","2010-10-22 00:00:00","3","1","0","0");
INSERT INTO tr_orderdetails VALUES("9903","1708","2010-10-29 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9905","1709","2010-10-15 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9906","1709","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9907","1710","2010-10-13 00:00:00","5","2","13","76");
INSERT INTO tr_orderdetails VALUES("9908","1710","2010-10-27 00:00:00","4","1","0","0");
INSERT INTO tr_orderdetails VALUES("9909","1711","2010-10-13 00:00:00","53","2","13","77");
INSERT INTO tr_orderdetails VALUES("9910","1711","2010-10-27 00:00:00","2","2","13","77");
INSERT INTO tr_orderdetails VALUES("9911","1712","2010-10-13 00:00:00","2","2","12","76");
INSERT INTO tr_orderdetails VALUES("9912","1712","2010-10-27 00:00:00","1","2","12","76");
INSERT INTO tr_orderdetails VALUES("9913","1713","2010-10-13 00:00:00","5","2","13","77");
INSERT INTO tr_orderdetails VALUES("9914","1713","2010-10-27 00:00:00","5","2","13","77");
INSERT INTO tr_orderdetails VALUES("9915","1714","2010-10-13 00:00:00","4","2","13","77");
INSERT INTO tr_orderdetails VALUES("9916","1714","2010-10-27 00:00:00","5","2","13","77");
INSERT INTO tr_orderdetails VALUES("9917","1715","2010-10-15 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9918","1715","2010-10-22 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9919","1715","2010-10-29 00:00:00","11","1","0","0");
INSERT INTO tr_orderdetails VALUES("9920","1716","2010-11-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9921","1716","2010-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9922","1716","2010-11-19 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9923","1716","2010-11-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9924","1716","2010-12-03 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9925","1716","2010-12-10 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9926","1716","2010-12-17 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9927","1717","2010-11-05 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("9928","1717","2010-11-11 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("9929","1717","2010-11-19 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("9930","1717","2010-11-26 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("9931","1717","2010-12-03 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("9932","1717","2010-12-10 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("9933","1717","2010-12-17 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("9934","1718","2010-11-05 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9935","1718","2010-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9936","1718","2010-11-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("9937","1718","2010-11-26 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("9938","1718","2010-12-03 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("9939","1718","2010-12-10 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("9940","1718","2010-12-17 00:00:00","80","1","0","0");
INSERT INTO tr_orderdetails VALUES("9941","1719","2010-11-11 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("9942","1719","2010-12-17 00:00:00","34","2","0","0");
INSERT INTO tr_orderdetails VALUES("9943","1720","2010-11-05 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("9944","1720","2010-11-11 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("9945","1720","2010-11-19 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("9946","1720","2010-11-26 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("9947","1720","2010-12-03 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("9948","1720","2010-12-10 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("9949","1720","2010-12-17 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("9950","1721","2010-11-05 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("9951","1721","2010-12-03 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9952","1721","2010-12-10 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("9953","1721","2010-12-17 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("9954","1722","2010-11-05 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("9955","1722","2010-11-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9956","1722","2010-11-19 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("9957","1722","2010-11-26 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("9958","1722","2010-12-03 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9959","1722","2010-12-10 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("9960","1722","2010-12-17 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("9961","1723","2010-11-05 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("9962","1723","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("9963","1723","2010-11-19 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9964","1723","2010-11-26 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("9965","1723","2010-12-03 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("9966","1723","2010-12-10 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("9967","1723","2010-12-17 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9968","1724","2010-11-05 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("9969","1724","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("9970","1724","2010-11-19 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("9971","1724","2010-11-26 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("9972","1724","2010-12-03 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("9973","1724","2010-12-10 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("9974","1724","2010-12-17 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9975","1725","2010-11-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9976","1725","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("9977","1725","2010-11-19 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9978","1725","2010-11-26 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("9979","1725","2010-12-03 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("9980","1725","2010-12-10 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("9981","1725","2010-12-17 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("9982","1726","2010-11-05 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("9983","1726","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("9984","1726","2010-11-19 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9985","1726","2010-11-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("9986","1726","2010-12-03 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("9987","1726","2010-12-10 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("9988","1726","2010-12-17 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("9989","1727","2010-11-05 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("9990","1727","2010-11-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9991","1727","2010-11-19 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("9992","1727","2010-11-26 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("9993","1727","2010-12-03 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("9994","1727","2010-12-10 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("9995","1727","2010-12-17 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("9996","1728","2010-11-05 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("9997","1728","2010-11-11 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("9998","1728","2010-11-19 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("9999","1728","2010-11-26 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10000","1728","2010-12-03 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10001","1728","2010-12-10 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10002","1728","2010-12-17 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10003","1729","2010-11-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10004","1729","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10005","1729","2010-11-19 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10006","1729","2010-11-26 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10007","1729","2010-12-03 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10008","1729","2010-12-10 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10009","1729","2010-12-17 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10010","1730","2010-11-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10011","1730","2010-11-11 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10012","1730","2010-11-19 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10013","1730","2010-11-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10014","1730","2010-12-03 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10015","1730","2010-12-10 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10016","1730","2010-12-17 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10017","1731","2010-11-05 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10018","1731","2010-11-11 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10019","1731","2010-11-19 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10020","1731","2010-11-26 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10021","1731","2010-12-03 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10022","1731","2010-12-10 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10023","1731","2010-12-17 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10024","1732","2010-11-05 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10025","1732","2010-11-11 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10026","1732","2010-11-19 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10027","1732","2010-11-26 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10028","1732","2010-12-03 00:00:00","80","1","0","0");
INSERT INTO tr_orderdetails VALUES("10029","1732","2010-12-10 00:00:00","80","1","0","0");
INSERT INTO tr_orderdetails VALUES("10030","1732","2010-12-17 00:00:00","80","1","0","0");
INSERT INTO tr_orderdetails VALUES("10031","1733","2010-11-05 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10032","1733","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10033","1733","2010-11-19 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10034","1733","2010-11-26 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10035","1733","2010-12-03 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10036","1733","2010-12-10 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10037","1733","2010-12-17 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10038","1734","2010-11-05 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10039","1734","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10040","1734","2010-11-19 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10041","1734","2010-11-26 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10042","1734","2010-12-03 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10043","1734","2010-12-10 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10044","1734","2010-12-17 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10045","1735","2010-11-05 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10046","1735","2010-11-11 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10047","1735","2010-11-19 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10048","1735","2010-11-26 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10049","1735","2010-12-03 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10050","1735","2010-12-10 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10051","1735","2010-12-17 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10052","1736","2010-11-05 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10053","1736","2010-11-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10054","1736","2010-11-19 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10055","1736","2010-11-26 00:00:00","34","2","0","0");
INSERT INTO tr_orderdetails VALUES("10056","1736","2010-12-03 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10057","1736","2010-12-10 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10058","1736","2010-12-17 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10059","1737","2010-11-05 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10060","1737","2010-11-11 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10061","1737","2010-11-19 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10062","1737","2010-11-26 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10063","1737","2010-12-03 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10064","1737","2010-12-10 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10065","1737","2010-12-17 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10066","1738","2010-11-05 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10067","1738","2010-11-11 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10068","1738","2010-11-19 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10069","1738","2010-11-26 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10070","1738","2010-12-03 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10071","1738","2010-12-10 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10072","1738","2010-12-17 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10073","1739","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10074","1739","2010-11-26 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10075","1739","2010-12-10 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10076","1740","2010-11-05 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10077","1740","2010-11-11 00:00:00","78","1","0","0");
INSERT INTO tr_orderdetails VALUES("10078","1740","2010-11-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10079","1740","2010-11-26 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10080","1740","2010-12-03 00:00:00","78","1","0","0");
INSERT INTO tr_orderdetails VALUES("10081","1740","2010-12-10 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10082","1740","2010-12-17 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10083","1741","2010-11-05 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10084","1741","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10085","1741","2010-11-19 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10086","1741","2010-11-26 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10087","1741","2010-12-03 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10088","1741","2010-12-10 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10089","1741","2010-12-17 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10090","1742","2010-11-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10091","1742","2010-11-11 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10092","1742","2010-11-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10093","1742","2010-11-26 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10094","1742","2010-12-03 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10095","1742","2010-12-10 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10096","1742","2010-12-17 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10097","1743","2010-11-05 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10098","1743","2010-12-03 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10099","1743","2010-12-17 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10100","1744","2010-11-05 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10101","1744","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10102","1744","2010-11-19 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10103","1744","2010-11-26 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10104","1744","2010-12-03 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10105","1744","2010-12-10 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10106","1744","2010-12-17 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10107","1745","2010-11-05 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10108","1745","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10109","1745","2010-11-19 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10110","1745","2010-11-26 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10111","1745","2010-12-03 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10112","1745","2010-12-10 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10113","1745","2010-12-17 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10114","1746","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10115","1746","2010-11-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10116","1746","2010-12-17 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10117","1747","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10118","1747","2010-11-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10119","1747","2010-12-17 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10120","1748","2010-12-17 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10121","1749","2010-11-05 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10122","1749","2010-11-11 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10123","1749","2010-11-19 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10124","1749","2010-12-03 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10125","1749","2010-12-10 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10126","1749","2010-12-17 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10127","1750","2010-11-05 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10128","1750","2010-12-03 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10129","1751","2010-11-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10130","1752","2010-11-05 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10131","1752","2010-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10132","1752","2010-11-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10133","1752","2010-11-26 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10134","1752","2010-12-03 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10135","1752","2010-12-10 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10136","1752","2010-12-17 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10137","1753","2010-11-05 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10138","1753","2010-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10139","1753","2010-11-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10140","1753","2010-11-26 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10141","1753","2010-12-10 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10142","1754","2010-11-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10144","1755","2010-10-21 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("10145","1755","2010-10-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("10146","1756","2010-10-21 00:00:00","3","2","0","0");
INSERT INTO tr_orderdetails VALUES("10147","1756","2010-10-28 00:00:00","4","2","0","0");
INSERT INTO tr_orderdetails VALUES("10148","1757","2010-11-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10149","1757","2010-11-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10150","1757","2010-11-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10151","1757","2010-12-02 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10152","1757","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10153","1758","2010-11-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10154","1758","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10155","1758","2010-11-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10156","1758","2010-11-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10157","1758","2010-12-02 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10158","1758","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10159","1758","2010-12-16 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10160","1759","2010-11-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10161","1759","2010-11-11 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10162","1759","2010-11-18 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10163","1759","2010-11-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10164","1759","2010-12-02 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10165","1759","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10166","1759","2010-12-16 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10167","1760","2010-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10168","1760","2010-11-11 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10169","1760","2010-11-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10170","1760","2010-11-25 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10171","1760","2010-12-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10172","1760","2010-12-09 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10173","1760","2010-12-16 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10174","1761","2010-11-04 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10175","1761","2010-11-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10176","1761","2010-11-18 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10177","1761","2010-11-25 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10178","1761","2010-12-02 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10179","1761","2010-12-09 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10180","1761","2010-12-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10181","1762","2010-11-04 00:00:00","34","2","0","0");
INSERT INTO tr_orderdetails VALUES("10182","1762","2010-11-11 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10183","1762","2010-11-18 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10184","1762","2010-11-25 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10185","1762","2010-12-02 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10186","1762","2010-12-09 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10187","1762","2010-12-16 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10188","1763","2010-11-04 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10189","1763","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10190","1763","2010-11-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10191","1763","2010-11-25 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10192","1763","2010-12-02 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10193","1763","2010-12-09 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10194","1763","2010-12-16 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10195","1764","2010-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10196","1764","2010-11-18 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10197","1764","2010-11-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10198","1764","2010-12-16 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10199","1765","2010-11-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10200","1765","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10201","1765","2010-11-18 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10202","1765","2010-11-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10203","1765","2010-12-02 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10204","1765","2010-12-09 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10205","1765","2010-12-16 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10206","1766","2010-11-04 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10207","1766","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10208","1766","2010-11-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10209","1766","2010-11-25 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10210","1766","2010-12-02 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10211","1766","2010-12-09 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10212","1766","2010-12-16 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10213","1767","2010-11-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10214","1767","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10215","1767","2010-11-18 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10216","1767","2010-11-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10217","1767","2010-12-02 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10218","1767","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10219","1767","2010-12-16 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10220","1768","2010-11-04 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10221","1768","2010-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10222","1768","2010-11-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10223","1768","2010-12-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10224","1768","2010-12-16 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10225","1769","2010-11-04 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10226","1769","2010-11-11 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10227","1769","2010-11-18 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10228","1769","2010-11-25 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10229","1769","2010-12-02 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10230","1769","2010-12-09 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10231","1769","2010-12-16 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10232","1770","2010-11-04 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("10233","1770","2010-11-11 00:00:00","64","3","0","0");
INSERT INTO tr_orderdetails VALUES("10234","1770","2010-11-18 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("10235","1770","2010-11-25 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("10236","1770","2010-12-02 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("10237","1770","2010-12-09 00:00:00","64","3","0","0");
INSERT INTO tr_orderdetails VALUES("10238","1770","2010-12-16 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("10239","1771","2010-11-04 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10240","1771","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10241","1771","2010-11-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10242","1771","2010-11-25 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10243","1771","2010-12-02 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10244","1771","2010-12-09 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10245","1771","2010-12-16 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10246","1772","2010-11-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10247","1772","2010-11-11 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10248","1772","2010-11-18 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10249","1772","2010-11-25 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10250","1772","2010-12-02 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10251","1772","2010-12-09 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10252","1772","2010-12-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10253","1773","2010-11-04 00:00:00","34","2","0","0");
INSERT INTO tr_orderdetails VALUES("10254","1773","2010-11-11 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10255","1773","2010-11-18 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10256","1773","2010-11-25 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10257","1773","2010-12-02 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10258","1773","2010-12-09 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10259","1773","2010-12-16 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10260","1774","2010-11-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10261","1774","2010-11-11 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10262","1774","2010-11-18 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10263","1774","2010-11-25 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10264","1774","2010-12-02 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10265","1774","2010-12-09 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10266","1774","2010-12-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10267","1775","2010-11-04 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10268","1775","2010-11-11 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10269","1775","2010-11-18 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10270","1775","2010-11-25 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10271","1775","2010-12-02 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10272","1775","2010-12-09 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10273","1775","2010-12-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10274","1776","2010-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10275","1776","2010-11-11 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10276","1776","2010-11-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10277","1776","2010-11-25 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10278","1776","2010-12-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10279","1776","2010-12-09 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10280","1776","2010-12-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10281","1777","2010-11-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10285","1778","2010-11-04 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10286","1778","2010-11-11 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10287","1778","2010-11-18 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10288","1778","2010-11-25 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10289","1778","2010-12-02 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10290","1778","2010-12-09 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10291","1778","2010-12-16 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10292","1779","2010-11-04 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10293","1779","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10294","1779","2010-11-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10295","1779","2010-11-25 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10296","1779","2010-12-02 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10297","1779","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10298","1779","2010-12-16 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10299","1780","2010-11-04 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10300","1780","2010-11-11 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10301","1780","2010-11-18 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10302","1780","2010-11-25 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10306","1781","2010-11-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10307","1781","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10308","1781","2010-11-18 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10309","1781","2010-11-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10310","1781","2010-12-02 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10311","1781","2010-12-09 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10312","1781","2010-12-16 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10313","1782","2010-11-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10314","1782","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10315","1782","2010-11-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10316","1782","2010-11-25 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10317","1782","2010-12-02 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10318","1782","2010-12-09 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10319","1782","2010-12-16 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10320","1783","2010-11-04 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10321","1783","2010-11-11 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10322","1783","2010-11-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10323","1783","2010-11-25 00:00:00","82","1","0","0");
INSERT INTO tr_orderdetails VALUES("10324","1783","2010-12-02 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10325","1783","2010-12-09 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("10326","1783","2010-12-16 00:00:00","82","1","0","0");
INSERT INTO tr_orderdetails VALUES("10327","1784","2010-11-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10328","1784","2010-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10329","1784","2010-11-18 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10330","1784","2010-11-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10331","1784","2010-12-02 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("10332","1784","2010-12-09 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10333","1784","2010-12-16 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10334","1785","2010-11-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10335","1785","2010-11-11 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10336","1785","2010-11-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10337","1785","2010-11-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10338","1785","2010-12-02 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10339","1785","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10340","1785","2010-12-16 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10341","1786","2010-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10342","1786","2010-11-18 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10343","1786","2010-12-09 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10344","1787","2010-11-04 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10345","1787","2010-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10346","1787","2010-11-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10347","1787","2010-11-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10348","1787","2010-12-02 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10349","1787","2010-12-09 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10350","1787","2010-12-16 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10351","1788","2010-11-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10352","1788","2010-11-11 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10353","1788","2010-11-18 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10354","1788","2010-11-25 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10355","1788","2010-12-02 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10356","1788","2010-12-09 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10357","1788","2010-12-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10358","1789","2010-11-04 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10359","1789","2010-11-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10360","1789","2010-11-18 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10361","1789","2010-11-25 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10362","1789","2010-12-02 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10363","1789","2010-12-09 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10364","1789","2010-12-16 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10365","1790","2010-11-04 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10366","1790","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10367","1790","2010-11-18 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("10368","1790","2010-11-25 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10369","1790","2010-12-02 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10370","1790","2010-12-09 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10371","1790","2010-12-16 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10372","1791","2010-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10373","1791","2010-11-11 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10374","1791","2010-11-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10375","1791","2010-11-25 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10377","1791","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10378","1791","2010-12-16 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10379","1792","2010-11-04 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10380","1792","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10381","1792","2010-11-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10382","1792","2010-11-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10383","1792","2010-12-02 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10384","1792","2010-12-09 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10385","1792","2010-12-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10386","1793","2010-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10387","1793","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10388","1793","2010-11-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10389","1793","2010-11-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10390","1793","2010-12-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10391","1793","2010-12-09 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10392","1793","2010-12-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10393","1794","2010-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10394","1794","2010-11-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10395","1794","2010-11-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10396","1794","2010-12-02 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10397","1794","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10398","1794","2010-12-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10399","1795","2010-11-04 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10400","1795","2010-11-11 00:00:00","26","1","0","0");
INSERT INTO tr_orderdetails VALUES("10401","1795","2010-11-18 00:00:00","72","1","0","0");
INSERT INTO tr_orderdetails VALUES("10402","1795","2010-11-25 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10403","1795","2010-12-02 00:00:00","26","1","0","0");
INSERT INTO tr_orderdetails VALUES("10404","1795","2010-12-09 00:00:00","72","1","0","0");
INSERT INTO tr_orderdetails VALUES("10405","1795","2010-12-16 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10406","1796","2010-11-04 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10407","1796","2010-12-02 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10408","1797","2010-11-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10409","1797","2010-12-02 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10410","1798","2010-11-04 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10411","1798","2010-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10412","1798","2010-11-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10413","1798","2010-11-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10414","1798","2010-12-02 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10415","1798","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10416","1798","2010-12-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10417","1799","2010-11-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10418","1799","2010-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10419","1799","2010-11-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10421","1799","2010-12-02 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10422","1799","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10423","1799","2010-12-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10424","1800","2010-11-04 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10425","1800","2010-11-11 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10426","1800","2010-11-18 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10427","1800","2010-11-25 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10428","1800","2010-12-02 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10429","1800","2010-12-09 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10430","1800","2010-12-16 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10431","1801","2010-11-04 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10432","1801","2010-11-11 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10433","1801","2010-11-18 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10434","1801","2010-11-25 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10435","1801","2010-12-02 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10436","1801","2010-12-09 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10437","1801","2010-12-16 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10438","1802","2010-11-04 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10439","1802","2010-11-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10440","1802","2010-11-18 00:00:00","34","2","0","0");
INSERT INTO tr_orderdetails VALUES("10441","1802","2010-11-25 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10442","1802","2010-12-02 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10443","1802","2010-12-09 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10444","1802","2010-12-16 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10445","1803","2010-11-04 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10446","1803","2010-11-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10447","1803","2010-11-18 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10448","1803","2010-11-25 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10449","1803","2010-12-02 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10450","1803","2010-12-09 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10451","1803","2010-12-16 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10452","1804","2010-11-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10453","1804","2010-11-11 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10454","1804","2010-11-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10455","1804","2010-11-25 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10456","1804","2010-12-02 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10457","1804","2010-12-09 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10458","1804","2010-12-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10459","1805","2010-11-04 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("10460","1805","2010-11-11 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("10461","1805","2010-11-18 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("10462","1805","2010-11-25 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("10463","1805","2010-12-02 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("10464","1805","2010-12-09 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("10465","1805","2010-12-16 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("10466","1806","2010-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10467","1806","2010-11-11 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10468","1806","2010-11-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10469","1806","2010-11-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10470","1806","2010-12-02 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10471","1806","2010-12-09 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10472","1806","2010-12-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10473","1807","2010-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10474","1807","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10475","1807","2010-11-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10476","1807","2010-11-25 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10477","1807","2010-12-02 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10478","1807","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10479","1807","2010-12-16 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10480","1808","2010-11-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10481","1808","2010-11-18 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10482","1808","2010-12-02 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10483","1808","2010-12-16 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10484","1809","2010-11-04 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10485","1809","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10486","1809","2010-11-18 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10487","1809","2010-11-25 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10488","1809","2010-12-02 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10489","1809","2010-12-09 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10490","1809","2010-12-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10491","1810","2010-11-04 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10492","1810","2010-11-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10493","1810","2010-11-18 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10494","1810","2010-11-25 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10495","1810","2010-12-02 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10496","1810","2010-12-09 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10497","1810","2010-12-16 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10498","1811","2010-11-04 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10499","1811","2010-11-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10500","1811","2010-11-18 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10501","1811","2010-11-25 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10502","1811","2010-12-02 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10503","1811","2010-12-09 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10504","1811","2010-12-16 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10505","1812","2010-11-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10506","1812","2010-11-11 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10507","1812","2010-11-18 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10508","1812","2010-11-25 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10509","1812","2010-12-02 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10510","1812","2010-12-09 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10511","1812","2010-12-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10512","1813","2010-11-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10513","1813","2010-11-11 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10514","1813","2010-11-18 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10515","1813","2010-11-25 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10516","1813","2010-12-02 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10517","1813","2010-12-09 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10518","1813","2010-12-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10519","1814","2010-11-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10520","1814","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10521","1814","2010-11-18 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10522","1814","2010-11-25 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10523","1814","2010-12-02 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10524","1814","2010-12-09 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10525","1814","2010-12-16 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10526","1815","2010-11-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10527","1815","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10528","1815","2010-11-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10529","1815","2010-11-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10530","1815","2010-12-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10531","1815","2010-12-09 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10532","1815","2010-12-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10533","1816","2010-11-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10534","1816","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10535","1816","2010-11-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10536","1816","2010-11-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10537","1816","2010-12-02 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10538","1816","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10539","1816","2010-12-16 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10540","1817","2010-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10541","1817","2010-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10542","1817","2010-11-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10543","1817","2010-11-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10544","1817","2010-12-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10545","1817","2010-12-09 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10546","1817","2010-12-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10547","1818","2010-11-04 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10548","1818","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10549","1818","2010-11-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10550","1818","2010-11-25 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10551","1818","2010-12-02 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10552","1818","2010-12-09 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10553","1818","2010-12-16 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10554","1819","2010-11-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10555","1819","2010-11-11 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10556","1819","2010-11-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10557","1819","2010-11-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10558","1819","2010-12-02 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10559","1819","2010-12-09 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10560","1819","2010-12-16 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10561","1820","2010-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10562","1820","2010-11-11 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10563","1820","2010-11-18 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("10564","1820","2010-11-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10565","1820","2010-12-02 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10566","1820","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10567","1820","2010-12-16 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10568","1821","2010-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10569","1821","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10570","1821","2010-11-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10571","1821","2010-11-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10572","1821","2010-12-02 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10573","1821","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10574","1821","2010-12-16 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10575","1822","2010-11-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10576","1822","2010-11-11 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10577","1822","2010-11-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10578","1822","2010-11-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10579","1822","2010-12-02 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("10580","1822","2010-12-09 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10581","1822","2010-12-16 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10582","1823","2010-11-04 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10583","1823","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10584","1823","2010-11-18 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10585","1823","2010-11-25 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10586","1823","2010-12-02 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10587","1823","2010-12-09 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10588","1823","2010-12-16 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10589","1824","2010-11-04 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10590","1824","2010-11-11 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10591","1824","2010-11-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10592","1824","2010-11-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10593","1824","2010-12-02 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10594","1824","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10595","1824","2010-12-16 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10596","1825","2010-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10597","1825","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10598","1825","2010-11-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10599","1825","2010-11-25 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10600","1825","2010-12-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10601","1825","2010-12-09 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10602","1825","2010-12-16 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("10603","1826","2010-11-04 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10604","1826","2010-11-11 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10605","1826","2010-11-18 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10606","1826","2010-11-25 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10607","1826","2010-12-02 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10608","1826","2010-12-09 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10609","1826","2010-12-16 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10610","1827","2010-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10611","1827","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10612","1827","2010-11-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10613","1827","2010-11-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10614","1827","2010-12-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10615","1827","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10616","1827","2010-12-16 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10617","1828","2010-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10618","1828","2010-11-18 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10619","1828","2010-12-02 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10620","1828","2010-12-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10621","1829","2010-11-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10622","1829","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10623","1829","2010-11-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10624","1829","2010-11-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10625","1829","2010-12-02 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10626","1829","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10627","1829","2010-12-16 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10628","1830","2010-11-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10629","1830","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10630","1830","2010-11-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10631","1830","2010-11-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10632","1830","2010-12-02 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10633","1830","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10634","1830","2010-12-16 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10635","1831","2010-11-04 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10636","1831","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10637","1831","2010-11-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10638","1831","2010-11-25 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10639","1831","2010-12-02 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10640","1831","2010-12-09 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10641","1831","2010-12-16 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10642","1832","2010-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10643","1832","2010-11-11 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10644","1832","2010-11-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10645","1832","2010-11-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10646","1832","2010-12-02 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10647","1832","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10648","1832","2010-12-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10649","1833","2010-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10650","1833","2010-11-11 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10651","1833","2010-11-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10652","1833","2010-12-02 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10653","1833","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10654","1833","2010-12-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10655","1834","2010-11-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10656","1834","2010-11-11 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10657","1834","2010-11-18 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10658","1834","2010-11-25 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10659","1834","2010-12-02 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10660","1834","2010-12-09 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10661","1834","2010-12-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10662","1835","2010-11-04 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10663","1835","2010-11-11 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10664","1835","2010-11-18 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10665","1835","2010-11-25 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10666","1835","2010-12-02 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10667","1835","2010-12-09 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10668","1835","2010-12-16 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10669","1836","2010-11-04 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10670","1836","2010-11-11 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10671","1836","2010-11-18 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10672","1836","2010-11-25 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10673","1836","2010-12-02 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10674","1836","2010-12-09 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10675","1836","2010-12-16 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10676","1837","2010-11-04 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10677","1837","2010-11-11 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10678","1837","2010-11-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10679","1837","2010-11-25 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("10680","1837","2010-12-02 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10681","1837","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10682","1837","2010-12-16 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10683","1838","2010-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10684","1838","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10685","1838","2010-11-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10686","1838","2010-11-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10687","1838","2010-12-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10688","1838","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10689","1838","2010-12-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10690","1839","2010-11-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10691","1839","2010-11-11 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10692","1839","2010-11-18 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10693","1839","2010-11-25 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10694","1839","2010-12-02 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10695","1839","2010-12-09 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10696","1839","2010-12-16 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10697","1840","2010-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10698","1840","2010-11-11 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10699","1840","2010-11-18 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10700","1840","2010-11-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10701","1840","2010-12-02 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10702","1840","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10703","1841","2010-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10704","1841","2010-11-11 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10705","1841","2010-11-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10706","1841","2010-11-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10707","1841","2010-12-02 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10708","1841","2010-12-09 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10709","1841","2010-12-16 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10710","1842","2010-11-04 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10711","1842","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10712","1842","2010-11-18 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10713","1842","2010-11-25 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10714","1842","2010-12-02 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10715","1842","2010-12-09 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10716","1842","2010-12-16 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10717","1843","2010-11-04 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10718","1843","2010-11-11 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10719","1843","2010-11-18 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10720","1843","2010-11-25 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10721","1843","2010-12-02 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10722","1843","2010-12-09 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10723","1843","2010-12-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10724","1844","2010-11-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10725","1844","2010-11-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10726","1844","2010-11-18 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10727","1844","2010-11-25 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10728","1844","2010-12-02 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10729","1844","2010-12-09 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10730","1844","2010-12-16 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10731","1845","2010-11-04 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10732","1845","2010-11-11 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10733","1845","2010-11-18 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10734","1845","2010-11-25 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10735","1845","2010-12-02 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10736","1845","2010-12-09 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10737","1845","2010-12-16 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10738","1846","2010-11-04 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10739","1846","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10740","1846","2010-11-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10741","1846","2010-11-25 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10742","1846","2010-12-02 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10743","1846","2010-12-09 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10744","1846","2010-12-16 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10745","1847","2010-11-04 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10746","1847","2010-11-11 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10747","1847","2010-11-18 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10748","1847","2010-11-25 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10749","1847","2010-12-02 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10750","1847","2010-12-09 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10751","1847","2010-12-16 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10752","1848","2010-11-04 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10753","1848","2010-11-11 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10754","1848","2010-11-18 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10755","1848","2010-11-25 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10756","1848","2010-12-02 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10757","1848","2010-12-09 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10758","1848","2010-12-16 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10759","1849","2010-11-04 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10760","1849","2010-11-11 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10761","1849","2010-11-18 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10762","1849","2010-11-25 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10763","1849","2010-12-02 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10764","1849","2010-12-09 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10765","1849","2010-12-16 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10766","1850","2010-11-04 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10767","1850","2010-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10768","1850","2010-11-18 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10769","1850","2010-11-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10770","1850","2010-12-02 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10771","1850","2010-12-16 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10772","1851","2010-11-04 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10773","1851","2010-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10774","1851","2010-11-18 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10775","1851","2010-11-25 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10776","1851","2010-12-02 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10777","1851","2010-12-09 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10778","1851","2010-12-16 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10779","1852","2010-11-05 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10780","1852","2010-11-19 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10781","1852","2010-12-03 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("10782","1852","2010-12-10 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10783","1852","2010-12-17 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10784","1853","2010-11-05 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10785","1853","2010-11-11 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10786","1853","2010-11-19 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10787","1853","2010-11-26 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10788","1853","2010-12-03 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10789","1853","2010-12-10 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10790","1853","2010-12-17 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10791","1854","2010-11-05 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10792","1854","2010-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10793","1854","2010-11-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10794","1854","2010-11-26 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10795","1854","2010-12-03 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10796","1854","2010-12-10 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10797","1854","2010-12-17 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10798","1855","2010-11-05 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10799","1855","2010-11-11 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10800","1855","2010-11-19 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10801","1855","2010-11-26 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10802","1855","2010-12-03 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10803","1855","2010-12-10 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10804","1855","2010-12-17 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10805","1856","2010-11-05 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10806","1856","2010-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10807","1856","2010-11-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10808","1856","2010-11-26 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10809","1856","2010-12-03 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10810","1856","2010-12-10 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10811","1856","2010-12-17 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10812","1857","2010-11-05 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10813","1857","2010-11-11 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10814","1857","2010-11-19 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10815","1857","2010-11-26 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10816","1857","2010-12-03 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10817","1857","2010-12-10 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10818","1857","2010-12-17 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10819","1858","2010-11-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10820","1858","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10821","1858","2010-11-19 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10822","1858","2010-11-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10823","1858","2010-12-03 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10824","1858","2010-12-10 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10825","1858","2010-12-17 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10826","1859","2010-11-05 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10827","1859","2010-11-11 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10828","1859","2010-11-19 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10829","1859","2010-11-26 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10830","1859","2010-12-03 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10831","1859","2010-12-10 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10832","1859","2010-12-17 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10833","1860","2010-11-05 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10834","1860","2010-11-11 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10835","1860","2010-11-19 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10836","1860","2010-11-26 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10837","1860","2010-12-03 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10838","1860","2010-12-17 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10839","1861","2010-11-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10840","1861","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10841","1861","2010-11-19 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10842","1861","2010-11-26 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10843","1861","2010-12-03 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10844","1861","2010-12-10 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10845","1861","2010-12-17 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10846","1862","2010-11-05 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10847","1862","2010-11-11 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10848","1862","2010-11-19 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10849","1862","2010-11-26 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10850","1862","2010-12-03 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10851","1862","2010-12-10 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10852","1862","2010-12-17 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10853","1863","2010-11-05 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10854","1863","2010-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10855","1863","2010-11-19 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10856","1863","2010-11-26 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10857","1863","2010-12-03 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10858","1863","2010-12-10 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("10859","1863","2010-12-17 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10860","1864","2010-11-05 00:00:00","7","3","0","0");
INSERT INTO tr_orderdetails VALUES("10861","1864","2010-11-11 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("10862","1864","2010-11-19 00:00:00","7","3","0","0");
INSERT INTO tr_orderdetails VALUES("10863","1864","2010-12-17 00:00:00","36","3","0","0");
INSERT INTO tr_orderdetails VALUES("10864","1865","2010-11-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10865","1865","2010-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10866","1865","2010-11-19 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10867","1865","2010-11-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10868","1865","2010-12-03 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10869","1865","2010-12-10 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10870","1865","2010-12-17 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10871","1866","2010-11-05 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10872","1866","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10873","1866","2010-11-19 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10874","1866","2010-11-26 00:00:00","39","1","0","0");
INSERT INTO tr_orderdetails VALUES("10875","1866","2010-12-03 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10876","1866","2010-12-10 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10877","1866","2010-12-17 00:00:00","39","1","0","0");
INSERT INTO tr_orderdetails VALUES("10878","1867","2010-11-05 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10879","1867","2010-11-11 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10880","1867","2010-11-19 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10881","1867","2010-11-26 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10882","1867","2010-12-03 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10883","1867","2010-12-10 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10884","1867","2010-12-17 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10885","1868","2010-11-05 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10886","1868","2010-11-11 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10887","1868","2010-11-19 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10888","1868","2010-11-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10889","1868","2010-12-03 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10890","1868","2010-12-10 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10891","1868","2010-12-17 00:00:00","33","3","0","0");
INSERT INTO tr_orderdetails VALUES("10892","1869","2010-11-05 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10893","1869","2010-11-11 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10894","1869","2010-11-19 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10895","1869","2010-11-26 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10896","1869","2010-12-03 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10897","1870","2010-11-05 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10898","1870","2010-11-19 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10899","1870","2010-12-03 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10900","1870","2010-12-17 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10901","1871","2010-11-05 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10902","1871","2010-11-11 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10903","1871","2010-11-19 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10904","1871","2010-11-26 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10905","1871","2010-12-03 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10906","1872","2010-11-05 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10907","1872","2010-11-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10908","1872","2010-11-19 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10909","1872","2010-11-26 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10910","1872","2010-12-03 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10911","1872","2010-12-10 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10912","1872","2010-12-17 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10913","1873","2010-11-05 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10914","1873","2010-11-11 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10915","1873","2010-11-19 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10916","1873","2010-11-26 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10917","1873","2010-12-03 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10918","1873","2010-12-10 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10919","1873","2010-12-17 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10920","1874","2010-11-05 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10921","1874","2010-11-11 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10922","1874","2010-11-19 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10923","1874","2010-11-26 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10924","1874","2010-12-03 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10925","1874","2010-12-10 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10926","1874","2010-12-17 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10927","1875","2010-11-05 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10928","1875","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10929","1875","2010-11-19 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("10930","1875","2010-11-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10931","1875","2010-12-03 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10932","1875","2010-12-10 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10933","1875","2010-12-17 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10934","1876","2010-11-05 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10935","1876","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10936","1876","2010-11-19 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10937","1876","2010-11-26 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("10938","1876","2010-12-03 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10939","1876","2010-12-10 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10940","1876","2010-12-17 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10941","1877","2010-11-05 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10942","1877","2010-11-11 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10943","1877","2010-11-19 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10944","1877","2010-11-26 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10945","1877","2010-12-03 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10946","1877","2010-12-10 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10947","1877","2010-12-17 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10948","1878","2010-11-05 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10949","1878","2010-11-11 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10950","1878","2010-11-19 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10951","1878","2010-11-26 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10952","1878","2010-12-03 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10953","1878","2010-12-10 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10954","1878","2010-12-17 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10955","1879","2010-11-05 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10956","1879","2010-11-11 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10957","1879","2010-11-19 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10958","1879","2010-11-26 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10959","1879","2010-12-03 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10960","1879","2010-12-10 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10961","1879","2010-12-17 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10962","1880","2010-11-05 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10963","1880","2010-11-11 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10964","1880","2010-11-19 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10965","1880","2010-11-26 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10966","1880","2010-12-03 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10967","1880","2010-12-10 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10968","1880","2010-12-17 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10969","1881","2010-11-05 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10970","1881","2010-11-19 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10971","1881","2010-12-03 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10972","1881","2010-12-17 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10973","1882","2010-11-05 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10974","1882","2010-11-11 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10975","1882","2010-11-19 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10976","1882","2010-11-26 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10977","1882","2010-12-03 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10978","1882","2010-12-10 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("10979","1882","2010-12-17 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10980","1883","2010-11-05 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10981","1883","2010-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10982","1883","2010-11-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("10983","1883","2010-12-03 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("10984","1884","2010-11-05 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("10985","1884","2010-12-03 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("10986","1885","2010-11-05 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10987","1885","2010-11-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10988","1885","2010-11-19 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10989","1885","2010-11-26 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10990","1885","2010-12-03 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10991","1885","2010-12-10 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("10992","1885","2010-12-17 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10993","1886","2010-11-11 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("10994","1886","2010-11-19 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("10995","1886","2010-12-03 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("10996","1886","2010-12-10 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("10997","1886","2010-12-17 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("10998","1887","2010-11-05 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("10999","1887","2010-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("11000","1887","2010-11-19 00:00:00","34","1","0","0");
INSERT INTO tr_orderdetails VALUES("11001","1887","2010-11-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("11002","1887","2010-12-03 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("11003","1887","2010-12-10 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("11004","1887","2010-12-17 00:00:00","5","1","0","0");
INSERT INTO tr_orderdetails VALUES("11005","1888","2010-11-05 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("11006","1888","2010-11-11 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("11007","1888","2010-11-19 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("11008","1888","2010-11-26 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("11009","1888","2010-12-03 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("11010","1888","2010-12-10 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("11011","1888","2010-12-17 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("11012","1889","2010-11-05 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("11013","1889","2010-11-11 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("11014","1889","2010-11-19 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("11015","1889","2010-11-26 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("11016","1889","2010-12-03 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("11017","1889","2010-12-10 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("11018","1889","2010-12-17 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("11019","1890","2010-11-05 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("11020","1890","2010-11-11 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("11021","1890","2010-11-19 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("11022","1890","2010-11-26 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("11023","1890","2010-12-03 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("11024","1890","2010-12-10 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("11025","1890","2010-12-17 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("11026","1891","2010-11-05 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("11027","1891","2010-11-19 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("11028","1891","2010-12-03 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("11029","1891","2010-12-17 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("11030","1892","2010-11-05 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("11031","1892","2010-11-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("11032","1892","2010-11-19 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("11033","1892","2010-11-26 00:00:00","34","2","0","0");
INSERT INTO tr_orderdetails VALUES("11034","1892","2010-12-03 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("11035","1892","2010-12-10 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("11036","1892","2010-12-17 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("11037","1893","2010-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("11038","1893","2010-11-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("11039","1893","2010-12-10 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("11040","1894","2010-11-05 00:00:00","36","1","0","0");
INSERT INTO tr_orderdetails VALUES("11041","1894","2010-11-11 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("11042","1894","2010-11-19 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("11043","1894","2010-11-26 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("11044","1894","2010-12-03 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("11045","1894","2010-12-10 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("11046","1894","2010-12-17 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("11047","1895","2010-11-05 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("11048","1895","2010-11-11 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("11049","1895","2010-11-19 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("11050","1895","2010-11-26 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("11051","1895","2010-12-03 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("11052","1895","2010-12-10 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("11053","1895","2010-12-17 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("11054","1896","2010-11-05 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("11055","1896","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("11056","1896","2010-11-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("11057","1896","2010-11-26 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("11058","1896","2010-12-03 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("11059","1896","2010-12-10 00:00:00","7","1","0","0");
INSERT INTO tr_orderdetails VALUES("11060","1896","2010-12-17 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("11061","1897","2010-11-05 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("11062","1897","2010-11-11 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("11063","1897","2010-11-19 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("11064","1897","2010-11-26 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("11065","1897","2010-12-03 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("11066","1897","2010-12-10 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("11067","1897","2010-12-17 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("11068","1898","2010-11-05 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("11069","1898","2010-11-19 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("11070","1898","2010-12-03 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("11071","1898","2010-12-17 00:00:00","33","1","0","0");
INSERT INTO tr_orderdetails VALUES("11072","1899","2010-11-05 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("11073","1899","2010-11-11 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("11074","1899","2010-11-19 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("11075","1899","2010-11-26 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("11076","1899","2010-12-03 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("11077","1899","2010-12-10 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("11078","1899","2010-12-17 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("11079","1900","2010-11-26 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("11080","1900","2010-12-10 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("11081","1900","2010-12-17 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("11082","1900","2010-12-03 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("11083","1901","2010-11-26 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("11084","1901","2010-12-03 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("11085","1901","2010-12-10 00:00:00","64","1","0","0");
INSERT INTO tr_orderdetails VALUES("11086","1901","2010-12-17 00:00:00","2","1","0","0");
INSERT INTO tr_orderdetails VALUES("11087","1902","2010-11-05 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("11088","1902","2010-11-19 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("11089","1902","2010-12-03 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("11090","1902","2010-12-17 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("11091","1903","2010-11-05 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("11092","1903","2010-11-11 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("11093","1903","2010-11-19 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("11094","1903","2010-11-26 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("11095","1903","2010-12-03 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("11096","1903","2010-12-10 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("11097","1903","2010-12-17 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("11098","1904","2010-11-05 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("11099","1904","2010-11-11 00:00:00","34","2","0","0");
INSERT INTO tr_orderdetails VALUES("11100","1904","2010-11-19 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("11101","1904","2010-11-26 00:00:00","36","2","0","0");
INSERT INTO tr_orderdetails VALUES("11102","1904","2010-12-03 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("11103","1904","2010-12-10 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VALUES("11104","1904","2010-12-17 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("11105","1905","2010-11-05 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("11106","1905","2010-11-11 00:00:00","33","3","0","0");
INSERT INTO tr_orderdetails VALUES("11107","1905","2010-11-19 00:00:00","64","3","0","0");
INSERT INTO tr_orderdetails VALUES("11108","1905","2010-11-26 00:00:00","5","3","0","0");
INSERT INTO tr_orderdetails VALUES("11109","1905","2010-12-03 00:00:00","33","3","0","0");
INSERT INTO tr_orderdetails VALUES("11110","1905","2010-12-10 00:00:00","64","3","0","0");
INSERT INTO tr_orderdetails VALUES("11111","1905","2010-12-17 00:00:00","7","3","0","0");
INSERT INTO tr_orderdetails VALUES("11112","1906","2010-11-05 00:00:00","5","2","0","0");
INSERT INTO tr_orderdetails VALUES("11113","1906","2010-11-11 00:00:00","2","2","0","0");
INSERT INTO tr_orderdetails VALUES("11114","1906","2010-11-19 00:00:00","7","2","0","0");
INSERT INTO tr_orderdetails VALUES("11115","1906","2010-11-26 00:00:00","33","2","0","0");
INSERT INTO tr_orderdetails VALUES("11116","1906","2010-12-03 00:00:00","64","2","0","0");
INSERT INTO tr_orderdetails VAL